/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.disk.strategy;

import org.apache.iotdb.commons.utils.JVMCommonUtils;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategy;

public class MaxDiskUsableSpaceFirstStrategy
extends DirectoryStrategy {
    @Override
    public int nextFolderIndex() throws DiskSpaceInsufficientException {
        return this.getMaxSpaceFolder();
    }

    public int getMaxSpaceFolder() throws DiskSpaceInsufficientException {
        int maxIndex = -1;
        long maxSpace = 0L;
        for (int i = 0; i < this.folders.size(); ++i) {
            long space;
            String folder = (String)this.folders.get(i);
            if (!JVMCommonUtils.hasSpace((String)folder) || (space = JVMCommonUtils.getUsableSpace((String)folder)) <= maxSpace) continue;
            maxSpace = space;
            maxIndex = i;
        }
        if (maxIndex == -1) {
            throw new DiskSpaceInsufficientException(this.folders);
        }
        return maxIndex;
    }
}

