/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.eventstream.HeaderValue;
import software.amazon.eventstream.Message;

@SdkProtectedApi
public final class AwsClientHandlerUtils {
    private AwsClientHandlerUtils() {
    }

    public static ByteBuffer encodeEventStreamRequestToByteBuffer(SdkHttpFullRequest request) {
        byte[] payload;
        LinkedHashMap headers = new LinkedHashMap();
        request.forEachHeader((name, value) -> headers.put(name, HeaderValue.fromString((String)((String)CollectionUtils.firstIfPresent((List)value)))));
        if (request.contentStreamProvider().isPresent()) {
            try {
                payload = IoUtils.toByteArray((InputStream)((ContentStreamProvider)request.contentStreamProvider().get()).newStream());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            payload = new byte[]{};
        }
        return new Message(headers, payload).toByteBuffer();
    }
}

