/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.queues;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

final class SingletonQueue<T>
implements Queue<T> {
    private final AtomicReference<T> element = new AtomicReference();

    SingletonQueue() {
    }

    @Override
    public boolean add(T t) {
        return this.offer(t);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c.isEmpty()) {
            return true;
        }
        if (c.size() == 1) {
            return this.offer(c.iterator().next());
        }
        return false;
    }

    @Override
    public void clear() {
        this.element.set(null);
    }

    @Override
    public boolean contains(Object o) {
        return Objects.equals(this.element.get(), o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.isEmpty()) {
            return true;
        }
        if (c.size() == 1) {
            return Objects.equals(c.iterator().next(), this.peek());
        }
        return false;
    }

    @Override
    public T element() {
        return this.element.get();
    }

    @Override
    public boolean isEmpty() {
        return this.element.get() == null;
    }

    @Override
    public Iterator<T> iterator() {
        return new SingletonIterator(this);
    }

    @Override
    public boolean offer(T t) {
        if (this.element.get() != null) {
            return false;
        }
        this.element.lazySet(t);
        return true;
    }

    @Override
    public T peek() {
        return this.element.get();
    }

    @Override
    public T poll() {
        T v = this.element.get();
        if (v != null) {
            this.element.lazySet(null);
        }
        return v;
    }

    @Override
    public T remove() {
        return this.element.getAndSet(null);
    }

    @Override
    public boolean remove(Object o) {
        try {
            return this.element.compareAndSet(o, null);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public int size() {
        return this.element.get() == null ? 0 : 1;
    }

    @Override
    public Object[] toArray() {
        T t = this.element.get();
        if (t == null) {
            return new Object[0];
        }
        return new Object[]{t};
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if (size == 1) {
            a[0] = this.element.get();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    private static final class SingletonIterator<T>
    implements Iterator<T> {
        final SingletonQueue<T> queue;
        final AtomicBoolean consumed = new AtomicBoolean();

        public SingletonIterator(SingletonQueue<T> queue) {
            this.queue = queue;
        }

        @Override
        public boolean hasNext() {
            if (this.queue.isEmpty()) {
                return false;
            }
            return !this.consumed.get();
        }

        @Override
        public T next() {
            if (this.consumed.compareAndSet(false, true)) {
                return this.queue.peek();
            }
            return null;
        }

        @Override
        public void remove() {
            this.queue.remove();
        }
    }
}

