/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity.table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.table.TableLikeEntity;

public class IcebergTableLikeEntity
extends TableLikeEntity {
    public static final String METADATA_LOCATION_KEY = "metadata-location";
    public static final String USER_SPECIFIED_WRITE_DATA_LOCATION_KEY = "write.data.path";
    public static final String USER_SPECIFIED_WRITE_METADATA_LOCATION_KEY = "write.metadata.path";
    public static final String LAST_ADMITTED_NOTIFICATION_TIMESTAMP_KEY = "last-notification-timestamp";

    public IcebergTableLikeEntity(PolarisBaseEntity sourceEntity) {
        super(sourceEntity);
    }

    public static IcebergTableLikeEntity of(PolarisBaseEntity sourceEntity) {
        if (sourceEntity != null) {
            return new IcebergTableLikeEntity(sourceEntity);
        }
        return null;
    }

    @JsonIgnore
    public String getMetadataLocation() {
        return this.getInternalPropertiesAsMap().get(METADATA_LOCATION_KEY);
    }

    @JsonIgnore
    public Optional<Long> getLastAdmittedNotificationTimestamp() {
        return Optional.ofNullable(this.getInternalPropertiesAsMap().get(LAST_ADMITTED_NOTIFICATION_TIMESTAMP_KEY)).map(Long::parseLong);
    }

    @Override
    @JsonIgnore
    public String getBaseLocation() {
        return this.getPropertiesAsMap().get("location");
    }

    public static class Builder
    extends PolarisEntity.BaseBuilder<IcebergTableLikeEntity, Builder> {
        public Builder(TableIdentifier identifier, String metadataLocation) {
            this.setType(PolarisEntityType.TABLE_LIKE);
            this.setTableIdentifier(identifier);
            this.setMetadataLocation(metadataLocation);
        }

        public Builder(IcebergTableLikeEntity original) {
            super(original);
        }

        @Override
        public IcebergTableLikeEntity build() {
            return new IcebergTableLikeEntity(this.buildBase());
        }

        public Builder setTableIdentifier(TableIdentifier identifier) {
            Namespace namespace = identifier.namespace();
            this.setParentNamespace(namespace);
            this.setName(identifier.name());
            return this;
        }

        public Builder setParentNamespace(Namespace namespace) {
            if (namespace != null && !namespace.isEmpty()) {
                this.internalProperties.put("parent-namespace", RESTUtil.encodeNamespace((Namespace)namespace));
            }
            return this;
        }

        public Builder setBaseLocation(String location) {
            this.properties.put("location", location);
            return this;
        }

        public Builder setMetadataLocation(String location) {
            this.internalProperties.put(IcebergTableLikeEntity.METADATA_LOCATION_KEY, location);
            return this;
        }

        public Builder setLastNotificationTimestamp(long timestamp) {
            this.internalProperties.put(IcebergTableLikeEntity.LAST_ADMITTED_NOTIFICATION_TIMESTAMP_KEY, String.valueOf(timestamp));
            return this;
        }
    }
}

