/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.marshaller.optimized;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.client.marshaller.GridClientMarshaller;
import org.apache.ignite.internal.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.PluginProvider;
import org.jetbrains.annotations.Nullable;

public class GridClientZipOptimizedMarshaller
extends GridClientOptimizedMarshaller {
    public static final byte ID = 3;
    private static final int DFLT_BUFFER_SIZE = 4096;
    private final GridClientMarshaller dfltMarsh;

    public GridClientZipOptimizedMarshaller(GridClientMarshaller dfltMarsh, @Nullable List<PluginProvider> plugins) {
        super(plugins);
        assert (dfltMarsh != null);
        this.dfltMarsh = dfltMarsh;
    }

    public GridClientMarshaller defaultMarshaller() {
        return this.dfltMarsh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zipBytes(byte[] input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            ZipEntry entry = new ZipEntry("");
            try {
                entry.setSize(input.length);
                zos.putNextEntry(entry);
                zos.write(input);
            }
            finally {
                zos.closeEntry();
            }
        }
        return baos.toByteArray();
    }

    private static byte[] unzipBytes(byte[] input) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        try (ZipInputStream zis = new ZipInputStream(bais);){
            zis.getNextEntry();
            byte[] buf = new byte[4096];
            int len = zis.read(buf);
            while (len > 0) {
                baos.write(buf, 0, len);
                len = zis.read(buf);
            }
        }
        return baos.toByteArray();
    }

    @Override
    public ByteBuffer marshal(Object obj, int off) throws IOException {
        try {
            if (!(obj instanceof GridClientMessage)) {
                throw new IOException("Message serialization of given type is not supported: " + obj.getClass().getName());
            }
            byte[] marshBytes = U.marshal(this.opMarsh, obj);
            boolean zip = marshBytes.length > 512;
            byte[] bytes = zip ? GridClientZipOptimizedMarshaller.zipBytes(marshBytes) : marshBytes;
            ByteBuffer buf = ByteBuffer.allocate(off + bytes.length + 1);
            buf.position(off);
            buf.put((byte)(zip ? 1 : 0));
            buf.put(bytes);
            buf.flip();
            return buf;
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public <T> T unmarshal(byte[] bytes) throws IOException {
        try {
            boolean unzip = bytes[0] > 0;
            byte[] marshBytes = Arrays.copyOfRange(bytes, 1, bytes.length);
            return U.unmarshal((Marshaller)this.opMarsh, unzip ? GridClientZipOptimizedMarshaller.unzipBytes(marshBytes) : marshBytes, null);
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }
}

