/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.ext.wikilink.WikiLink;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.wikilink.WikiNode;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkOptions;
import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TextCollectingVisitor;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.IRichSequence;
import org.jetbrains.annotations.NotNull;

public class WikiLinkLinkRefProcessor
implements LinkRefProcessor {
    static final int BRACKET_NESTING_LEVEL = 1;
    private final WikiLinkOptions options;

    public WikiLinkLinkRefProcessor(Document document) {
        this.options = new WikiLinkOptions((DataHolder)document);
    }

    public boolean getWantExclamationPrefix() {
        return this.options.imageLinks;
    }

    public int getBracketNestingLevel() {
        return 1;
    }

    public boolean isMatch(@NotNull BasedSequence nodeChars) {
        int length = nodeChars.length();
        if (this.options.imageLinks) {
            if (length >= 5 && nodeChars.charAt(0) == '!') {
                return nodeChars.charAt(1) == '[' && nodeChars.charAt(2) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
            }
            if (length >= 4) {
                return nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
            }
        } else if (length >= 4) {
            return nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
        }
        return false;
    }

    @NotNull
    public BasedSequence adjustInlineText(@NotNull Document document, @NotNull Node node) {
        assert (node instanceof WikiNode);
        WikiNode wikiNode = (WikiNode)node;
        return (BasedSequence)wikiNode.getText().ifNull((IRichSequence)wikiNode.getLink());
    }

    public boolean allowDelimiters(@NotNull BasedSequence chars, @NotNull Document document, @NotNull Node node) {
        assert (node instanceof WikiNode);
        WikiNode wikiNode = (WikiNode)node;
        return node instanceof WikiLink && (Boolean)WikiLinkExtension.ALLOW_INLINES.get((DataHolder)document) != false && ((BasedSequence)wikiNode.getText().ifNull((IRichSequence)wikiNode.getLink())).containsAllOf(chars);
    }

    public void updateNodeElements(@NotNull Document document, @NotNull Node node) {
        assert (node instanceof WikiNode);
        WikiNode wikiNode = (WikiNode)node;
        if (node instanceof WikiLink && ((Boolean)WikiLinkExtension.ALLOW_INLINES.get((DataHolder)document)).booleanValue() && wikiNode.getText().isNull()) {
            BasedSequence link = new TextCollectingVisitor().collectAndGetSequence(node, TextContainer.F_NODE_TEXT);
            wikiNode.setLink(link, (Boolean)WikiLinkExtension.ALLOW_ANCHORS.get((DataHolder)document), (Boolean)WikiLinkExtension.ALLOW_ANCHOR_ESCAPE.get((DataHolder)document));
        }
    }

    @NotNull
    public Node createNode(@NotNull BasedSequence nodeChars) {
        return nodeChars.firstChar() == '!' ? new WikiImage(nodeChars, this.options.linkFirstSyntax, this.options.allowPipeEscape) : new WikiLink(nodeChars, this.options.linkFirstSyntax, this.options.allowAnchors, this.options.allowPipeEscape, this.options.allowAnchorEscape);
    }

    public static class Factory
    implements LinkRefProcessorFactory {
        @NotNull
        public LinkRefProcessor apply(@NotNull Document document) {
            return new WikiLinkLinkRefProcessor(document);
        }

        public boolean getWantExclamationPrefix(@NotNull DataHolder options) {
            return (Boolean)WikiLinkExtension.IMAGE_LINKS.get(options);
        }

        public int getBracketNestingLevel(@NotNull DataHolder options) {
            return 1;
        }
    }
}

