/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforce;

import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.DeletedRecord;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.GetDeletedResult;
import com.sforce.soap.partner.GetUpdatedResult;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.fault.ExceptionCode;
import com.sforce.soap.partner.fault.LoginFault;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.bind.XmlObject;
import jakarta.xml.soap.SOAPException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceRecordValue;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SalesforceConnection {
    private static final FieldType ID_FIELD_TYPE = FieldType.id;
    private static final FieldType REFERENCE_FIELD_TYPE = FieldType.reference;
    private static final Class<?> PKG = SalesforceConnection.class;
    public static final String CONST_ARROW_LEFT = "<-----------------------------------------";
    public static final String CONST_ARROW_RIGHT = "----------------------------------------->";
    public static final String SERVICES_SOAP_U_64_0 = "/services/Soap/u/64.0";
    public static final String CONST_INVALID_SESSION_ID = "INVALID_SESSION_ID";
    public static final String CONST_INVALID_SESSION_ID_ALTERNATE = "Invalid Session ID";
    private String url;
    private String username;
    private String password;
    private String module;
    private int timeOut;
    private PartnerConnection binding;
    private LoginResult loginResult;
    private GetUserInfoResult userInfo;
    private String authenticationType = "USERNAME_PASSWORD";
    private String oauthClientId;
    private String oauthClientSecret;
    private String oauthAccessToken;
    private String oauthRefreshToken;
    private String oauthInstanceUrl;
    private String oauthJwtPrivateKey;
    private String sql;
    private Date serverTimestamp;
    private QueryResult qr;
    private GregorianCalendar startDate;
    private GregorianCalendar endDate;
    private SObject[] sObjects;
    private int recordsFilter;
    private String fieldsList;
    private int queryResultSize;
    private int recordsCount;
    private boolean useCompression;
    private boolean rollbackAllChangesOnError;
    private boolean queryAll;
    private HashMap<String, Date> getDeletedList;
    private ILogChannel log;

    public SalesforceConnection(ILogChannel logInterface, String url, String username, String password) throws HopException {
        this.log = logInterface == null ? HopLogStore.getLogChannelFactory().create((Object)this) : logInterface;
        this.url = url;
        this.setUsername(username);
        this.setPassword(password);
        this.setTimeOut(0);
        this.binding = null;
        this.loginResult = null;
        this.userInfo = null;
        this.sql = null;
        this.serverTimestamp = null;
        this.qr = null;
        this.startDate = null;
        this.endDate = null;
        this.sObjects = null;
        this.recordsFilter = 0;
        this.fieldsList = null;
        this.queryResultSize = 0;
        this.recordsCount = 0;
        this.setUsingCompression(false);
        this.setRollbackAllChangesOnError(false);
        if (Utils.isEmpty((CharSequence)this.getUrl())) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.TargetURLMissing.Error", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.getUsername())) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.UsernameMissing.Error", (String[])new String[0]));
        }
        if (this.log.isDetailed()) {
            logInterface.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.NewConnection", (String[])new String[0]));
        }
    }

    @Deprecated(since="2.16", forRemoval=false)
    public SalesforceConnection(ILogChannel logInterface, String oauthClientId, String oauthClientSecret, String oauthAccessToken, String oauthInstanceUrl) throws HopException {
        this(logInterface, oauthClientId, oauthClientSecret, oauthAccessToken, oauthInstanceUrl, false);
    }

    private SalesforceConnection(ILogChannel logInterface, String param1, String param2, String param3, String param4, boolean isJwt) throws HopException {
        this.log = logInterface == null ? HopLogStore.getLogChannelFactory().create((Object)this) : logInterface;
        if (isJwt) {
            this.authenticationType = "OAUTH_JWT";
            this.username = param1;
            this.oauthClientId = param2;
            this.oauthJwtPrivateKey = param3;
            this.url = param4;
        } else {
            this.authenticationType = "OAUTH";
            this.oauthClientId = param1;
            this.oauthClientSecret = param2;
            this.oauthAccessToken = param3;
            this.oauthInstanceUrl = param4;
        }
        this.setTimeOut(0);
        this.binding = null;
        this.loginResult = null;
        this.userInfo = null;
        this.sql = null;
        this.serverTimestamp = null;
        this.qr = null;
        this.startDate = null;
        this.endDate = null;
        this.sObjects = null;
        this.recordsFilter = 0;
        this.fieldsList = null;
        this.queryResultSize = 0;
        this.recordsCount = 0;
        this.setUsingCompression(false);
        this.setRollbackAllChangesOnError(false);
        if (isJwt) {
            if (Utils.isEmpty((CharSequence)param1)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.JwtUsernameMissing.Error", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)param2)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.JwtConsumerKeyMissing.Error", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)param3)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.JwtPrivateKeyMissing.Error", (String[])new String[0]));
            }
            if (this.log.isDetailed()) {
                logInterface.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.NewOAuthJwtConnection", (String[])new String[0]));
            }
        } else {
            if (Utils.isEmpty((CharSequence)param1)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.OAuthClientIdMissing.Error", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)param3)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.OAuthAccessTokenMissing.Error", (String[])new String[0]));
            }
            if (this.log.isDetailed()) {
                logInterface.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.NewOAuthConnection", (String[])new String[0]));
            }
        }
    }

    public static SalesforceConnection createJwtConnection(ILogChannel logInterface, String jwtUsername, String jwtConsumerKey, String jwtPrivateKey, String jwtTokenEndpoint) throws HopException {
        return new SalesforceConnection(logInterface, jwtUsername, jwtConsumerKey, jwtPrivateKey, jwtTokenEndpoint, true);
    }

    public void setCalendar(int recordsFilter, GregorianCalendar startDate, GregorianCalendar endDate) throws HopException {
        this.startDate = startDate;
        this.endDate = endDate;
        this.recordsFilter = recordsFilter;
        if (this.startDate == null || this.endDate == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.EmptyStartDateOrEndDate", (String[])new String[0]));
        }
        if (this.startDate.getTime().compareTo(this.endDate.getTime()) >= 0) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.WrongDates", (String[])new String[0]));
        }
        long diffDays = (this.endDate.getTime().getTime() - this.startDate.getTime().getTime()) / 86400000L;
        if (diffDays > 30L) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.StartDateTooOlder", (String[])new String[0]));
        }
    }

    public QueryResult getQueryResult() {
        return this.qr;
    }

    public PartnerConnection createBinding(ConnectorConfig config) throws ConnectionException {
        if (this.binding == null) {
            this.binding = new PartnerConnection(config);
        }
        return this.binding;
    }

    public boolean isUsingCompression() {
        return this.useCompression;
    }

    public void setUsingCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isOAuthAuthentication() {
        return "OAUTH".equalsIgnoreCase(this.authenticationType);
    }

    public boolean isUsernamePasswordAuthentication() {
        return "USERNAME_PASSWORD".equalsIgnoreCase(this.authenticationType);
    }

    public boolean isOAuthJwtAuthentication() {
        return "OAUTH_JWT".equalsIgnoreCase(this.authenticationType);
    }

    public void connect() throws HopException {
        if (this.isOAuthAuthentication()) {
            this.connectWithOAuth();
        } else if (this.isOAuthJwtAuthentication()) {
            this.connectWithOAuthJwt();
        } else {
            this.connectWithUsernamePassword();
        }
    }

    private void connectWithUsernamePassword() throws HopException {
        ConnectorConfig config = new ConnectorConfig();
        config.setAuthEndpoint(this.getUrl());
        config.setServiceEndpoint(this.getUrl());
        config.setUsername(this.getUsername());
        config.setPassword(this.getPassword());
        config.setCompression(this.isUsingCompression());
        config.setManualLogin(true);
        String proxyUrl = System.getProperty("http.proxyHost", null);
        if (StringUtils.isNotEmpty((String)proxyUrl)) {
            int proxyPort = Integer.parseInt(System.getProperty("http.proxyPort", "80"));
            String proxyUser = System.getProperty("http.proxyUser", null);
            String proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)System.getProperty("http.proxyPassword", null));
            config.setProxy(proxyUrl, proxyPort);
            config.setProxyUsername(proxyUser);
            config.setProxyPassword(proxyPassword);
        }
        if (this.getTimeOut() > 0) {
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.SettingTimeout", (String[])new String[]{"" + this.timeOut}));
            }
            config.setConnectionTimeout(this.getTimeOut());
            config.setReadTimeout(this.getTimeOut());
        }
        try {
            PartnerConnection pConnection = this.createBinding(config);
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginURL", (String[])new String[]{config.getAuthEndpoint()}));
            }
            if (this.isRollbackAllChangesOnError()) {
                pConnection.setAllOrNoneHeader(true);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginNow", (String[])new String[0]));
                this.log.logDetailed(CONST_ARROW_RIGHT);
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginURL", (String[])new String[]{this.getUrl()}));
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginUsername", (String[])new String[]{this.getUsername()}));
                if (this.getModule() != null) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.LoginModule", (String[])new String[]{this.getModule()}));
                }
                this.log.logDetailed(CONST_ARROW_LEFT);
            }
            this.loginResult = pConnection.login(config.getUsername(), Encr.decryptPasswordOptionallyEncrypted((String)config.getPassword()));
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.SessionId", (String[])new String[0]) + " : " + this.loginResult.getSessionId());
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.NewServerURL", (String[])new String[0]) + " : " + this.loginResult.getServerUrl());
            }
            pConnection.setSessionHeader(this.loginResult.getSessionId());
            config.setServiceEndpoint(this.loginResult.getServerUrl());
            this.userInfo = pConnection.getUserInfo();
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserInfos", (String[])new String[0]) + " : " + this.userInfo.getUserFullName());
                this.log.logDebug(CONST_ARROW_RIGHT);
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserName", (String[])new String[0]) + " : " + this.userInfo.getUserFullName());
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserEmail", (String[])new String[0]) + " : " + this.userInfo.getUserEmail());
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserLanguage", (String[])new String[0]) + " : " + this.userInfo.getUserLanguage());
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.UserOrganization", (String[])new String[0]) + " : " + this.userInfo.getOrganizationName());
                this.log.logDebug(CONST_ARROW_LEFT);
            }
            this.serverTimestamp = pConnection.getServerTimestamp().getTimestamp().getTime();
            if (this.log.isDebug()) {
                BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.ServerTimestamp", (Object[])new Object[]{this.getServerTimestamp()});
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.Connected", (String[])new String[0]));
            }
        }
        catch (LoginFault ex) {
            ExceptionCode exCode = ex.getExceptionCode();
            if (exCode == ExceptionCode.FUNCTIONALITY_NOT_ENABLED || exCode == ExceptionCode.INVALID_CLIENT || exCode == ExceptionCode.INVALID_LOGIN || exCode == ExceptionCode.LOGIN_DURING_RESTRICTED_DOMAIN || exCode == ExceptionCode.LOGIN_DURING_RESTRICTED_TIME || exCode == ExceptionCode.ORG_LOCKED || exCode == ExceptionCode.PASSWORD_LOCKOUT || exCode == ExceptionCode.SERVER_UNAVAILABLE || exCode == ExceptionCode.TRIAL_EXPIRED || exCode == ExceptionCode.UNSUPPORTED_CLIENT) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.InvalidUsernameOrPassword", (String[])new String[0]));
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.Connection", (String[])new String[0]), (Throwable)ex);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.Connection", (String[])new String[0]), (Throwable)e);
        }
    }

    private void connectWithOAuth() throws HopException {
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.OAuthLoginNow", (String[])new String[0]));
                this.log.logDetailed(CONST_ARROW_RIGHT);
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.OAuthInstanceURL", (String[])new String[]{this.getOauthInstanceUrl()}));
                this.log.logDetailed(CONST_ARROW_LEFT);
            }
            if (Utils.isEmpty((CharSequence)this.getOauthClientId())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.OAuthClientIdMissing.Error", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)this.getOauthInstanceUrl())) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.OAuthInstanceUrlMissing.Error", (String[])new String[0]));
            }
            String accessToken = this.getOauthAccessToken();
            if (Utils.isEmpty((CharSequence)accessToken) && !Utils.isEmpty((CharSequence)this.getOauthRefreshToken()) && (accessToken = this.refreshAccessToken()) != null) {
                this.setOauthAccessToken(accessToken);
            }
            if (Utils.isEmpty((CharSequence)accessToken)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.OAuthAccessTokenMissing.Error", (String[])new String[0]));
            }
            this.url = this.getOauthInstanceUrl();
            this.loginResult = null;
            ConnectorConfig config = new ConnectorConfig();
            config.setAuthEndpoint(this.getOauthInstanceUrl() + SERVICES_SOAP_U_64_0);
            config.setServiceEndpoint(this.getOauthInstanceUrl() + SERVICES_SOAP_U_64_0);
            config.setManualLogin(true);
            config.setSessionId(this.getOauthAccessToken());
            this.binding = new PartnerConnection(config);
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.OAuthConnected", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.OAuthConnection", (String[])new String[0]), (Throwable)e);
        }
    }

    private void connectWithOAuthJwt() throws HopException {
        try {
            String accessToken;
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.JwtLoginNow", (String[])new String[0]));
                this.log.logDetailed(CONST_ARROW_RIGHT);
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.JwtUsername", (String[])new String[]{this.username}));
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.JwtTokenEndpoint", (String[])new String[]{this.url}));
                this.log.logDetailed(CONST_ARROW_LEFT);
            }
            if (Utils.isEmpty((CharSequence)(accessToken = this.generateJwtAndGetAccessToken()))) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.JwtTokenGenerationFailed.Error", (String[])new String[0]));
            }
            String instanceUrl = this.oauthInstanceUrl;
            if (Utils.isEmpty((CharSequence)instanceUrl)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.OAuthInstanceUrlMissing.Error", (String[])new String[0]));
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed("Using instance URL from token response: " + instanceUrl);
            }
            ConnectorConfig config = new ConnectorConfig();
            config.setAuthEndpoint(instanceUrl + SERVICES_SOAP_U_64_0);
            config.setServiceEndpoint(instanceUrl + SERVICES_SOAP_U_64_0);
            config.setManualLogin(true);
            config.setSessionId(accessToken);
            config.setCompression(this.isUsingCompression());
            if (this.getTimeOut() > 0) {
                config.setConnectionTimeout(this.getTimeOut());
                config.setReadTimeout(this.getTimeOut());
            }
            this.binding = new PartnerConnection(config);
            this.oauthAccessToken = accessToken;
            if (this.isRollbackAllChangesOnError()) {
                this.binding.setAllOrNoneHeader(true);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.JwtConnected", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.JwtConnection", (String[])new String[0]), (Throwable)e);
        }
    }

    private String generateJwtAndGetAccessToken() throws HopException {
        try {
            String line;
            String jwtToken = this.buildJwtAssertion();
            Object tokenUrl = this.url;
            if (!((String)tokenUrl).endsWith("/services/oauth2/token")) {
                if (!((String)tokenUrl).endsWith("/")) {
                    tokenUrl = (String)tokenUrl + "/";
                }
                tokenUrl = (String)tokenUrl + "services/oauth2/token";
            }
            URL url = new URL((String)tokenUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            StringBuilder requestBody = new StringBuilder();
            requestBody.append("grant_type=").append(URLEncoder.encode("urn:ietf:params:oauth:grant-type:jwt-bearer", StandardCharsets.UTF_8));
            requestBody.append("&assertion=").append(URLEncoder.encode(jwtToken, StandardCharsets.UTF_8));
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = requestBody.toString().getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            BufferedReader reader = responseCode >= 200 && responseCode < 300 ? new BufferedReader(new InputStreamReader(connection.getInputStream())) : new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            if (responseCode >= 200 && responseCode < 300) {
                String responseStr = response.toString();
                String accessToken = this.extractJsonValue(responseStr, "access_token");
                String instanceUrl = this.extractJsonValue(responseStr, "instance_url");
                if (!Utils.isEmpty((CharSequence)instanceUrl)) {
                    this.oauthInstanceUrl = instanceUrl;
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Successfully obtained access token via JWT bearer flow");
                }
                return accessToken;
            }
            throw new HopException("JWT token exchange failed with response code " + responseCode + ": " + String.valueOf(response));
        }
        catch (Exception e) {
            throw new HopException("Failed to generate JWT and obtain access token: " + e.getMessage(), (Throwable)e);
        }
    }

    private String buildJwtAssertion() throws Exception {
        String header = "{\"alg\":\"RS256\"}";
        String encodedHeader = this.base64UrlEncode(header.getBytes(StandardCharsets.UTF_8));
        long now = System.currentTimeMillis() / 1000L;
        long exp = now + 300L;
        String audienceUrl = this.url;
        if (audienceUrl.contains("/services/oauth2")) {
            audienceUrl = audienceUrl.substring(0, audienceUrl.indexOf("/services/oauth2"));
        }
        if (audienceUrl.endsWith("/")) {
            audienceUrl = audienceUrl.substring(0, audienceUrl.length() - 1);
        }
        String claims = "{\"iss\":\"" + this.oauthClientId + "\",\"sub\":\"" + this.username + "\",\"aud\":\"" + audienceUrl + "\",\"exp\":" + exp + "}";
        String encodedClaims = this.base64UrlEncode(claims.getBytes(StandardCharsets.UTF_8));
        String signatureInput = encodedHeader + "." + encodedClaims;
        String signature = this.signWithRSA(signatureInput, this.oauthJwtPrivateKey);
        return signatureInput + "." + signature;
    }

    private String signWithRSA(String data, String privateKeyPem) throws Exception {
        String privateKeyContent = privateKeyPem.replaceAll("-----BEGIN.*?-----", "").replaceAll("-----END.*?-----", "").replaceAll("\\s", "");
        byte[] keyBytes = Base64.getDecoder().decode(privateKeyContent);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(data.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = signature.sign();
        return this.base64UrlEncode(signatureBytes);
    }

    private String base64UrlEncode(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(data);
    }

    private boolean checkForInvalidSessionId(Exception e) {
        Throwable current = e;
        for (int depth = 0; current != null && depth < 10; current = current.getCause(), ++depth) {
            String message = current.getMessage();
            if (message != null && (message.contains(CONST_INVALID_SESSION_ID) || message.contains(CONST_INVALID_SESSION_ID_ALTERNATE))) {
                return true;
            }
            if (!(current instanceof UnexpectedErrorFault)) continue;
            try {
                String exceptionCode;
                block8: {
                    exceptionCode = null;
                    try {
                        Field exceptionCodeField = current.getClass().getDeclaredField("exceptionCode");
                        exceptionCodeField.setAccessible(true);
                        exceptionCode = (String)exceptionCodeField.get(current);
                    }
                    catch (Exception e1) {
                        try {
                            Method getExceptionCodeMethod = current.getClass().getMethod("getExceptionCode", new Class[0]);
                            exceptionCode = (String)getExceptionCodeMethod.invoke((Object)current, new Object[0]);
                        }
                        catch (Exception e2) {
                            String toString = current.toString();
                            if (!toString.contains(CONST_INVALID_SESSION_ID)) break block8;
                            return true;
                        }
                    }
                }
                if (exceptionCode == null || !CONST_INVALID_SESSION_ID.equals(exceptionCode)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private String refreshAccessToken() throws HopException {
        try {
            String line;
            if (Utils.isEmpty((CharSequence)this.getOauthRefreshToken())) {
                throw new HopException("No refresh token available for token refresh");
            }
            Object tokenUrl = this.getOauthInstanceUrl();
            if (!((String)tokenUrl).endsWith("/")) {
                tokenUrl = (String)tokenUrl + "/";
            }
            tokenUrl = (String)tokenUrl + "services/oauth2/token";
            URL url = new URL((String)tokenUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            StringBuilder requestBody = new StringBuilder();
            requestBody.append("grant_type=refresh_token&");
            requestBody.append("client_id=").append(URLEncoder.encode(this.getOauthClientId(), StandardCharsets.UTF_8)).append("&");
            requestBody.append("client_secret=").append(URLEncoder.encode(this.getOauthClientSecret(), StandardCharsets.UTF_8)).append("&");
            requestBody.append("refresh_token=").append(URLEncoder.encode(this.getOauthRefreshToken(), StandardCharsets.UTF_8));
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = requestBody.toString().getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            BufferedReader reader = responseCode >= 200 && responseCode < 300 ? new BufferedReader(new InputStreamReader(connection.getInputStream())) : new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            if (responseCode >= 200 && responseCode < 300) {
                String responseStr = response.toString();
                String newAccessToken = this.extractJsonValue(responseStr, "access_token");
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Successfully refreshed OAuth access token");
                }
                return newAccessToken;
            }
            throw new HopException("Token refresh failed with response code " + responseCode + ": " + response.toString());
        }
        catch (Exception e) {
            throw new HopException("Failed to refresh OAuth access token: " + e.getMessage(), (Throwable)e);
        }
    }

    private String extractJsonValue(String json, String key) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        String pattern = "\"" + key + "\"\\s*:\\s*\"([^\"]+)\"";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(json);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private QueryResult executeQueryWithTokenRefresh(QueryExecutor queryExecutor) throws Exception {
        try {
            return queryExecutor.execute();
        }
        catch (Exception e) {
            boolean isTokenExpired = false;
            for (Throwable current = e; current != null; current = current.getCause()) {
                String message = current.getMessage();
                if (message == null || !message.contains(CONST_INVALID_SESSION_ID) && !message.contains(CONST_INVALID_SESSION_ID_ALTERNATE)) continue;
                isTokenExpired = true;
                break;
            }
            if (isTokenExpired && this.isOAuthAuthentication() && !Utils.isEmpty((CharSequence)this.getOauthRefreshToken())) {
                this.log.logDetailed("Access token expired during query, attempting to refresh...");
                try {
                    String newAccessToken = this.refreshAccessToken();
                    this.getBinding().setSessionHeader(newAccessToken);
                    this.log.logDetailed("Successfully refreshed access token, retrying query...");
                    return queryExecutor.execute();
                }
                catch (Exception refreshException) {
                    this.log.logError("Failed to refresh access token during query: " + refreshException.getMessage());
                    throw e;
                }
            }
            throw e;
        }
    }

    public void query(boolean specifyQuery) throws HopException {
        if (this.getBinding() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Exception.CanNotGetBiding", (String[])new String[0]));
        }
        try {
            if (!specifyQuery) {
                DescribeSObjectResult describeSObjectResult = null;
                try {
                    describeSObjectResult = this.getBinding().describeSObject(this.getModule());
                }
                catch (Exception e) {
                    this.log.logDetailed("Exception caught in describeSObject: " + e.getMessage());
                    this.log.logDetailed("isOAuthAuthentication: " + this.isOAuthAuthentication());
                    this.log.logDetailed("hasRefreshToken: " + !Utils.isEmpty((CharSequence)this.getOauthRefreshToken()));
                    boolean isTokenExpired = false;
                    Throwable current = e;
                    for (int depth = 0; current != null && depth < 10; current = current.getCause(), ++depth) {
                        String message = current.getMessage();
                        this.log.logDetailed("Exception chain depth " + depth + ": " + current.getClass().getSimpleName() + " - " + message);
                        if (message != null && (message.contains(CONST_INVALID_SESSION_ID) || message.contains(CONST_INVALID_SESSION_ID_ALTERNATE))) {
                            this.log.logDetailed("Found INVALID_SESSION_ID in exception chain at depth " + depth);
                            isTokenExpired = true;
                            break;
                        }
                        if (!(current instanceof UnexpectedErrorFault)) continue;
                        try {
                            String exceptionCode;
                            block31: {
                                exceptionCode = null;
                                try {
                                    Field exceptionCodeField = current.getClass().getDeclaredField("exceptionCode");
                                    exceptionCodeField.setAccessible(true);
                                    exceptionCode = (String)exceptionCodeField.get(current);
                                }
                                catch (Exception e1) {
                                    try {
                                        Method getExceptionCodeMethod = current.getClass().getMethod("getExceptionCode", new Class[0]);
                                        exceptionCode = (String)getExceptionCodeMethod.invoke((Object)current, new Object[0]);
                                    }
                                    catch (Exception e2) {
                                        String toString = current.toString();
                                        this.log.logDetailed("UnexpectedErrorFault toString: " + toString);
                                        if (!toString.contains(CONST_INVALID_SESSION_ID)) break block31;
                                        this.log.logDetailed("Found INVALID_SESSION_ID in UnexpectedErrorFault toString");
                                        isTokenExpired = true;
                                        break;
                                    }
                                }
                            }
                            if (exceptionCode == null) continue;
                            this.log.logDetailed("UnexpectedErrorFault exceptionCode: " + exceptionCode);
                            if (!CONST_INVALID_SESSION_ID.equals(exceptionCode)) continue;
                            this.log.logDetailed("Found INVALID_SESSION_ID in UnexpectedErrorFault exceptionCode");
                            isTokenExpired = true;
                            break;
                        }
                        catch (Exception reflectionException) {
                            this.log.logDetailed("Could not access UnexpectedErrorFault fields: " + reflectionException.getMessage());
                        }
                    }
                    this.log.logDetailed("Exception chain analysis complete. isTokenExpired: " + isTokenExpired);
                    if (isTokenExpired && this.isOAuthAuthentication() && !Utils.isEmpty((CharSequence)this.getOauthRefreshToken())) {
                        this.log.logDetailed("Access token expired, attempting to refresh...");
                        try {
                            String newAccessToken = this.refreshAccessToken();
                            this.getBinding().setSessionHeader(newAccessToken);
                            this.log.logDetailed("Successfully refreshed access token, retrying query...");
                            describeSObjectResult = this.getBinding().describeSObject(this.getModule());
                        }
                        catch (Exception refreshException) {
                            this.log.logError("Failed to refresh access token: " + refreshException.getMessage());
                            throw e;
                        }
                    }
                    throw e;
                }
                if (describeSObjectResult == null) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorGettingObject", (String[])new String[0]));
                }
                if (!describeSObjectResult.isQueryable()) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ObjectNotQueryable", (String[])new String[]{this.module}));
                }
                if (!(this.recordsFilter != 1 && this.recordsFilter != 2 || describeSObjectResult.isReplicateable())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.ObjectNotReplicable", (String[])new String[]{this.getModule()}));
                }
            }
            if (this.getSql() != null && this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.SQLString", (String[])new String[0]) + " : " + this.getSql());
            }
            switch (this.recordsFilter) {
                case 1: {
                    int nr;
                    GetUpdatedResult updatedRecords = this.getBinding().getUpdated(this.getModule(), (Calendar)this.startDate, (Calendar)this.endDate);
                    if (updatedRecords.getIds() == null || (nr = updatedRecords.getIds().length) <= 0) break;
                    String[] ids = updatedRecords.getIds();
                    if (nr > 2000) {
                        this.sObjects = new SObject[nr];
                        ArrayList<String> list = new ArrayList<String>();
                        int desPos = 0;
                        for (int i = 0; i < nr; ++i) {
                            list.add(updatedRecords.getIds()[i]);
                            if (i % 2000 != 0 && i != nr - 1) continue;
                            SObject[] s = this.getBinding().retrieve(this.fieldsList, this.getModule(), list.toArray(new String[list.size()]));
                            System.arraycopy(s, 0, this.sObjects, desPos, s.length);
                            desPos += s.length;
                            s = null;
                            list = new ArrayList();
                        }
                    } else {
                        this.sObjects = this.getBinding().retrieve(this.fieldsList, this.getModule(), ids);
                    }
                    if (this.sObjects == null) break;
                    this.queryResultSize = this.sObjects.length;
                    break;
                }
                case 2: {
                    GetDeletedResult deletedRecordsResult = this.getBinding().getDeleted(this.getModule(), (Calendar)this.startDate, (Calendar)this.endDate);
                    DeletedRecord[] deletedRecords = deletedRecordsResult.getDeletedRecords();
                    if (this.log.isDebug()) {
                        this.log.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"SalesforceConnection.DeletedRecordsFound", (String[])new String[]{String.valueOf(deletedRecords == null ? 0 : deletedRecords.length)})});
                    }
                    if (deletedRecords == null || deletedRecords.length <= 0) break;
                    this.getDeletedList = new HashMap();
                    for (DeletedRecord dr : deletedRecords) {
                        this.getDeletedList.put(dr.getId(), dr.getDeletedDate().getTime());
                    }
                    this.qr = this.executeQueryWithTokenRefresh(() -> this.getBinding().queryAll(this.getSql()));
                    this.sObjects = this.getQueryResult().getRecords();
                    if (this.sObjects == null) break;
                    this.queryResultSize = this.sObjects.length;
                    break;
                }
                default: {
                    this.qr = this.isQueryAll() ? this.executeQueryWithTokenRefresh(() -> this.getBinding().queryAll(this.getSql())) : this.executeQueryWithTokenRefresh(() -> this.getBinding().query(this.getSql()));
                    this.sObjects = this.getQueryResult().getRecords();
                    this.queryResultSize = this.getQueryResult().getSize();
                }
            }
            if (this.sObjects != null) {
                this.recordsCount = this.sObjects.length;
            }
        }
        catch (Exception e) {
            this.log.logError(Const.getStackTracker((Throwable)e));
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Exception.Query", (String[])new String[0]), (Throwable)e);
        }
    }

    public void close() throws HopException {
        try {
            if (!this.getQueryResult().isDone()) {
                this.qr.setDone(true);
                this.qr = null;
            }
            if (this.sObjects != null) {
                this.sObjects = null;
            }
            if (this.binding != null) {
                this.binding = null;
            }
            if (this.loginResult != null) {
                this.loginResult = null;
            }
            if (this.userInfo != null) {
                this.userInfo = null;
            }
            if (this.getDeletedList != null) {
                this.getDeletedList.clear();
                this.getDeletedList = null;
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceConnection.Log.ConnectionClosed", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.ClosingConnection", (String[])new String[0]), (Throwable)e);
        }
    }

    public int getQueryResultSize() {
        return this.queryResultSize;
    }

    public int getRecordsCount() {
        return this.recordsCount;
    }

    public SalesforceRecordValue getRecord(int recordIndex) {
        int index = recordIndex;
        SObject con = this.sObjects[index];
        SalesforceRecordValue retval = new SalesforceRecordValue(index);
        if (con == null) {
            return null;
        }
        if (this.recordsFilter == 2) {
            if (this.getDeletedList.containsKey(con.getId())) {
                retval.setRecordValue(con);
                retval.setDeletionDate(this.getDeletedList.get(con.getId()));
            } else if (index < this.getRecordsCount() - 1) {
                while (con != null && index < this.getRecordsCount() - 1 && !this.getDeletedList.containsKey(con.getId())) {
                    con = this.sObjects[++index];
                }
                retval.setRecordIndexChanges(true);
                retval.setRecordIndex(index);
                if (con != null && SalesforceConnection.getChildren(con)[index] != null && this.getDeletedList.containsKey(con.getId())) {
                    retval.setRecordValue(con);
                    retval.setDeletionDate(this.getDeletedList.get(con.getId()));
                }
            }
            retval.setAllRecordsProcessed(index >= this.getRecordsCount() - 1);
        } else {
            retval.setRecordValue(con);
        }
        return retval;
    }

    public String getRecordValue(SObject con, String fieldname) throws HopException {
        String[] fieldHierarchy = fieldname.split("\\.");
        if (con == null) {
            return null;
        }
        XmlObject element = this.getMessageElementForHierarchy(con, fieldHierarchy);
        if (element != null) {
            Object object = element.getValue();
            if (object != null) {
                if (object instanceof QueryResult) {
                    QueryResult queryResult = (QueryResult)object;
                    return this.buildJsonQueryResult(queryResult);
                }
                return String.valueOf(object);
            }
            return (String)element.getValue();
        }
        return null;
    }

    private XmlObject getMessageElementForHierarchy(SObject con, String[] fieldHierarchy) {
        int lastIndex = fieldHierarchy.length - 1;
        SObject currentSObject = con;
        block0: for (int index = 0; index <= lastIndex; ++index) {
            for (XmlObject element : SalesforceConnection.getChildren(currentSObject)) {
                SObject sObject;
                if (!element.getName().getLocalPart().equals(fieldHierarchy[index])) continue;
                if (index == lastIndex) {
                    return element;
                }
                if (!(element instanceof SObject)) continue block0;
                currentSObject = sObject = (SObject)element;
                continue block0;
            }
        }
        return null;
    }

    private String buildJsonQueryResult(QueryResult queryResult) throws HopException {
        JSONArray list = new JSONArray();
        for (SObject sobject : queryResult.getRecords()) {
            list.add((Object)this.buildJSONSObject(sobject));
        }
        StringWriter sw = new StringWriter();
        try {
            list.writeJSONString((Writer)sw);
        }
        catch (IOException e) {
            throw new HopException((Throwable)e);
        }
        return sw.toString();
    }

    private JSONObject buildJSONSObject(SObject sobject) {
        JSONObject jsonObject = new JSONObject();
        for (XmlObject element : SalesforceConnection.getChildren(sobject)) {
            Object object = element.getValue();
            if (object != null && object instanceof SObject) {
                SObject sObject = (SObject)object;
                jsonObject.put((Object)element.getName(), (Object)this.buildJSONSObject(sObject));
                continue;
            }
            jsonObject.put((Object)element.getName(), element.getValue());
        }
        return jsonObject;
    }

    public XmlObject[] getElements() throws Exception {
        SObject con;
        XmlObject[] result = null;
        this.qr = this.getBinding().query(this.getSql());
        if (this.qr.getSize() > 0 && (con = this.getQueryResult().getRecords()[0]) != null) {
            result = SalesforceConnection.getChildren(con);
        }
        return result;
    }

    public boolean queryMore() throws HopException {
        try {
            if (!this.getQueryResult().isDone()) {
                this.qr = this.getBinding().queryMore(this.getQueryResult().getQueryLocator());
                this.sObjects = this.getQueryResult().getRecords();
                if (this.sObjects != null) {
                    this.recordsCount = this.sObjects.length;
                }
                this.queryResultSize = this.getQueryResult().getSize();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.QueringMore", (String[])new String[0]), (Throwable)e);
        }
    }

    public String[] getAllAvailableObjects(boolean onlyQueryableObjects) throws HopException {
        DescribeGlobalResult dgr = null;
        ArrayList<String> objects = null;
        DescribeGlobalSObjectResult[] sobjectResults = null;
        try {
            dgr = this.getBinding().describeGlobal();
            sobjectResults = dgr.getSobjects();
            int nrObjects = dgr.getSobjects().length;
            objects = new ArrayList<String>();
            for (int i = 0; i < nrObjects; ++i) {
                DescribeGlobalSObjectResult o = dgr.getSobjects()[i];
                if ((!onlyQueryableObjects || !o.isQueryable()) && onlyQueryableObjects) continue;
                objects.add(o.getName());
            }
            String[] stringArray = objects.toArray(new String[objects.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.GettingModules", (String[])new String[0]), (Throwable)e);
        }
        finally {
            if (dgr != null) {
                dgr = null;
            }
            if (objects != null) {
                objects.clear();
                objects = null;
            }
            if (sobjectResults != null) {
                sobjectResults = null;
            }
        }
    }

    public com.sforce.soap.partner.Field[] getObjectFields(String objectName) throws HopException {
        DescribeSObjectResult describeSObjectResult = null;
        try {
            describeSObjectResult = this.getBinding().describeSObject(objectName);
            if (describeSObjectResult == null) {
                com.sforce.soap.partner.Field[] fieldArray = null;
                return fieldArray;
            }
            if (!describeSObjectResult.isQueryable()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ObjectNotQueryable", (String[])new String[]{this.module}));
            }
            com.sforce.soap.partner.Field[] fieldArray = describeSObjectResult.getFields();
            return fieldArray;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.Error.GettingModuleFields", (String[])new String[]{this.module}), (Throwable)e);
        }
        finally {
            if (describeSObjectResult != null) {
                describeSObjectResult = null;
            }
        }
    }

    public com.sforce.soap.partner.Field[] getObjectFields(String objectName, boolean excludeNonUpdatableFields) throws HopException {
        com.sforce.soap.partner.Field[] fieldList = this.getObjectFields(objectName);
        if (excludeNonUpdatableFields) {
            ArrayList<com.sforce.soap.partner.Field> finalFieldList = new ArrayList<com.sforce.soap.partner.Field>();
            for (com.sforce.soap.partner.Field f : fieldList) {
                if (!this.isIdField(f) && (f.isCalculated() || !f.isUpdateable())) continue;
                finalFieldList.add(f);
            }
            fieldList = finalFieldList.toArray(new com.sforce.soap.partner.Field[finalFieldList.size()]);
        }
        return fieldList;
    }

    private boolean isIdField(com.sforce.soap.partner.Field field) {
        return field.getType() == ID_FIELD_TYPE;
    }

    private boolean isReferenceField(com.sforce.soap.partner.Field field) {
        return field.getType() == REFERENCE_FIELD_TYPE;
    }

    public String[] getFields(String objectName) throws HopException {
        return this.getFields(this.getObjectFields(objectName));
    }

    public String[] getFields(String objectName, boolean excludeNonUpdatableFields) throws HopException {
        return this.getFields(this.getObjectFields(objectName, excludeNonUpdatableFields), excludeNonUpdatableFields);
    }

    public String[] getFields(com.sforce.soap.partner.Field[] fields) throws HopException {
        if (fields != null) {
            int nrFields = fields.length;
            String[] fieldsMapp = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                com.sforce.soap.partner.Field field = fields[i];
                fieldsMapp[i] = field.getName();
            }
            return fieldsMapp;
        }
        return null;
    }

    public String[] getFields(com.sforce.soap.partner.Field[] fields, boolean excludeNonUpdatableFields) throws HopException {
        if (fields != null) {
            ArrayList<String> fieldsList = new ArrayList<String>(fields.length);
            for (com.sforce.soap.partner.Field field : fields) {
                com.sforce.soap.partner.Field[] referenceObjectFields;
                fieldsList.add(field.getName());
                if (!this.isReferenceField(field)) continue;
                String referenceTo = field.getReferenceTo()[0];
                for (com.sforce.soap.partner.Field f : referenceObjectFields = this.getObjectFields(referenceTo, excludeNonUpdatableFields)) {
                    if (!f.isIdLookup() || this.isIdField(f)) continue;
                    fieldsList.add(String.format("%s:%s/%s", referenceTo, f.getName(), field.getRelationshipName()));
                }
            }
            return fieldsList.toArray(new String[fieldsList.size()]);
        }
        return null;
    }

    public UpsertResult[] upsert(String upsertField, SObject[] sfBuffer) throws HopException {
        try {
            return this.getBinding().upsert(upsertField, sfBuffer);
        }
        catch (Exception e) {
            boolean isTokenExpired = this.checkForInvalidSessionId(e);
            if (isTokenExpired && this.isOAuthAuthentication() && !Utils.isEmpty((CharSequence)this.getOauthRefreshToken())) {
                this.log.logDetailed("Access token expired during upsert, attempting to refresh...");
                try {
                    String newAccessToken = this.refreshAccessToken();
                    this.getBinding().setSessionHeader(newAccessToken);
                    this.log.logDetailed("Successfully refreshed access token, retrying upsert...");
                    return this.getBinding().upsert(upsertField, sfBuffer);
                }
                catch (Exception refreshException) {
                    this.log.logError("Failed to refresh access token during upsert: " + refreshException.getMessage());
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorUpsert", (Object[])new Object[]{e}));
                }
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorUpsert", (Object[])new Object[]{e}));
        }
    }

    public SaveResult[] insert(SObject[] sfBuffer) throws HopException {
        ArrayList<SObject> normalizedSfBuffer = new ArrayList<SObject>();
        for (SObject part : sfBuffer) {
            if (part == null) continue;
            normalizedSfBuffer.add(part);
        }
        SObject[] normalizedArray = normalizedSfBuffer.toArray(new SObject[normalizedSfBuffer.size()]);
        try {
            return this.getBinding().create(normalizedArray);
        }
        catch (Exception e) {
            boolean isTokenExpired = this.checkForInvalidSessionId(e);
            if (isTokenExpired && this.isOAuthAuthentication() && !Utils.isEmpty((CharSequence)this.getOauthRefreshToken())) {
                this.log.logDetailed("Access token expired during insert, attempting to refresh...");
                try {
                    String newAccessToken = this.refreshAccessToken();
                    this.getBinding().setSessionHeader(newAccessToken);
                    this.log.logDetailed("Successfully refreshed access token, retrying insert...");
                    return this.getBinding().create(normalizedArray);
                }
                catch (Exception refreshException) {
                    this.log.logError("Failed to refresh access token during insert: " + refreshException.getMessage());
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorInsert", (Object[])new Object[]{e}));
                }
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorInsert", (Object[])new Object[]{e}));
        }
    }

    public SaveResult[] update(SObject[] sfBuffer) throws HopException {
        try {
            return this.getBinding().update(sfBuffer);
        }
        catch (Exception e) {
            boolean isTokenExpired = this.checkForInvalidSessionId(e);
            if (isTokenExpired && this.isOAuthAuthentication() && !Utils.isEmpty((CharSequence)this.getOauthRefreshToken())) {
                this.log.logDetailed("Access token expired during update, attempting to refresh...");
                try {
                    String newAccessToken = this.refreshAccessToken();
                    this.getBinding().setSessionHeader(newAccessToken);
                    this.log.logDetailed("Successfully refreshed access token, retrying update...");
                    return this.getBinding().update(sfBuffer);
                }
                catch (Exception refreshException) {
                    this.log.logError("Failed to refresh access token during update: " + refreshException.getMessage());
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorUpdate", (Object[])new Object[]{e}));
                }
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorUpdate", (Object[])new Object[]{e}));
        }
    }

    public DeleteResult[] delete(String[] id) throws HopException {
        try {
            return this.getBinding().delete(id);
        }
        catch (Exception e) {
            boolean isTokenExpired = this.checkForInvalidSessionId(e);
            if (isTokenExpired && this.isOAuthAuthentication() && !Utils.isEmpty((CharSequence)this.getOauthRefreshToken())) {
                this.log.logDetailed("Access token expired during delete, attempting to refresh...");
                try {
                    String newAccessToken = this.refreshAccessToken();
                    this.getBinding().setSessionHeader(newAccessToken);
                    this.log.logDetailed("Successfully refreshed access token, retrying delete...");
                    return this.getBinding().delete(id);
                }
                catch (Exception refreshException) {
                    this.log.logError("Failed to refresh access token during delete: " + refreshException.getMessage());
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorDelete", (Object[])new Object[]{e}));
                }
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.ErrorDelete", (Object[])new Object[]{e}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XmlObject createMessageElement(String name, Object value, boolean useExternalKey) throws Exception {
        XmlObject me = null;
        if (!useExternalKey) return SalesforceConnection.fromTemplateElement(name, value, true);
        int indexOfType = name.indexOf(":");
        if (indexOfType <= 0) throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceConnection.UnableToFindObjectType", (String[])new String[0]));
        String type = name.substring(0, indexOfType);
        String extIdName = null;
        String lookupField = null;
        String rest = name.substring(indexOfType + 1);
        int indexOfExtId = rest.indexOf("/");
        if (indexOfExtId > 0) {
            extIdName = rest.substring(0, indexOfExtId);
            lookupField = rest.substring(indexOfExtId + 1);
            return SalesforceConnection.createForeignKeyElement(type, lookupField, extIdName, value);
        } else {
            lookupField = extIdName = rest;
        }
        return SalesforceConnection.createForeignKeyElement(type, lookupField, extIdName, value);
    }

    private static XmlObject createForeignKeyElement(String type, String lookupField, String extIdName, Object extIdValue) throws Exception {
        XmlObject me = SalesforceConnection.fromTemplateElement(lookupField, null, false);
        me.addField("type", (Object)type);
        me.addField(extIdName, extIdValue);
        return me;
    }

    public static XmlObject fromTemplateElement(String name, Object value, boolean setValue) throws SOAPException {
        XmlObject me = new XmlObject();
        if (setValue) {
            me.setValue(value);
        }
        me.setName(new QName(name));
        return me;
    }

    public static XmlObject[] getChildren(SObject object) {
        List<String> reservedFieldNames = Arrays.asList("type", "fieldsToNull");
        if (object == null) {
            return null;
        }
        ArrayList<XmlObject> children = new ArrayList<XmlObject>();
        Iterator iterator = object.getChildren();
        while (iterator.hasNext()) {
            XmlObject child = (XmlObject)iterator.next();
            if (child.getName().getNamespaceURI().equals("urn:sobject.partner.soap.sforce.com") && reservedFieldNames.contains(child.getName().getLocalPart())) continue;
            children.add(child);
        }
        if (children.isEmpty()) {
            return null;
        }
        return children.toArray(new XmlObject[children.size()]);
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getModule() {
        return this.module;
    }

    @Generated
    public int getTimeOut() {
        return this.timeOut;
    }

    @Generated
    public PartnerConnection getBinding() {
        return this.binding;
    }

    @Generated
    public LoginResult getLoginResult() {
        return this.loginResult;
    }

    @Generated
    public GetUserInfoResult getUserInfo() {
        return this.userInfo;
    }

    @Generated
    public String getAuthenticationType() {
        return this.authenticationType;
    }

    @Generated
    public String getOauthClientId() {
        return this.oauthClientId;
    }

    @Generated
    public String getOauthClientSecret() {
        return this.oauthClientSecret;
    }

    @Generated
    public String getOauthAccessToken() {
        return this.oauthAccessToken;
    }

    @Generated
    public String getOauthRefreshToken() {
        return this.oauthRefreshToken;
    }

    @Generated
    public String getOauthInstanceUrl() {
        return this.oauthInstanceUrl;
    }

    @Generated
    public String getOauthJwtPrivateKey() {
        return this.oauthJwtPrivateKey;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public Date getServerTimestamp() {
        return this.serverTimestamp;
    }

    @Generated
    public QueryResult getQr() {
        return this.qr;
    }

    @Generated
    public GregorianCalendar getStartDate() {
        return this.startDate;
    }

    @Generated
    public GregorianCalendar getEndDate() {
        return this.endDate;
    }

    @Generated
    public SObject[] getSObjects() {
        return this.sObjects;
    }

    @Generated
    public int getRecordsFilter() {
        return this.recordsFilter;
    }

    @Generated
    public String getFieldsList() {
        return this.fieldsList;
    }

    @Generated
    public boolean isUseCompression() {
        return this.useCompression;
    }

    @Generated
    public boolean isRollbackAllChangesOnError() {
        return this.rollbackAllChangesOnError;
    }

    @Generated
    public boolean isQueryAll() {
        return this.queryAll;
    }

    @Generated
    public HashMap<String, Date> getGetDeletedList() {
        return this.getDeletedList;
    }

    @Generated
    public ILogChannel getLog() {
        return this.log;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setModule(String module) {
        this.module = module;
    }

    @Generated
    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    @Generated
    public void setBinding(PartnerConnection binding) {
        this.binding = binding;
    }

    @Generated
    public void setLoginResult(LoginResult loginResult) {
        this.loginResult = loginResult;
    }

    @Generated
    public void setUserInfo(GetUserInfoResult userInfo) {
        this.userInfo = userInfo;
    }

    @Generated
    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    @Generated
    public void setOauthClientId(String oauthClientId) {
        this.oauthClientId = oauthClientId;
    }

    @Generated
    public void setOauthClientSecret(String oauthClientSecret) {
        this.oauthClientSecret = oauthClientSecret;
    }

    @Generated
    public void setOauthAccessToken(String oauthAccessToken) {
        this.oauthAccessToken = oauthAccessToken;
    }

    @Generated
    public void setOauthRefreshToken(String oauthRefreshToken) {
        this.oauthRefreshToken = oauthRefreshToken;
    }

    @Generated
    public void setOauthInstanceUrl(String oauthInstanceUrl) {
        this.oauthInstanceUrl = oauthInstanceUrl;
    }

    @Generated
    public void setOauthJwtPrivateKey(String oauthJwtPrivateKey) {
        this.oauthJwtPrivateKey = oauthJwtPrivateKey;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setServerTimestamp(Date serverTimestamp) {
        this.serverTimestamp = serverTimestamp;
    }

    @Generated
    public void setQr(QueryResult qr) {
        this.qr = qr;
    }

    @Generated
    public void setStartDate(GregorianCalendar startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setEndDate(GregorianCalendar endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setSObjects(SObject[] sObjects) {
        this.sObjects = sObjects;
    }

    @Generated
    public void setRecordsFilter(int recordsFilter) {
        this.recordsFilter = recordsFilter;
    }

    @Generated
    public void setFieldsList(String fieldsList) {
        this.fieldsList = fieldsList;
    }

    @Generated
    public void setQueryResultSize(int queryResultSize) {
        this.queryResultSize = queryResultSize;
    }

    @Generated
    public void setRecordsCount(int recordsCount) {
        this.recordsCount = recordsCount;
    }

    @Generated
    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    @Generated
    public void setRollbackAllChangesOnError(boolean rollbackAllChangesOnError) {
        this.rollbackAllChangesOnError = rollbackAllChangesOnError;
    }

    @Generated
    public void setQueryAll(boolean queryAll) {
        this.queryAll = queryAll;
    }

    @Generated
    public void setGetDeletedList(HashMap<String, Date> getDeletedList) {
        this.getDeletedList = getDeletedList;
    }

    @Generated
    public void setLog(ILogChannel log) {
        this.log = log;
    }

    @FunctionalInterface
    private static interface QueryExecutor {
        public QueryResult execute() throws Exception;
    }
}

