/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.KeyedWorkItems;
import org.apache.beam.runners.core.OutputAndTimeBoundedSplittableProcessElementInvoker;
import org.apache.beam.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.core.SplittableProcessElementInvoker;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternalsFactory;
import org.apache.beam.runners.flink.translation.wrappers.streaming.DoFnOperator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.util.WindowedValueMultiReceiver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplittableDoFnOperator<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT>
extends DoFnOperator<KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, KeyedWorkItem<byte[], KV<InputT, RestrictionT>>, OutputT> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SplittableDoFnOperator.class);
    private transient @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService executorService;

    public SplittableDoFnOperator(@UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>, OutputT> doFn, @UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>>> windowedInputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags, @UnknownKeyFor @NonNull @Initialized DoFnOperator.OutputManagerFactory<OutputT> outputManagerFactory, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputTagMapping, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KeySelector<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>>, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keySelector) {
        super(doFn, stepName, windowedInputCoder, outputCoders, mainOutputTag, additionalOutputTags, outputManagerFactory, windowingStrategy, sideInputTagMapping, sideInputs, options, keyCoder, keySelector, DoFnSchemaInformation.create(), Collections.emptyMap());
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized DoFnRunner<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>, OutputT> createWrappingDoFnRunner(@UnknownKeyFor @NonNull @Initialized DoFnRunner<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>, OutputT> wrappedRunner, @UnknownKeyFor @NonNull @Initialized StepContext stepContext) {
        return wrappedRunner;
    }

    @Override
    public void initializeState(@UnknownKeyFor @NonNull @Initialized StateInitializationContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        super.initializeState(context);
        Preconditions.checkState((boolean)(this.doFn instanceof SplittableParDoViaKeyedWorkItems.ProcessFn));
        StateInternalsFactory stateInternalsFactory = key -> this.keyedStateInternals;
        TimerInternalsFactory timerInternalsFactory = key -> this.timerInternals;
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("flink-sdf-executor-%d").build());
        }
        ((SplittableParDoViaKeyedWorkItems.ProcessFn)this.doFn).setStateInternalsFactory(stateInternalsFactory);
        ((SplittableParDoViaKeyedWorkItems.ProcessFn)this.doFn).setTimerInternalsFactory(timerInternalsFactory);
        ((SplittableParDoViaKeyedWorkItems.ProcessFn)this.doFn).setSideInputReader(this.sideInputReader);
        ((SplittableParDoViaKeyedWorkItems.ProcessFn)this.doFn).setProcessElementInvoker((SplittableProcessElementInvoker)new OutputAndTimeBoundedSplittableProcessElementInvoker(this.doFn, this.serializedOptions.get(), new WindowedValueMultiReceiver(){

            public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> windowedValue) {
                SplittableDoFnOperator.this.outputManager.output(tag, windowedValue);
            }
        }, this.mainOutputTag, this.sideInputReader, this.executorService, 10000, Duration.standardSeconds((long)10L), this::getBundleFinalizer));
    }

    @Override
    protected void fireTimer(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
        this.timerInternals.onFiredOrDeletedTimer(timer);
        if (timer.getDomain().equals((Object)TimeDomain.EVENT_TIME)) {
            return;
        }
        this.doFnRunner.processElement(WindowedValues.valueInGlobalWindow((Object)KeyedWorkItems.timersWorkItem((Object)((byte[])this.keyedStateInternals.getKey()), Collections.singletonList(timer))));
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        super.close();
        this.executorService.shutdown();
        long shutdownTimeout = Duration.standardSeconds((long)10L).getMillis();
        try {
            if (!this.executorService.awaitTermination(shutdownTimeout, TimeUnit.MILLISECONDS)) {
                LOG.debug("The scheduled executor service did not properly terminate. Shutting it down now.");
                this.executorService.shutdownNow();
                this.executorService = null;
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Could not properly await the termination of the scheduled executor service.", (Throwable)e);
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }
}

