/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FlinkMultiOutputPruningFunction<@UnknownKeyFor T>
extends RichFlatMapFunction<WindowedValue<RawUnionValue>, WindowedValue<T>> {
    private final @UnknownKeyFor @NonNull @Initialized int ourOutputTag;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options;

    public FlinkMultiOutputPruningFunction(@UnknownKeyFor @NonNull @Initialized int ourOutputTag, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.ourOutputTag = ourOutputTag;
        this.options = new SerializablePipelineOptions(options);
    }

    public void open(@UnknownKeyFor @NonNull @Initialized Configuration parameters) {
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.options.get());
    }

    public void flatMap(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized RawUnionValue> windowedValue, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> collector) throws @UnknownKeyFor @NonNull @Initialized Exception {
        int unionTag = ((RawUnionValue)windowedValue.getValue()).getUnionTag();
        if (unionTag == this.ourOutputTag) {
            collector.collect((Object)windowedValue.withValue(((RawUnionValue)windowedValue.getValue()).getValue()));
        }
    }
}

