/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.io.Serializable;
import java.util.Date;

public class SaveFileEntry
implements Serializable,
Comparable {
    static final long serialVersionUID = 4L;
    private String objName_;
    private String libSaved_;
    private String objType_;
    private String extObjAttr_;
    private Date saveDateTime_;
    private int objSize_;
    private int objSizeMult_;
    private int asp_;
    private String dataSaved_;
    private String objOwner_;
    private String dloName_;
    private String folder_;
    private String desc_;
    private String aspDevName_;

    SaveFileEntry(String objName, String libSaved, String objType, String extObjAttr, Date saveDateTime, int objSize, int objSizeMult, int asp, String dataSaved, String objOwner, String dloName, String folder, String desc, String aspDevName) {
        this.objName_ = objName;
        this.libSaved_ = libSaved;
        this.objType_ = objType;
        this.extObjAttr_ = extObjAttr;
        this.saveDateTime_ = saveDateTime;
        this.objSize_ = objSize;
        this.objSizeMult_ = objSizeMult;
        this.asp_ = asp;
        this.dataSaved_ = dataSaved;
        this.objOwner_ = objOwner;
        this.dloName_ = dloName;
        this.folder_ = folder;
        this.desc_ = desc;
        this.aspDevName_ = aspDevName;
    }

    public int compareTo(Object obj) {
        return this.objName_.compareTo(((SaveFileEntry)obj).getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            SaveFileEntry other = (SaveFileEntry)obj;
            if (!this.objName_.equals(other.getName())) {
                return false;
            }
            if (!this.libSaved_.equals(other.getLibrary())) {
                return false;
            }
            if (!this.objType_.equals(other.getType())) {
                return false;
            }
            if (!this.dloName_.equals(other.getDLOName())) {
                return false;
            }
            if (!this.folder_.equals(other.getFolder())) {
                return false;
            }
            if (!this.aspDevName_.equals(other.getASPDevice())) {
                return false;
            }
            return this.asp_ == other.getASP();
        }
        catch (Throwable e) {
            if (Trace.traceOn_) {
                Trace.log(1, e);
            }
            return false;
        }
    }

    public String getName() {
        return this.objName_;
    }

    public String getLibrary() {
        return this.libSaved_;
    }

    public String getType() {
        return this.objType_;
    }

    public String getExtendedObjectAttribute() {
        return this.extObjAttr_;
    }

    public Date getSaveDate() {
        return (Date)this.saveDateTime_.clone();
    }

    public long getSize() {
        return (long)this.objSize_ * (long)this.objSizeMult_;
    }

    public int getASP() {
        return this.asp_;
    }

    public boolean isDataSaved() {
        return this.dataSaved_.equals("1");
    }

    public String getOwner() {
        return this.objOwner_;
    }

    public String getDLOName() {
        return this.dloName_;
    }

    public String getFolder() {
        return this.folder_;
    }

    public String getDescription() {
        return this.desc_;
    }

    public String getASPDevice() {
        return this.aspDevName_;
    }

    public int hashCode() {
        return this.objName_.hashCode() + this.libSaved_.hashCode() + this.objType_.hashCode() + this.dloName_.hashCode() + this.folder_.hashCode() + this.aspDevName_.hashCode() + this.asp_;
    }

    public String toString() {
        return "SaveFileEntry (name: " + this.objName_ + "; library: " + this.libSaved_ + "; type: " + this.objType_ + "): " + super.toString();
    }
}

