/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git.info;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.git.GitGuiPlugin;
import org.apache.hop.git.HopDiff;
import org.apache.hop.git.info.DiffStyledTextComp;
import org.apache.hop.git.model.UIFile;
import org.apache.hop.git.model.UIGit;
import org.apache.hop.git.model.revision.ObjectRevision;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.workflow.WorkflowMeta;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GitInfoExplorerFileTypeHandler
extends BaseExplorerFileTypeHandler
implements Listener {
    public static final Class<?> PKG = GitInfoExplorerFileTypeHandler.class;
    public static final String CONST_GIT = "git: ";
    public static final String CONST_S_S_S = "%s (%s -> %s)";
    private final String id = UUID.randomUUID().toString();
    private Composite parentComposite;
    private Text wFile;
    private Text wStatus;
    private Text wBranch;
    private TableView wFiles;
    private TableView wRevisions;
    private Control wDiff;
    private DiffStyledTextComp wDiffStyled;
    private Text wDiffText;
    private Button wbDiff;

    public GitInfoExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        super(hopGui, perspective, explorerFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GitInfoExplorerFileTypeHandler that = (GitInfoExplorerFileTypeHandler)((Object)o);
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public void renderFile(Composite composite) {
        this.parentComposite = composite;
        PropsUi props = PropsUi.getInstance();
        int margin = PropsUi.getMargin();
        Label wlFile = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlFile);
        wlFile.setText(BaseMessages.getString(PKG, (String)"GitInfoDialog.File.Label", (String[])new String[0]));
        FormData fdlFile = new FormData();
        fdlFile.left = new FormAttachment(0, 0);
        fdlFile.top = new FormAttachment(0, 0);
        wlFile.setLayoutData((Object)fdlFile);
        this.wFile = new Text(composite, 18436);
        this.wFile.setEditable(false);
        PropsUi.setLook((Widget)this.wFile);
        FormData fdFile = new FormData();
        fdFile.left = new FormAttachment((Control)wlFile, 2 * margin);
        fdFile.top = new FormAttachment((Control)wlFile, 0, 0x1000000);
        fdFile.right = new FormAttachment(100, 0);
        this.wFile.setLayoutData((Object)fdFile);
        Text lastControl = this.wFile;
        Label wlStatus = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlStatus);
        wlStatus.setText(BaseMessages.getString(PKG, (String)"GitInfoDialog.Status.Label", (String[])new String[0]));
        FormData fdlStatus = new FormData();
        fdlStatus.left = new FormAttachment(0, 0);
        fdlStatus.top = new FormAttachment((Control)lastControl, margin);
        wlStatus.setLayoutData((Object)fdlStatus);
        this.wStatus = new Text(composite, 18436);
        PropsUi.setLook((Widget)this.wStatus);
        this.wStatus.setEditable(false);
        FormData fdStatus = new FormData();
        fdStatus.left = new FormAttachment((Control)wlFile, 2 * margin);
        fdStatus.top = new FormAttachment((Control)wlStatus, 0, 0x1000000);
        fdStatus.right = new FormAttachment(100, 0);
        this.wStatus.setLayoutData((Object)fdStatus);
        lastControl = this.wStatus;
        Label wlBranch = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlBranch);
        wlBranch.setText(BaseMessages.getString(PKG, (String)"GitInfoDialog.Branch.Label", (String[])new String[0]));
        FormData fdlBranch = new FormData();
        fdlBranch.left = new FormAttachment(0, 0);
        fdlBranch.top = new FormAttachment((Control)lastControl, margin);
        wlBranch.setLayoutData((Object)fdlBranch);
        this.wBranch = new Text(composite, 18436);
        PropsUi.setLook((Widget)this.wBranch);
        this.wBranch.setEditable(false);
        FormData fdBranch = new FormData();
        fdBranch.left = new FormAttachment((Control)wlFile, 2 * margin);
        fdBranch.top = new FormAttachment((Control)wlBranch, 0, 0x1000000);
        fdBranch.right = new FormAttachment(100, 0);
        this.wBranch.setLayoutData((Object)fdBranch);
        lastControl = this.wBranch;
        Label wlRevisions = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlRevisions);
        wlRevisions.setText(BaseMessages.getString(PKG, (String)"GitInfoDialog.Revisions.Label", (String[])new String[0]));
        FormData fdlRevisions = new FormData();
        fdlRevisions.left = new FormAttachment(0, 0);
        fdlRevisions.top = new FormAttachment((Control)lastControl, margin);
        fdlRevisions.right = new FormAttachment(100, 0);
        wlRevisions.setLayoutData((Object)fdlRevisions);
        lastControl = wlRevisions;
        ColumnInfo[] revisionColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"GitInfoDialog.Revisions.ColumnRevision.Label", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"GitInfoDialog.Revisions.ColumnCreation.Label", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"GitInfoDialog.Revisions.ColumnLogin.Label", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"GitInfoDialog.Revisions.ColumnComment.Label", (String[])new String[0]), 1, false, true)};
        this.wRevisions = new TableView(this.hopGui.getVariables(), composite, 2052, revisionColumns, 1, null, props);
        this.wRevisions.setReadonly(true);
        PropsUi.setLook((Widget)this.wRevisions);
        FormData fdRevisions = new FormData();
        fdRevisions.left = new FormAttachment(0, 0);
        fdRevisions.top = new FormAttachment((Control)lastControl, margin);
        fdRevisions.right = new FormAttachment(100, 0);
        fdRevisions.bottom = new FormAttachment(40, 0);
        this.wRevisions.setLayoutData((Object)fdRevisions);
        this.wRevisions.table.addListener(3, e -> this.wRevisions.table.getDisplay().asyncExec(this::refreshChangedFiles));
        this.wRevisions.table.addListener(1, e -> this.wRevisions.table.getDisplay().asyncExec(this::refreshChangedFiles));
        lastControl = this.wRevisions;
        Label wlFiles = new Label(composite, 16388);
        PropsUi.setLook((Widget)wlFiles);
        wlFiles.setText(BaseMessages.getString(PKG, (String)"GitInfoDialog.ChangedFiles.Label", (String[])new String[0]));
        FormData fdlFiles = new FormData();
        fdlFiles.left = new FormAttachment(0, 0);
        fdlFiles.right = new FormAttachment(100, 0);
        fdlFiles.top = new FormAttachment((Control)lastControl, margin);
        wlFiles.setLayoutData((Object)fdlFiles);
        lastControl = wlFiles;
        SashForm sashForm = new SashForm(composite, 256);
        PropsUi.setLook((Widget)sashForm);
        FormData fdSashForm = new FormData();
        fdSashForm.left = new FormAttachment(0, 0);
        fdSashForm.right = new FormAttachment(100, 0);
        fdSashForm.top = new FormAttachment((Control)lastControl, margin);
        fdSashForm.bottom = new FormAttachment(100, 0);
        sashForm.setLayoutData((Object)fdSashForm);
        ColumnInfo[] filesColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"GitInfoDialog.ChangedFiles.Filename.Label", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"GitInfoDialog.ChangedFiles.Status.Label", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"GitInfoDialog.ChangedFiles.Staged.Label", (String[])new String[0]), 1, false, true)};
        this.wFiles = new TableView(this.hopGui.getVariables(), (Composite)sashForm, 2052, filesColumns, 1, null, props);
        this.wFiles.setReadonly(true);
        PropsUi.setLook((Widget)this.wFiles);
        this.wFiles.table.addListener(3, e -> this.wFiles.table.getDisplay().asyncExec(this::fileSelected));
        this.wFiles.table.addListener(1, e -> this.wFiles.table.getDisplay().asyncExec(this::fileSelected));
        Composite wDiffComposite = new Composite((Composite)sashForm, 0);
        PropsUi.setLook((Widget)wDiffComposite);
        wDiffComposite.setLayout((Layout)new FormLayout());
        this.wbDiff = new Button(wDiffComposite, 8);
        PropsUi.setLook((Widget)this.wbDiff);
        this.wbDiff.setEnabled(false);
        this.wbDiff.setText(BaseMessages.getString(PKG, (String)"GitInfoDialog.VisualDiff.Label", (String[])new String[0]));
        this.wbDiff.addListener(13, e -> this.showHopFileDiff());
        FormData fdbDiff = new FormData();
        fdbDiff.right = new FormAttachment(100, 0);
        fdbDiff.top = new FormAttachment(0, 0);
        this.wbDiff.setLayoutData((Object)fdbDiff);
        Label wlDiff = new Label(wDiffComposite, 16388);
        PropsUi.setLook((Widget)wlDiff);
        wlDiff.setText(BaseMessages.getString(PKG, (String)"GitInfoDialog.VisualDiff.Title", (String[])new String[0]));
        FormData fdlDiff = new FormData();
        fdlDiff.left = new FormAttachment(0, 0);
        fdlDiff.right = new FormAttachment((Control)this.wbDiff, -margin);
        fdlDiff.top = new FormAttachment((Control)this.wbDiff, 0, 0x1000000);
        wlDiff.setLayoutData((Object)fdlDiff);
        FormData fdDiff = new FormData();
        fdDiff.left = new FormAttachment(0, 0);
        fdDiff.right = new FormAttachment(100, 0);
        fdDiff.top = new FormAttachment((Control)this.wbDiff, margin);
        fdDiff.bottom = new FormAttachment(100, 0);
        if (EnvironmentUtils.getInstance().isWeb()) {
            this.wDiffText = new Text(wDiffComposite, 2818);
            this.wDiffText.setEditable(false);
            PropsUi.setLook((Widget)this.wDiffText);
            this.wDiffText.setLayoutData((Object)fdDiff);
            this.wDiff = this.wDiffText;
        } else {
            this.wDiffStyled = new DiffStyledTextComp(this.hopGui.getVariables(), wDiffComposite, 2818);
            PropsUi.setLook((Widget)this.wDiffStyled, (int)1);
            this.wDiffStyled.setLayoutData(fdDiff);
            this.wDiff = this.wDiffStyled;
        }
        sashForm.setWeights(new int[]{40, 60});
        this.refresh();
        this.perspective.getTree().addListener(13, (Listener)this);
    }

    public void showHopFileDiff() {
        if (this.wFiles.getSelectionIndices().length == 0) {
            return;
        }
        TableItem fileItem = this.wFiles.table.getSelection()[0];
        String filename = fileItem.getText(1);
        if (StringUtils.isEmpty((String)filename)) {
            return;
        }
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        try {
            String commitIdOld;
            String commitIdNew;
            TableItem revisionItem = this.wRevisions.table.getSelection()[0];
            String revisionId = revisionItem.getText(1);
            boolean workingTree = "WORKINGTREE".equals(revisionId);
            boolean staged = "Y".equalsIgnoreCase(fileItem.getText(3));
            if (workingTree) {
                commitIdNew = "WORKINGTREE";
                commitIdOld = "HEAD";
            } else {
                commitIdNew = revisionId;
                commitIdOld = git.getParentCommitId(revisionId);
                if (commitIdOld == null) {
                    return;
                }
            }
            if (commitIdNew.equals(commitIdOld)) {
                return;
            }
            ExplorerPerspective perspective = HopGui.getExplorerPerspective();
            if (perspective.getPipelineFileType().isHandledBy(filename, false)) {
                this.showPipelineFileDiff(filename, commitIdNew, commitIdOld);
            } else if (perspective.getWorkflowFileType().isHandledBy(filename, false)) {
                this.showWorkflowFileDiff(filename, commitIdNew, commitIdOld);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error while doing visual diff on file : " + filename, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPipelineFileDiff(String filename, String commitIdNew, String commitIdOld) throws HopException {
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        InputStream xmlStreamOld = null;
        InputStream xmlStreamNew = null;
        try {
            xmlStreamOld = git.open(filename, commitIdOld);
            xmlStreamNew = git.open(filename, commitIdNew);
            PipelineMeta pipelineMetaOld = new PipelineMeta(xmlStreamOld, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
            PipelineMeta pipelineMetaNew = new PipelineMeta(xmlStreamNew, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
            pipelineMetaOld = HopDiff.compareTransforms(pipelineMetaOld, pipelineMetaNew, true);
            pipelineMetaOld = HopDiff.comparePipelineHops(pipelineMetaOld, pipelineMetaNew, true);
            pipelineMetaNew = HopDiff.compareTransforms(pipelineMetaNew, pipelineMetaOld, false);
            pipelineMetaNew = HopDiff.comparePipelineHops(pipelineMetaNew, pipelineMetaOld, false);
            pipelineMetaOld.setPipelineVersion(CONST_GIT + commitIdOld);
            pipelineMetaNew.setPipelineVersion(CONST_GIT + commitIdNew);
            pipelineMetaOld.setName(String.format(CONST_S_S_S, pipelineMetaOld.getName(), git.getShortenedName(commitIdOld), git.getShortenedName(commitIdNew)));
            pipelineMetaOld.setNameSynchronizedWithFilename(false);
            pipelineMetaNew.setName(String.format(CONST_S_S_S, pipelineMetaNew.getName(), git.getShortenedName(commitIdNew), git.getShortenedName(commitIdOld)));
            pipelineMetaNew.setNameSynchronizedWithFilename(false);
            HopGui.getExplorerPerspective().addPipeline(pipelineMetaOld);
            HopGui.getExplorerPerspective().addPipeline(pipelineMetaNew);
        }
        finally {
            try {
                if (xmlStreamOld != null) {
                    xmlStreamOld.close();
                }
                if (xmlStreamNew != null) {
                    xmlStreamNew.close();
                }
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error closing XML file after reading", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showWorkflowFileDiff(String filename, String commitIdNew, String commitIdOld) throws HopException {
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        InputStream xmlStreamOld = null;
        InputStream xmlStreamNew = null;
        try {
            xmlStreamOld = git.open(filename, commitIdOld);
            xmlStreamNew = git.open(filename, commitIdNew);
            WorkflowMeta workflowMetaOld = new WorkflowMeta(xmlStreamOld, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
            WorkflowMeta workflowMetaNew = new WorkflowMeta(xmlStreamNew, (IHopMetadataProvider)this.hopGui.getMetadataProvider(), this.hopGui.getVariables());
            workflowMetaOld = HopDiff.compareActions(workflowMetaOld, workflowMetaNew, true);
            workflowMetaOld = HopDiff.compareWorkflowHops(workflowMetaOld, workflowMetaNew, true);
            workflowMetaNew = HopDiff.compareActions(workflowMetaNew, workflowMetaOld, false);
            workflowMetaNew = HopDiff.compareWorkflowHops(workflowMetaNew, workflowMetaOld, false);
            workflowMetaOld.setWorkflowVersion(CONST_GIT + commitIdOld);
            workflowMetaNew.setWorkflowVersion(CONST_GIT + commitIdNew);
            workflowMetaOld.setName(String.format(CONST_S_S_S, workflowMetaOld.getName(), git.getShortenedName(commitIdOld), git.getShortenedName(commitIdNew)));
            workflowMetaOld.setNameSynchronizedWithFilename(false);
            workflowMetaNew.setName(String.format(CONST_S_S_S, workflowMetaNew.getName(), git.getShortenedName(commitIdNew), git.getShortenedName(commitIdOld)));
            workflowMetaNew.setNameSynchronizedWithFilename(false);
            HopGui.getExplorerPerspective().addWorkflow(workflowMetaOld);
            HopGui.getExplorerPerspective().addWorkflow(workflowMetaNew);
            HopGui.getExplorerPerspective().activate();
        }
        finally {
            try {
                if (xmlStreamOld != null) {
                    xmlStreamOld.close();
                }
                if (xmlStreamNew != null) {
                    xmlStreamNew.close();
                }
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error closing XML file after reading", (Throwable)e);
            }
        }
    }

    public void close() {
        this.perspective.getTree().removeListener(13, (Listener)this);
        super.close();
    }

    public void handleEvent(Event event) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || !this.parentComposite.isVisible()) {
            return;
        }
        ExplorerFile file = this.perspective.getSelectedFile();
        if (file == null) {
            return;
        }
        if (file.getFilename().equals(this.wFile.getText())) {
            this.refresh();
            return;
        }
        try {
            this.explorerFile = file;
            this.refresh();
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error calculating relative path to change git info view", (Throwable)e);
        }
    }

    public void refresh() {
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        List<Object> revisions = new ArrayList();
        try {
            String gitRoot = git.getDirectory();
            String string = this.calculateRelativePath(gitRoot, this.explorerFile.getFilename());
            LogChannel.UI.logDebug("GitInfo refresh - gitRoot: '" + gitRoot + "', perspectiveRoot: '" + this.perspective.getRootFolder() + "', file: '" + this.explorerFile.getFilename() + "', relative: '" + string + "'");
            revisions = git.getRevisions(string);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting git object revisions for path: " + this.explorerFile.getFilename(), (Throwable)e);
        }
        this.wFile.setText(Const.NVL((String)this.explorerFile.getFilename(), (String)""));
        this.wStatus.setText(this.getStatusDescription(guiPlugin));
        this.wBranch.setText(Const.NVL((String)git.getBranch(), (String)""));
        this.wRevisions.removeAll();
        for (ObjectRevision objectRevision : revisions) {
            TableItem item = new TableItem(this.wRevisions.table, 0);
            item.setText(1, Const.NVL((String)objectRevision.getRevisionId(), (String)""));
            item.setText(2, this.getDateString(objectRevision.getCreationDate()));
            item.setText(3, Const.NVL((String)objectRevision.getLogin(), (String)""));
            item.setText(4, Const.NVL((String)objectRevision.getComment(), (String)""));
        }
        this.wRevisions.optimizeTableView();
        this.wbDiff.setEnabled(false);
        this.refreshChangedFiles();
        if (!revisions.isEmpty()) {
            this.parentComposite.getDisplay().asyncExec(() -> {
                if (!this.wRevisions.isDisposed() && this.wRevisions.table.getItemCount() > 0) {
                    this.wRevisions.table.setSelection(0);
                    this.wRevisions.table.showSelection();
                    LogChannel.UI.logDebug("GitInfo refresh: Auto-selected first revision (index 0) after UI render");
                    this.refreshChangedFiles();
                }
            });
        }
    }

    private String calculateRelativePath(String rootFolder, String filename) throws HopFileException, FileSystemException {
        FileObject root = HopVfs.getFileObject((String)rootFolder);
        FileObject file = HopVfs.getFileObject((String)filename);
        String relativePath = root.getName().getRelativeName(file.getName());
        if (relativePath != null && !".".equals(relativePath) && (relativePath = relativePath.replace("\\", "/")).startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    private void fileSelected() {
        LogChannel.UI.logDebug("fileSelected: File clicked in changed files list");
        String filename = this.showFileDiff();
        this.wbDiff.setEnabled(false);
        try {
            if (filename != null) {
                LogChannel.UI.logDebug("fileSelected: Diff generated for file: " + filename);
                ExplorerPerspective perspective = HopGui.getExplorerPerspective();
                if (!perspective.getPipelineFileType().isHandledBy(this.explorerFile.getFilename(), false) && !perspective.getWorkflowFileType().isHandledBy(this.explorerFile.getFilename(), false)) {
                    return;
                }
                if (this.wRevisions.getSelectionIndex() == this.wRevisions.table.getItemCount() - 1) {
                    return;
                }
                if (perspective.getPipelineFileType().isHandledBy(filename, false)) {
                    this.wbDiff.setEnabled(true);
                }
                if (perspective.getWorkflowFileType().isHandledBy(filename, false)) {
                    this.wbDiff.setEnabled(true);
                }
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error checking if this file is a pipeline or workflow: " + filename, (Throwable)e);
        }
    }

    private String showFileDiff() {
        String diff;
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        if (this.wRevisions.table.getSelectionCount() == 0) {
            LogChannel.UI.logDebug("showFileDiff: No revision selected");
            return null;
        }
        if (this.wFiles.table.getSelectionCount() == 0) {
            LogChannel.UI.logDebug("showFileDiff: No file selected");
            return null;
        }
        TableItem[] revisionSelection = this.wRevisions.table.getSelection();
        if (revisionSelection.length == 0) {
            LogChannel.UI.logDebug("showFileDiff: Revision selection array is empty");
            return null;
        }
        TableItem revisionItem = revisionSelection[0];
        String revisionId = revisionItem.getText(1);
        boolean workingTree = "WORKINGTREE".equals(revisionId);
        TableItem fileItem = this.wFiles.table.getSelection()[0];
        String filename = fileItem.getText(1);
        boolean staged = "Y".equalsIgnoreCase(fileItem.getText(3));
        if (workingTree) {
            diff = staged ? git.diff("HEAD", "INDEX", filename) : git.diff("INDEX", "WORKINGTREE", filename);
        } else {
            String parentCommitId = git.getParentCommitId(revisionId);
            diff = git.diff(parentCommitId, revisionId, filename);
        }
        this.setDiffText(Const.NVL((String)diff, (String)""));
        return filename;
    }

    private void setDiffText(String text) {
        if (this.wDiffStyled != null) {
            this.wDiffStyled.setDiffText(text);
        } else if (this.wDiffText != null) {
            this.wDiffText.setText(text);
        }
    }

    private void refreshChangedFiles() {
        ArrayList<UIFile> changedFiles;
        GitGuiPlugin guiPlugin = GitGuiPlugin.getInstance();
        UIGit git = guiPlugin.getGit();
        String selectedFile = this.wFile.getText();
        String rootFolder = git.getDirectory();
        boolean showStaged = true;
        this.setDiffText("");
        this.wbDiff.setEnabled(false);
        if (this.wRevisions.table.getSelectionCount() == 0) {
            changedFiles = new ArrayList<UIFile>();
            for (UIFile changedFile : guiPlugin.getChangedFiles().values()) {
                if (!this.isFilteredPath(rootFolder, changedFile.getName(), selectedFile)) continue;
                changedFiles.add(changedFile);
            }
        } else {
            String revisionId = this.wRevisions.table.getSelection()[0].getText(1);
            String parentRevisionId = this.wRevisions.table.getSelection()[this.wRevisions.table.getSelection().length - 1].getText(1);
            if ("WORKINGTREE".equals(revisionId)) {
                changedFiles = new ArrayList();
                for (UIFile changedFile : guiPlugin.getChangedFiles().values()) {
                    if (!this.isFilteredPath(rootFolder, changedFile.getName(), selectedFile)) continue;
                    changedFiles.add(changedFile);
                }
            } else {
                showStaged = false;
                changedFiles = new ArrayList();
                try {
                    try (RevWalk revWalk = new RevWalk(git.getGit().getRepository());){
                        RevCommit commit = revWalk.parseCommit((AnyObjectId)git.resolve(revisionId));
                        RevCommit parentCommit = null;
                        parentCommit = !revisionId.equals(parentRevisionId) ? (revWalk.parseCommit((AnyObjectId)git.resolve(parentRevisionId)).getParentCount() > 0 ? revWalk.parseCommit((AnyObjectId)git.resolve(parentRevisionId).getParent(0)) : null) : (commit.getParentCount() > 0 ? revWalk.parseCommit((AnyObjectId)commit.getParent(0).getId()) : null);
                        try (TreeWalk treeWalk = new TreeWalk(git.getGit().getRepository());){
                            if (parentCommit != null) {
                                treeWalk.addTree((AnyObjectId)parentCommit.getTree());
                            }
                            treeWalk.addTree((AnyObjectId)commit.getTree());
                            treeWalk.setRecursive(true);
                            treeWalk.setFilter(TreeFilter.ANY_DIFF);
                            while (treeWalk.next()) {
                                String path = treeWalk.getPathString();
                                if (!this.isFilteredPath(rootFolder, path, selectedFile)) continue;
                                changedFiles.add(new UIFile(path, DiffEntry.ChangeType.MODIFY, false));
                            }
                        }
                    }
                    catch (Exception e) {
                        LogChannel.UI.logError("Error getting changed file in revision " + (String)revisionId, (Throwable)e);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.wFiles.removeAll();
        for (UIFile file : changedFiles) {
            TableItem item = new TableItem(this.wFiles.table, 0);
            item.setText(1, Const.NVL((String)file.getName(), (String)""));
            if (!showStaged) continue;
            item.setText(2, Const.NVL((String)file.getChangeType().name(), (String)""));
            item.setText(3, file.isStaged() ? "Y" : "N");
        }
        this.wFiles.optimizeTableView();
        boolean shouldAutoSelect = false;
        if (changedFiles.size() == 1 && this.wRevisions.table.getSelectionCount() > 0) {
            shouldAutoSelect = true;
        } else if (!changedFiles.isEmpty() && this.wFiles.table.getSelectionCount() > 0) {
            shouldAutoSelect = true;
        }
        if (shouldAutoSelect) {
            this.wFiles.table.getDisplay().asyncExec(() -> {
                if (!this.wFiles.isDisposed() && this.wFiles.table.getItemCount() > 0) {
                    if (this.wFiles.table.getSelectionCount() == 0 || this.wFiles.table.getItemCount() == 1) {
                        this.wFiles.table.setSelection(0);
                        this.wFiles.table.showSelection();
                        LogChannel.UI.logDebug("refreshChangedFiles: Auto-selected file at index 0");
                    }
                    if (this.wFiles.table.getSelectionCount() > 0) {
                        this.fileSelected();
                        LogChannel.UI.logDebug("refreshChangedFiles: Triggered diff display for selected file");
                    }
                }
            });
        }
    }

    private boolean isFilteredPath(String root, String path, String selectedFile) {
        try {
            String relativeSelected = this.calculateRelativePath(root, selectedFile);
            LogChannel.UI.logDebug("isFilteredPath: path='" + path + "', relativeSelected='" + relativeSelected + "', selectedFile='" + selectedFile + "'");
            if (".".equals(relativeSelected)) {
                return true;
            }
            FileObject selectedFileObject = HopVfs.getFileObject((String)selectedFile);
            boolean isDirectory = selectedFileObject.isFolder();
            if (isDirectory) {
                return path.equals(relativeSelected) || path.startsWith(relativeSelected + "/");
            }
            return path.equals(relativeSelected);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error in isFilteredPath", (Throwable)e);
            return false;
        }
    }

    private String getStatusDescription(GitGuiPlugin guiPlugin) {
        Map<String, UIFile> changedFiles = guiPlugin.getChangedFiles();
        Map<String, String> ignoredFiles = guiPlugin.getIgnoredFiles();
        UIFile file = changedFiles.get(this.explorerFile.getFilename());
        if (file == null) {
            String ignored = ignoredFiles.get(this.explorerFile.getFilename());
            if (ignored == null) {
                return "Not changed";
            }
            return "Ignored";
        }
        return switch (file.getChangeType()) {
            case DiffEntry.ChangeType.ADD -> "Not added";
            case DiffEntry.ChangeType.COPY -> "Copied";
            case DiffEntry.ChangeType.MODIFY -> "Modified";
            case DiffEntry.ChangeType.DELETE -> "Deleted";
            case DiffEntry.ChangeType.RENAME -> "Renamed";
            default -> "Changed";
        };
    }

    private String getDateString(Date date) {
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date);
    }
}

