/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pipeline.transform.jdbcmetadata;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.pipeline.transform.jdbcmetadata.JdbcMetadataData;
import org.apache.pipeline.transform.jdbcmetadata.JdbcMetadataMeta;
import org.apache.pipeline.transform.jdbcmetadata.OutputField;

public class JdbcMetadata
extends BaseTransform<JdbcMetadataMeta, JdbcMetadataData> {
    boolean treatAsInputTransform = false;

    public JdbcMetadata(TransformMeta transformMeta, JdbcMetadataMeta meta, JdbcMetadataData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object stringToArgumentValue(String stringValue, Class<?> type) throws IllegalArgumentException {
        Object argument;
        if (type == String.class) {
            argument = stringValue;
        } else if (type == Boolean.class) {
            argument = "Y".equals(stringValue) ? Boolean.TRUE : Boolean.FALSE;
        } else if (type == Integer.class) {
            argument = Integer.valueOf(stringValue);
        } else {
            throw new IllegalArgumentException("Can't handle valueType " + type.getName());
        }
        return argument;
    }

    private Object stringListToObjectArray(String stringValue, Class<?> type) {
        if (stringValue == null) {
            return null;
        }
        String[] stringValues = stringValue.split(",");
        int n = stringValues.length;
        Object result = Array.newInstance(type, n);
        for (int i = 0; i < n; ++i) {
            Array.set(result, i, this.stringToArgumentValue(stringValues[i], type));
        }
        return result;
    }

    private void initMethod(JdbcMetadataMeta meta, JdbcMetadataData data) throws Exception {
        Method method;
        if (this.isDebug()) {
            this.logDebug("Setting up method to call.");
        }
        data.method = method = meta.getMethod();
        if (this.isDebug()) {
            this.logDebug("Setting up method arguments.");
        }
        Class<?>[] argumentTypes = method.getParameterTypes();
        int argc = argumentTypes.length;
        if (this.isDebug()) {
            this.logDebug("Method has " + argc + " arguments.");
        }
        this.treatAsInputTransform = argc == 0;
        String[] arguments = new String[meta.getArguments().size()];
        meta.getArguments().toArray(arguments);
        if (this.isDebug()) {
            this.logDebug("We expected " + arguments.length + " arguments' values.");
        }
        if (argc != arguments.length) {
            throw new Exception("Method has a " + argc + " arguments, we expected " + arguments.length + " values.");
        }
        if (this.isDebug()) {
            this.logDebug("Allocating arguments array.");
        }
        data.arguments = new Object[argc];
        if (meta.isArgumentSourceFields()) {
            if (this.isDebug()) {
                this.logDebug("Allocating field indices array for arguments.");
            }
            data.argumentFieldIndices = new int[argc];
            for (int i = 0; i < argc; ++i) {
                data.argumentFieldIndices[i] = -1;
            }
        } else {
            for (int i = 0; i < argc; ++i) {
                Object argument;
                Class<?> argumentType = argumentTypes[i];
                String stringArgument = arguments[i];
                if (stringArgument == null) {
                    argument = null;
                } else {
                    stringArgument = this.variables.resolve(stringArgument);
                    argument = argumentType.isArray() ? (stringArgument.isEmpty() ? null : this.stringListToObjectArray(stringArgument, argumentType.getComponentType())) : this.stringToArgumentValue(stringArgument, argumentType);
                }
                data.arguments[i] = argument;
            }
        }
    }

    private void initOutputFields(JdbcMetadataMeta meta, JdbcMetadataData data) {
        List<OutputField> outputFields = meta.getOutputFields();
        int n = outputFields.size();
        data.resultSetIndices = new int[n];
        IValueMeta[] fields = meta.getMethodResultSetDescriptor();
        int m = fields.length;
        block0: for (int i = 0; i < n; ++i) {
            String fieldName = outputFields.get(i).getName();
            if (fieldName == null) continue;
            for (int j = 0; j < m; ++j) {
                IValueMeta field = fields[j];
                if (!fieldName.equals(field.getName())) continue;
                data.resultSetIndices[i] = j + 1;
                continue block0;
            }
        }
    }

    public boolean init() {
        boolean result = true;
        if (!super.init()) {
            return false;
        }
        try {
            DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((JdbcMetadataMeta)this.meta).getConnection(), this.variables);
            if (databaseMeta == null) {
                this.logError("Database connection is missing for transform " + this.getTransformName());
                return false;
            }
            ((JdbcMetadataData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
            ((JdbcMetadataData)this.data).db.connect();
            this.initMethod((JdbcMetadataMeta)this.meta, (JdbcMetadataData)this.data);
            this.initOutputFields((JdbcMetadataMeta)this.meta, (JdbcMetadataData)this.data);
        }
        catch (Exception exception) {
            this.logError("Unexpected " + exception.getClass().getName() + " initializing step: " + exception.getMessage());
            exception.printStackTrace();
            result = false;
        }
        return result;
    }

    private void prepareMethodArguments(JdbcMetadataMeta meta, JdbcMetadataData data, Object[] row) throws Exception {
        if (!meta.isArgumentSourceFields()) {
            return;
        }
        Object[] args = data.arguments;
        int[] indices = data.argumentFieldIndices;
        Class<?>[] argumentTypes = data.method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            int index = indices[i];
            Object argument = index == -2 ? null : row[index];
            Class<?> argumentType = argumentTypes[i];
            if (argumentType.isArray() && argument != null) {
                if ("".equals(argument)) {
                    if (this.isDebug()) {
                        this.logDebug("Converted empty string to null for argument array");
                    }
                    argument = null;
                } else {
                    argument = this.stringListToObjectArray((String)argument, argumentType.getComponentType());
                }
            }
            args[i] = argument;
        }
    }

    private Object[] createOutputRow(JdbcMetadataMeta meta, JdbcMetadataData data, Object[] inputRow) {
        Object[] outputRow = new Object[data.outputRowMeta.size()];
        if (!this.treatAsInputTransform) {
            if (data.inputFieldsToCopy == null) {
                System.arraycopy(inputRow, 0, outputRow, 0, this.getInputRowMeta().size());
            } else {
                for (int i = 0; i < data.inputFieldsToCopy.length; ++i) {
                    outputRow[i] = inputRow[data.inputFieldsToCopy[i]];
                }
            }
        }
        return outputRow;
    }

    public boolean processRow() throws HopException {
        int j;
        int i;
        Object[] r = this.getRow();
        if (!this.treatAsInputTransform && r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            if (!this.treatAsInputTransform) {
                this.first = false;
                IRowMeta inputRowMeta = this.getInputRowMeta();
                ((JdbcMetadataData)this.data).outputRowOffset = inputRowMeta.size();
                boolean argumentSourceFields = ((JdbcMetadataMeta)this.meta).isArgumentSourceFields();
                if (this.isDebug()) {
                    this.logDebug("Looking up indices of input fields.");
                }
                String[] fieldNames = inputRowMeta.getFieldNames();
                if (this.isDebug()) {
                    this.logDebug("We have " + fieldNames.length + " input fields.");
                }
                List<String> arguments = ((JdbcMetadataMeta)this.meta).getArguments();
                int argc = arguments.size();
                if (argumentSourceFields) {
                    for (int i2 = 0; i2 < fieldNames.length; ++i2) {
                        String fieldName = fieldNames[i2];
                        if (this.isDebug()) {
                            this.logDebug("Looking at field: " + fieldName);
                        }
                        for (int j2 = 0; j2 < argc; ++j2) {
                            String stringArgument = arguments.get(j2);
                            if (this.isDebug()) {
                                this.logDebug("Found argument " + j2 + ": " + stringArgument);
                            }
                            if (!fieldName.equals(stringArgument)) continue;
                            if (this.isDebug()) {
                                this.logDebug("Match, storing index " + i2);
                            }
                            ((JdbcMetadataData)this.data).argumentFieldIndices[j2] = i2;
                        }
                    }
                    int fieldsUsedAsArgs = 0;
                    block4: for (int j3 = 0; j3 < argc; ++j3) {
                        if (this.isDebug()) {
                            this.logDebug("Argument indices at " + j3 + ": " + ((JdbcMetadataData)this.data).argumentFieldIndices[j3]);
                        }
                        if (((JdbcMetadataData)this.data).argumentFieldIndices[j3] == -1) {
                            if (Utils.isEmpty((CharSequence)arguments.get(j3))) {
                                ((JdbcMetadataData)this.data).argumentFieldIndices[j3] = -2;
                                continue;
                            }
                            Object[] descriptor = ((JdbcMetadataMeta)this.meta).getMethodDescriptor();
                            Object[] args = (Object[])descriptor[1];
                            Object[] arg = (Object[])args[j3];
                            throw new HopException("No field \"" + arguments.get(j3) + "\" found for argument " + j3 + ": " + (String)arg[0]);
                        }
                        for (i = 0; i < j3; ++i) {
                            if (((JdbcMetadataData)this.data).argumentFieldIndices[i] == ((JdbcMetadataData)this.data).argumentFieldIndices[j3]) continue block4;
                        }
                        ++fieldsUsedAsArgs;
                    }
                    if (((JdbcMetadataMeta)this.meta).isRemoveArgumentFields()) {
                        int n = ((JdbcMetadataData)this.data).outputRowOffset;
                        ((JdbcMetadataData)this.data).outputRowOffset -= fieldsUsedAsArgs;
                        ((JdbcMetadataData)this.data).inputFieldsToCopy = new int[((JdbcMetadataData)this.data).outputRowOffset];
                        j = 0;
                        block6: for (i = 0; i < n; ++i) {
                            for (int k = 0; k < argc; ++k) {
                                if (((JdbcMetadataData)this.data).argumentFieldIndices[k] == i) continue block6;
                            }
                            ((JdbcMetadataData)this.data).inputFieldsToCopy[j++] = i;
                        }
                    }
                }
                if (this.isDebug()) {
                    this.logDebug("Done looking up indices of input fields.");
                }
                ((JdbcMetadataData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            } else {
                ((JdbcMetadataData)this.data).outputRowMeta = new RowMeta();
            }
            ((JdbcMetadataMeta)this.meta).getFields(((JdbcMetadataData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        try {
            if (this.isRowLevel()) {
                this.logRowlevel("Processing 1 input row");
            }
            this.prepareMethodArguments((JdbcMetadataMeta)this.meta, (JdbcMetadataData)this.data, r);
            if (this.getLogLevel() == LogLevel.ROWLEVEL) {
                if (this.isRowLevel()) {
                    this.logRowlevel("About to invoke method");
                }
                for (int i3 = 0; i3 < ((JdbcMetadataData)this.data).arguments.length; ++i3) {
                    if (!this.isRowLevel()) continue;
                    this.logRowlevel("Argument " + i3 + "; " + (String)(((JdbcMetadataData)this.data).arguments[i3] == null ? "null" : ((JdbcMetadataData)this.data).arguments[i3].toString() + "; " + ((JdbcMetadataData)this.data).arguments[i3].getClass().getName()));
                }
            }
            DatabaseMetaData databaseMetaData = ((JdbcMetadataData)this.data).db.getConnection().getMetaData();
            ResultSet resultSet = (ResultSet)((JdbcMetadataData)this.data).method.invoke((Object)databaseMetaData, ((JdbcMetadataData)this.data).arguments);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int columnCount = resultSetMetaData.getColumnCount();
            boolean outputRows = false;
            while (resultSet.next()) {
                if (this.isRowLevel()) {
                    this.logRowlevel("Processing 1 output row.");
                }
                Object[] outputRow = this.createOutputRow((JdbcMetadataMeta)this.meta, (JdbcMetadataData)this.data, r);
                i = ((JdbcMetadataData)this.data).outputRowOffset;
                j = 0;
                while (i < ((JdbcMetadataData)this.data).outputRowMeta.size()) {
                    int k = ((JdbcMetadataData)this.data).resultSetIndices[j];
                    if (k <= columnCount) {
                        Object value;
                        int type = ((JdbcMetadataData)this.data).outputRowMeta.getValueMeta(i).getType();
                        outputRow[i] = value = JdbcMetadata.getColumnValue(resultSet, resultSetMetaData, k, type);
                        outputRows = true;
                    }
                    ++i;
                    ++j;
                }
                this.putRow(((JdbcMetadataData)this.data).outputRowMeta, outputRow);
                if (!this.isRowLevel()) continue;
                this.logRowlevel("Done processing 1 output row.");
            }
            resultSet.close();
            if (!outputRows && ((JdbcMetadataMeta)this.meta).isAlwaysPassInputRow()) {
                Object[] outputRow = this.createOutputRow((JdbcMetadataMeta)this.meta, (JdbcMetadataData)this.data, r);
                this.putRow(((JdbcMetadataData)this.data).outputRowMeta, outputRow);
            }
            if (this.isRowLevel()) {
                this.logRowlevel("Done processing 1 input row.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof HopException) {
                HopException hopException = (HopException)exception;
                throw hopException;
            }
            throw new HopException((Throwable)exception);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic() && this.isBasic()) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        if (this.treatAsInputTransform) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private static Object getColumnValue(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int k, int type) throws SQLException {
        return switch (type) {
            case 4 -> {
                boolean v0 = switch (resultSetMetaData.getColumnType(k)) {
                    case -6, 4, 5 -> {
                        if (resultSet.getInt(k) == 1) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> resultSet.getBoolean(k);
                };
                boolean v = v0;
                yield v;
            }
            case 5 -> (long)resultSet.getInt(k);
            default -> resultSet.getObject(k);
        };
    }

    public void dispose() {
        try {
            if (((JdbcMetadataData)this.data).database != null) {
                ((JdbcMetadataData)this.data).database.disconnect();
                ((JdbcMetadataData)this.data).connection = null;
                ((JdbcMetadataData)this.data).database = null;
            }
        }
        catch (Exception ex) {
            this.logError("Error cleaning up database: " + ex.getMessage());
        }
        try {
            if (((JdbcMetadataData)this.data).connection != null && !((JdbcMetadataData)this.data).connection.isClosed()) {
                ((JdbcMetadataData)this.data).connection.close();
            }
        }
        catch (Exception ex) {
            this.logError("Error cleaning up connection: " + ex.getMessage());
        }
        ((JdbcMetadataData)this.data).connection = null;
        ((JdbcMetadataData)this.data).arguments = null;
        ((JdbcMetadataData)this.data).method = null;
        ((JdbcMetadataData)this.data).argumentFieldIndices = null;
        ((JdbcMetadataData)this.data).inputFieldsToCopy = null;
        ((JdbcMetadataData)this.data).resultSetIndices = null;
        super.dispose();
    }
}

