/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ScopeConfigurator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ScopeConfiguratorBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.LogLimits;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.LogRecordProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.SdkLoggerProvider;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.internal.LoggerConfig;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;

public final class SdkLoggerProviderBuilder {
    private final List<LogRecordProcessor> logRecordProcessors = new ArrayList<LogRecordProcessor>();
    private Resource resource = Resource.getDefault();
    private Supplier<LogLimits> logLimitsSupplier = LogLimits::getDefault;
    private Clock clock = Clock.getDefault();
    private ScopeConfiguratorBuilder<LoggerConfig> loggerConfiguratorBuilder = LoggerConfig.configuratorBuilder();

    SdkLoggerProviderBuilder() {
    }

    public SdkLoggerProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkLoggerProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    public SdkLoggerProviderBuilder setLogLimits(Supplier<LogLimits> logLimitsSupplier) {
        Objects.requireNonNull(logLimitsSupplier, "logLimitsSupplier");
        this.logLimitsSupplier = logLimitsSupplier;
        return this;
    }

    public SdkLoggerProviderBuilder addLogRecordProcessor(LogRecordProcessor processor) {
        Objects.requireNonNull(processor, "processor");
        this.logRecordProcessors.add(processor);
        return this;
    }

    public SdkLoggerProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    SdkLoggerProviderBuilder setLoggerConfigurator(ScopeConfigurator<LoggerConfig> loggerConfigurator) {
        this.loggerConfiguratorBuilder = loggerConfigurator.toBuilder();
        return this;
    }

    SdkLoggerProviderBuilder addLoggerConfiguratorCondition(Predicate<InstrumentationScopeInfo> scopeMatcher, LoggerConfig loggerConfig) {
        this.loggerConfiguratorBuilder.addCondition(scopeMatcher, loggerConfig);
        return this;
    }

    public SdkLoggerProvider build() {
        return new SdkLoggerProvider(this.resource, this.logLimitsSupplier, this.logRecordProcessors, this.clock, this.loggerConfiguratorBuilder.build());
    }
}

