/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.rar;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Identifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.rar.Action;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.rar.AuthorizationType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.rar.DataType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.rar.Location;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.rar.Privilege;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.ListUtils;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

public class AuthorizationDetail {
    private final JSONObject jsonObject;

    private AuthorizationDetail(JSONObject jsonObject) {
        this.jsonObject = Objects.requireNonNull(jsonObject);
    }

    public AuthorizationType getType() {
        try {
            return new AuthorizationType(JSONObjectUtils.getNonBlankString(this.jsonObject, "type"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Location> getLocations() {
        List<String> values = this.getStringListField("locations");
        if (values == null) {
            return null;
        }
        LinkedList<Location> locations = new LinkedList<Location>();
        for (String v : ListUtils.removeNullItems(values)) {
            locations.add(new Location(v));
        }
        return Collections.unmodifiableList(locations);
    }

    public List<Action> getActions() {
        List<String> values = this.getStringListField("actions");
        if (values == null) {
            return null;
        }
        LinkedList<Action> actions = new LinkedList<Action>();
        for (String v : ListUtils.removeNullItems(values)) {
            actions.add(new Action(v));
        }
        return Collections.unmodifiableList(actions);
    }

    public List<DataType> getDataTypes() {
        List<String> values = this.getStringListField("datatypes");
        if (values == null) {
            return null;
        }
        LinkedList<DataType> dataTypes = new LinkedList<DataType>();
        for (String v : ListUtils.removeNullItems(values)) {
            dataTypes.add(new DataType(v));
        }
        return Collections.unmodifiableList(dataTypes);
    }

    public Identifier getIdentifier() {
        String value;
        try {
            value = JSONObjectUtils.getNonBlankString(this.jsonObject, "identifier");
        }
        catch (ParseException e) {
            return null;
        }
        if (value.trim().isEmpty()) {
            return null;
        }
        return new Identifier(value);
    }

    public List<Privilege> getPrivileges() {
        List<String> values = this.getStringListField("privileges");
        if (values == null) {
            return null;
        }
        LinkedList<Privilege> privileges = new LinkedList<Privilege>();
        for (String v : ListUtils.removeNullItems(values)) {
            privileges.add(new Privilege(v));
        }
        return Collections.unmodifiableList(privileges);
    }

    public Object getField(String name) {
        return this.jsonObject.get(name);
    }

    public String getStringField(String name) {
        try {
            return JSONObjectUtils.getNonBlankString(this.jsonObject, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public List<String> getStringListField(String name) {
        try {
            return JSONObjectUtils.getStringList(this.jsonObject, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public JSONObject getJSONObjectField(String name) {
        try {
            return JSONObjectUtils.getJSONObject(this.jsonObject, name);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.putAll(this.jsonObject);
        return o;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorizationDetail)) {
            return false;
        }
        AuthorizationDetail detail = (AuthorizationDetail)o;
        return Objects.equals(this.jsonObject, detail.jsonObject);
    }

    public int hashCode() {
        return Objects.hash(this.jsonObject);
    }

    public static JSONArray toJSONArray(List<AuthorizationDetail> details) {
        JSONArray jsonArray = new JSONArray();
        for (AuthorizationDetail detail : details) {
            jsonArray.add(detail.toJSONObject());
        }
        return jsonArray;
    }

    public static String toJSONString(List<AuthorizationDetail> details) {
        return AuthorizationDetail.toJSONArray(details).toJSONString();
    }

    public static AuthorizationDetail parse(JSONObject jsonObject) throws ParseException {
        AuthorizationDetail detail = new AuthorizationDetail(jsonObject);
        try {
            detail.getType();
        }
        catch (Exception e) {
            throw new ParseException("Illegal or missing type");
        }
        return detail;
    }

    public static List<AuthorizationDetail> parseList(List<JSONObject> jsonObjects) throws ParseException {
        LinkedList<AuthorizationDetail> details = new LinkedList<AuthorizationDetail>();
        int i = 0;
        for (JSONObject jsonObject : ListUtils.removeNullItems(jsonObjects)) {
            AuthorizationDetail detail;
            try {
                detail = AuthorizationDetail.parse(jsonObject);
            }
            catch (ParseException e) {
                throw new ParseException("Invalid authorization detail at position " + i + ": " + e.getMessage());
            }
            details.add(detail);
        }
        return Collections.unmodifiableList(details);
    }

    public static List<AuthorizationDetail> parseList(String json) throws ParseException {
        try {
            JSONArray jsonArray = JSONArrayUtils.parse(json);
            List<JSONObject> jsonObjects = JSONArrayUtils.toJSONObjectList(jsonArray);
            return AuthorizationDetail.parseList(jsonObjects);
        }
        catch (ParseException e) {
            throw new ParseException("Invalid authorization details: " + e.getMessage());
        }
    }

    public static class Builder {
        private final JSONObject jsonObject = new JSONObject();

        public Builder(AuthorizationType type) {
            this.jsonObject.put("type", type.getValue());
        }

        public Builder locations(List<Location> locations) {
            if (locations != null) {
                this.jsonObject.put("locations", Identifier.toStringList(locations));
            } else {
                this.jsonObject.remove("locations");
            }
            return this;
        }

        public Builder actions(List<Action> actions) {
            if (actions != null) {
                this.jsonObject.put("actions", Identifier.toStringList(actions));
            } else {
                this.jsonObject.remove("actions");
            }
            return this;
        }

        public Builder dataTypes(List<DataType> dataTypes) {
            if (dataTypes != null) {
                this.jsonObject.put("datatypes", Identifier.toStringList(dataTypes));
            } else {
                this.jsonObject.remove("datatypes");
            }
            return this;
        }

        public Builder identifier(Identifier identifier) {
            if (identifier != null) {
                this.jsonObject.put("identifier", identifier.getValue());
            } else {
                this.jsonObject.remove("identifier");
            }
            return this;
        }

        public Builder privileges(List<Privilege> privileges) {
            if (privileges != null) {
                this.jsonObject.put("privileges", Identifier.toStringList(privileges));
            } else {
                this.jsonObject.remove("privileges");
            }
            return this;
        }

        public Builder field(String name, Object value) {
            if (value != null) {
                this.jsonObject.put(name, value);
            } else {
                this.jsonObject.remove(name);
            }
            return this;
        }

        public AuthorizationDetail build() {
            return new AuthorizationDetail(this.jsonObject);
        }
    }
}

