/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class SecurityUtil {
    private static final SFLogger LOGGER = SFLoggerFactory.getLogger(SecurityUtil.class);
    public static final String BOUNCY_CASTLE_FIPS_PROVIDER = "BCFIPS";
    public static final String BOUNCY_CASTLE_PROVIDER = "BC";
    private static final String DEFAULT_SECURITY_PROVIDER_NAME = "net.snowflake.client.jdbc.internal.org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final String ENABLE_BOUNCYCASTLE_PROVIDER_JVM = "net.snowflake.jdbc.enableBouncyCastle";

    public static void addBouncyCastleProvider() {
        if (Security.getProvider(BOUNCY_CASTLE_FIPS_PROVIDER) == null) {
            Security.addProvider(SecurityUtil.instantiateSecurityProvider());
        }
    }

    private static Provider instantiateSecurityProvider() {
        try {
            Class<?> klass = Class.forName(DEFAULT_SECURITY_PROVIDER_NAME);
            return (Provider)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            String errMsg = String.format("Failed to load %s, err=%s. If you use Snowflake JDBC for FIPS jar, import BouncyCastleFipsProvider in the application.", DEFAULT_SECURITY_PROVIDER_NAME, ex.getMessage());
            LOGGER.error(errMsg, true);
            throw new RuntimeException(errMsg, ex);
        }
    }
}

