/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.language;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.language.DetectLanguageMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DetectLanguageDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = DetectLanguageDialog.class;
    private boolean gotPreviousFields = false;
    private CCombo wCorpusFieldName;
    private Button wParallelism;
    private final DetectLanguageMeta input;

    public DetectLanguageDialog(Shell parent, IVariables variables, DetectLanguageMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        Listener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DetectLanguageDialog.Shell.Title", (String[])new String[0]));
        int middle = PropsUi.getInstance().getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DetectLanguageDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addListener(24, lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlCorpusFieldName = new Label((Composite)this.shell, 131072);
        wlCorpusFieldName.setText(BaseMessages.getString(PKG, (String)"DetectLanguageDialog.CorpusFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCorpusFieldName);
        FormData fdlCorpusFieldName = new FormData();
        fdlCorpusFieldName.left = new FormAttachment(0, 0);
        fdlCorpusFieldName.right = new FormAttachment(middle, -margin);
        fdlCorpusFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        wlCorpusFieldName.setLayoutData((Object)fdlCorpusFieldName);
        this.wCorpusFieldName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wCorpusFieldName);
        this.wCorpusFieldName.addListener(24, lsMod);
        FormData fdCorpusFieldName = new FormData();
        fdCorpusFieldName.left = new FormAttachment(middle, 0);
        fdCorpusFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdCorpusFieldName.right = new FormAttachment(100, 0);
        this.wCorpusFieldName.setLayoutData((Object)fdCorpusFieldName);
        this.wCorpusFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DetectLanguageDialog.this.shell.getDisplay(), 1);
                DetectLanguageDialog.this.shell.setCursor(busy);
                DetectLanguageDialog.this.get();
                DetectLanguageDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlParallelism = new Label((Composite)this.shell, 131072);
        wlParallelism.setText(BaseMessages.getString(PKG, (String)"DetectLanguageDialog.Parallelism.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlParallelism);
        FormData fdlParallelism = new FormData();
        fdlParallelism.left = new FormAttachment(0, 0);
        fdlParallelism.top = new FormAttachment((Control)this.wCorpusFieldName, margin);
        fdlParallelism.right = new FormAttachment(middle, -2 * margin);
        wlParallelism.setLayoutData((Object)fdlParallelism);
        this.wParallelism = new Button((Composite)this.shell, 32);
        this.wParallelism.setSelection(this.input.isParallelism());
        PropsUi.setLook((Widget)this.wParallelism);
        this.wParallelism.setToolTipText(BaseMessages.getString(PKG, (String)"DetectLanguageDialog.Parallelism.Tooltip", (String[])new String[0]));
        FormData fdParallelism = new FormData();
        fdParallelism.left = new FormAttachment(middle, -margin);
        fdParallelism.top = new FormAttachment((Control)this.wCorpusFieldName, margin * 2);
        fdParallelism.right = new FormAttachment(100, 0);
        this.wParallelism.setLayoutData((Object)fdParallelism);
        this.wParallelism.addListener(13, lsMod);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.input.getCorpusField() != null) {
            this.wCorpusFieldName.setText(this.input.getCorpusField());
        }
        this.wParallelism.setSelection(this.input.isParallelism());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setCorpusField(this.wCorpusFieldName.getText());
        this.input.setParallelism(this.wParallelism.getSelection());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String corpusField = null;
                if (this.wCorpusFieldName.getText() != null) {
                    corpusField = this.wCorpusFieldName.getText();
                }
                this.wCorpusFieldName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wCorpusFieldName.setItems(r.getFieldNames());
                }
                if (corpusField != null) {
                    this.wCorpusFieldName.setText(corpusField);
                }
                this.gotPreviousFields = true;
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DetectLanguageDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DetectLanguageDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

