/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class NumberFn
extends SystemFunction
implements MappingFunction {
    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.useContextItemAsDefault();
        return this.simplifyArguments(staticContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xPathContext);
        if (item == null) {
            return DoubleValue.NaN;
        }
        if (item instanceof BooleanValue || item instanceof NumericValue) {
            return ((AtomicValue)item).convert(517, xPathContext);
        }
        if (item instanceof StringValue && !(item instanceof AnyURIValue)) {
            CharSequence charSequence = item.getStringValueCS();
            try {
                return new DoubleValue(Value.stringToNumber(charSequence));
            }
            catch (NumberFormatException numberFormatException) {
                return DoubleValue.NaN;
            }
        }
        return DoubleValue.NaN;
    }

    public static DoubleValue convert(AtomicValue atomicValue) {
        try {
            if (atomicValue == null) {
                return DoubleValue.NaN;
            }
            if (atomicValue instanceof BooleanValue || atomicValue instanceof NumericValue) {
                return (DoubleValue)atomicValue.convert(517, null);
            }
            CharSequence charSequence = atomicValue.getStringValueCS();
            return new DoubleValue(Value.stringToNumber(charSequence));
        }
        catch (NumberFormatException numberFormatException) {
            return DoubleValue.NaN;
        }
        catch (XPathException xPathException) {
            return DoubleValue.NaN;
        }
    }

    public Object map(Item item, XPathContext xPathContext) throws XPathException {
        return NumberFn.convert((AtomicValue)item);
    }
}

