/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.runners.core.metrics.DirtyState;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.MetricName;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class DistributionCell
implements Distribution,
MetricCell<DistributionData> {
    private final @UnknownKeyFor @NonNull @Initialized DirtyState dirty = new DirtyState();
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized DistributionData> value = new AtomicReference<DistributionData>(DistributionData.EMPTY);
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;

    public DistributionCell(@UnknownKeyFor @NonNull @Initialized MetricName name) {
        this.name = name;
    }

    @Override
    public void reset() {
        this.value.set(DistributionData.EMPTY);
        this.dirty.reset();
    }

    public void update(@UnknownKeyFor @NonNull @Initialized long n) {
        this.update(DistributionData.singleton(n));
    }

    public void update(@UnknownKeyFor @NonNull @Initialized long sum, @UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized long min, @UnknownKeyFor @NonNull @Initialized long max) {
        this.update(DistributionData.create(sum, count, min, max));
    }

    void update(@UnknownKeyFor @NonNull @Initialized DistributionData data) {
        DistributionData original;
        while (!this.value.compareAndSet(original = this.value.get(), original.combine(data))) {
        }
        this.dirty.afterModification();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DistributionData getCumulative() {
        return this.value.get();
    }

    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof DistributionCell) {
            DistributionCell distributionCell = (DistributionCell)object;
            return Objects.equals(this.dirty, distributionCell.dirty) && Objects.equals(this.value.get(), distributionCell.value.get()) && Objects.equals(this.name, distributionCell.name);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.dirty, this.value.get(), this.name);
    }
}

