/*
 * Decompiled with CFR 0.152.
 */
package org.connectbot.simplesocks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class Socks5Server {
    private static final int ATYPE_IPV4 = 1;
    private static final int ATYPE_DNS = 3;
    private static final int ATYPE_IPV6 = 4;
    private final DataInputStream in;
    private final DataOutputStream out;
    private Command command;
    private InetAddress address;
    private String hostName;
    private int port = -1;

    public Socks5Server(InputStream in, OutputStream out) {
        this.in = new DataInputStream(in);
        this.out = new DataOutputStream(out);
    }

    public boolean acceptAuthentication() throws IOException {
        this.checkProtocolVersion();
        int numMethods = this.in.read();
        byte[] methods = new byte[numMethods];
        this.in.readFully(methods);
        boolean success = false;
        for (byte method : methods) {
            if (method != 0) continue;
            success = true;
            break;
        }
        byte[] reply = new byte[]{5, success ? (byte)0 : -1};
        this.out.write(reply);
        return success;
    }

    private void checkProtocolVersion() throws IOException {
        if (this.in.read() != 5) {
            throw new IOException("Unsupported protocol");
        }
    }

    public boolean readRequest() throws IOException {
        int atype;
        this.checkProtocolVersion();
        boolean correct = true;
        this.command = Command.fromCommandNumber(this.in.read());
        if (this.command == null) {
            correct = false;
        }
        if (this.in.read() != 0) {
            correct = false;
        }
        if ((atype = this.in.read()) == 1) {
            byte[] addressBytes = new byte[4];
            this.in.readFully(addressBytes);
            this.address = InetAddress.getByAddress(addressBytes);
        } else if (atype == 3) {
            int hostNameLength = this.in.read();
            byte[] hostName = new byte[hostNameLength];
            this.in.readFully(hostName);
            CharsetDecoder asciiDecoder = Charset.forName("US-ASCII").newDecoder();
            CharBuffer hostBuffer = asciiDecoder.decode(ByteBuffer.wrap(hostName));
            this.hostName = hostBuffer.toString();
        } else if (atype == 4) {
            byte[] addressBytes = new byte[16];
            this.in.readFully(addressBytes);
            this.address = InetAddress.getByAddress(addressBytes);
        } else {
            correct = false;
        }
        this.port = this.in.read() << 8 | this.in.read();
        return correct;
    }

    public void sendReply(ResponseCode response) throws IOException {
        byte[] responseBytes = new byte[]{5, response.getCode(), 0, 1, 0, 0, 0, 0, 0, 0};
        this.out.write(responseBytes);
    }

    public Command getCommand() {
        return this.command;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public static enum ResponseCode {
        SUCCESS(0),
        GENERAL_FAILURE(1),
        RULESET_DENIED(2),
        NETWORK_UNREACHABLE(3),
        HOST_UNREACHABLE(4),
        CONNECTION_REFUSED(5),
        TTL_EXPIRED(6),
        COMMAND_NOT_SUPPORTED(7),
        ADDRESS_TYPE_NOT_SUPPORTED(8);

        private final byte code;

        private ResponseCode(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }
    }

    public static enum Command {
        CONNECT(1),
        BIND(2);

        private final int commandNumber;

        public static Command fromCommandNumber(int commandNumber) {
            if (commandNumber == CONNECT.commandNumber()) {
                return CONNECT;
            }
            if (commandNumber == BIND.commandNumber()) {
                return BIND;
            }
            return null;
        }

        private Command(int commandNumber) {
            this.commandNumber = commandNumber;
        }

        public int commandNumber() {
            return this.commandNumber;
        }
    }
}

