/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.signature;

import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import com.trilead.ssh2.signature.SSHSignature;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

public class DSASHA1Verify
implements SSHSignature {
    private static final Logger log = Logger.getLogger(DSASHA1Verify.class);
    public static final String ID_SSH_DSS = "ssh-dss";

    private DSASHA1Verify() {
    }

    public static DSASHA1Verify get() {
        return InstanceHolder.sInstance;
    }

    @Override
    public String getKeyFormat() {
        return ID_SSH_DSS;
    }

    @Override
    public PublicKey decodePublicKey(byte[] key) throws IOException {
        TypesReader tr = new TypesReader(key);
        String key_format = tr.readString();
        if (!key_format.equals(ID_SSH_DSS)) {
            throw new IllegalArgumentException("This is not a ssh-dss public key!");
        }
        BigInteger p = tr.readMPINT();
        BigInteger q = tr.readMPINT();
        BigInteger g = tr.readMPINT();
        BigInteger y = tr.readMPINT();
        if (tr.remain() != 0) {
            throw new IOException("Padding in DSA public key!");
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("DSA");
            DSAPublicKeySpec ks = new DSAPublicKeySpec(y, p, q, g);
            return (DSAPublicKey)kf.generatePublic(ks);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] encodePublicKey(PublicKey pk) throws IOException {
        DSAPublicKey dsaPublicKey = (DSAPublicKey)pk;
        TypesWriter tw = new TypesWriter();
        tw.writeString(ID_SSH_DSS);
        DSAParams params = dsaPublicKey.getParams();
        tw.writeMPInt(params.getP());
        tw.writeMPInt(params.getQ());
        tw.writeMPInt(params.getG());
        tw.writeMPInt(dsaPublicKey.getY());
        return tw.getBytes();
    }

    private static byte[] encodeSignature(byte[] ds) {
        TypesWriter tw = new TypesWriter();
        tw.writeString(ID_SSH_DSS);
        int index = 3;
        int len = ds[index++] & 0xFF;
        byte[] r = new byte[len];
        System.arraycopy(ds, index, r, 0, r.length);
        index = index + len + 1;
        len = ds[index++] & 0xFF;
        byte[] s = new byte[len];
        System.arraycopy(ds, index, s, 0, s.length);
        byte[] a40 = new byte[40];
        int r_copylen = r.length < 20 ? r.length : 20;
        int s_copylen = s.length < 20 ? s.length : 20;
        System.arraycopy(r, r.length - r_copylen, a40, 20 - r_copylen, r_copylen);
        System.arraycopy(s, s.length - s_copylen, a40, 40 - s_copylen, s_copylen);
        tw.writeString(a40, 0, 40);
        return tw.getBytes();
    }

    private byte[] decodeSignature(byte[] sig) throws IOException {
        byte[] tmp;
        byte[] rsArray = null;
        if (sig.length == 40) {
            rsArray = sig;
        } else {
            TypesReader tr = new TypesReader(sig);
            String sig_format = tr.readString();
            if (!sig_format.equals(ID_SSH_DSS)) {
                throw new IOException("Peer sent wrong signature format");
            }
            rsArray = tr.readByteString();
            if (rsArray.length != 40) {
                throw new IOException("Peer sent corrupt signature");
            }
            if (tr.remain() != 0) {
                throw new IOException("Padding in DSA signature!");
            }
        }
        int i = 0;
        int j = 0;
        if (rsArray[0] == 0 && rsArray[1] == 0 && rsArray[2] == 0) {
            j = rsArray[i++] << 24 & 0xFF000000 | rsArray[i++] << 16 & 0xFF0000 | rsArray[i++] << 8 & 0xFF00 | rsArray[i++] & 0xFF;
            i += j;
            j = rsArray[i++] << 24 & 0xFF000000 | rsArray[i++] << 16 & 0xFF0000 | rsArray[i++] << 8 & 0xFF00 | rsArray[i++] & 0xFF;
            tmp = new byte[j];
            System.arraycopy(rsArray, i, tmp, 0, j);
            rsArray = tmp;
        }
        int frst = (rsArray[0] & 0x80) != 0 ? 1 : 0;
        int scnd = (rsArray[20] & 0x80) != 0 ? 1 : 0;
        int length = rsArray.length + 6 + frst + scnd;
        tmp = new byte[length];
        tmp[0] = 48;
        if (rsArray.length != 40) {
            throw new IOException("Peer sent corrupt signature");
        }
        tmp[1] = 44;
        tmp[1] = (byte)(tmp[1] + frst);
        tmp[1] = (byte)(tmp[1] + scnd);
        tmp[2] = 2;
        tmp[3] = 20;
        tmp[3] = (byte)(tmp[3] + frst);
        System.arraycopy(rsArray, 0, tmp, 4 + frst, 20);
        tmp[4 + tmp[3]] = 2;
        tmp[5 + tmp[3]] = 20;
        int n = 5 + tmp[3];
        tmp[n] = (byte)(tmp[n] + scnd);
        System.arraycopy(rsArray, 20, tmp, 6 + tmp[3] + scnd, 20);
        rsArray = tmp;
        return rsArray;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] sshSig, PublicKey dpk) throws IOException {
        byte[] javaSig = this.decodeSignature(sshSig);
        try {
            Signature s = Signature.getInstance("SHA1withDSA");
            s.initVerify(dpk);
            s.update(message);
            return s.verify(javaSig);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException("No such algorithm", e);
        }
        catch (SignatureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] generateSignature(byte[] message, PrivateKey pk, SecureRandom rnd) throws IOException {
        try {
            Signature s = Signature.getInstance("SHA1withDSA");
            s.initSign(pk);
            s.update(message);
            return DSASHA1Verify.encodeSignature(s.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IOException(e);
        }
    }

    private static class InstanceHolder {
        private static DSASHA1Verify sInstance = new DSASHA1Verify();

        private InstanceHolder() {
        }
    }
}

