/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filemetadata.util.delimiters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.apache.hop.core.logging.ILogChannel;

public class DelimiterDetector {
    private ArrayList<Character> delimiterCandidates;
    private ArrayList<Character> enclosureCandidates;
    private BufferedReader input;
    private long maxBadHeaderLines = 30L;
    private long maxBadFooterLines = 30L;
    private ArrayList<DetectionResult> potentialResults = new ArrayList(4);
    private ILogChannel log;
    private long rowLimit;

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public ArrayList<Character> getDelimiterCandidates() {
        return this.delimiterCandidates;
    }

    void setDelimiterCandidates(ArrayList<Character> delimiterCandidates) {
        this.delimiterCandidates = delimiterCandidates;
    }

    public ArrayList<Character> getEnclosureCandidates() {
        return this.enclosureCandidates;
    }

    void setEnclosureCandidates(ArrayList<Character> enclosureCandidates) {
        this.enclosureCandidates = enclosureCandidates;
    }

    Reader getInput() {
        return this.input;
    }

    void setInput(BufferedReader input) {
        this.input = input;
    }

    public long getMaxBadHeaderLines() {
        return this.maxBadHeaderLines;
    }

    void setMaxBadHeaderLines(long maxBadHeaderLines) {
        this.maxBadHeaderLines = maxBadHeaderLines;
    }

    public long getMaxBadFooterLines() {
        return this.maxBadFooterLines;
    }

    void setMaxBadFooterLines(long maxBadFooterLines) {
        this.maxBadFooterLines = maxBadFooterLines;
    }

    public DetectionResult detectDelimiters() throws IOException {
        for (Character delimiterCandidate : this.delimiterCandidates) {
            for (Character enclosureCandidate : this.enclosureCandidates) {
                DetectionResult detectionResult = new DetectionResult();
                detectionResult.setDelimiter(delimiterCandidate);
                detectionResult.setEnclosure(enclosureCandidate);
                this.potentialResults.add(detectionResult);
            }
            DetectionResult detectionResult = new DetectionResult();
            detectionResult.setDelimiter(delimiterCandidate);
            detectionResult.setEnclosure(null);
            this.potentialResults.add(detectionResult);
        }
        long lineNr = 0L;
        int[] frequencies = new int[this.potentialResults.size()];
        boolean[] enclosureOpen = new boolean[this.potentialResults.size()];
        boolean[] enclosureSeen = new boolean[this.potentialResults.size()];
        boolean[] enclosureConsistent = new boolean[this.potentialResults.size()];
        String s = "";
        try {
            while ((this.rowLimit <= 0L || lineNr <= this.rowLimit) && (s = this.input.readLine()) != null) {
                int j;
                ++lineNr;
                int remainingResults = this.potentialResults.size();
                for (j = 0; j < remainingResults; ++j) {
                    frequencies[j] = 0;
                    enclosureOpen[j] = false;
                    enclosureConsistent[j] = true;
                }
                for (int i = 0; i < s.length(); ++i) {
                    char sc = s.charAt(i);
                    for (int j2 = 0; j2 < remainingResults; ++j2) {
                        boolean hasEnclosure;
                        DetectionResult detectionResult = this.potentialResults.get(j2);
                        char c = detectionResult.getDelimiter().charValue();
                        Character enc = detectionResult.getEnclosure();
                        boolean bl = hasEnclosure = enc != null;
                        if (hasEnclosure) {
                            if (!enclosureOpen[j2] && sc == c) {
                                int n = j2;
                                frequencies[n] = frequencies[n] + 1;
                            }
                            if (sc != enc.charValue()) continue;
                            enclosureSeen[j2] = true;
                            enclosureConsistent[j2] = enclosureConsistent[j2] && (i == 0 && !enclosureOpen[j2] || i == s.length() - 1 && enclosureOpen[j2] || i > 0 && s.charAt(i - 1) == c && !enclosureOpen[j2] || i > 0 && s.charAt(i - 1) == enc.charValue() && !enclosureOpen[j2] || s.length() > i + 1 && s.charAt(i + 1) == c && enclosureOpen[j2] || s.length() > i + 1 && s.charAt(i + 1) == enc.charValue() && enclosureOpen[j2]);
                            enclosureOpen[j2] = !enclosureOpen[j2];
                            continue;
                        }
                        if (sc != c) continue;
                        int n = j2;
                        frequencies[n] = frequencies[n] + 1;
                    }
                }
                for (j = 0; j < remainingResults; ++j) {
                    LineResult result = new LineResult();
                    result.streak = 1L;
                    result.frequency = frequencies[j];
                    result.consistentEnclosure = enclosureConsistent[j] && !enclosureOpen[j];
                    result.enclosureSeen = enclosureSeen[j];
                    DetectionResult d = this.potentialResults.get(j);
                    d.addLineResult(result);
                }
                j = 0;
                while (j < this.potentialResults.size()) {
                    DetectionResult d = this.potentialResults.get(j);
                    if (this.isPlausible(d)) {
                        ++j;
                        continue;
                    }
                    this.potentialResults.remove(j);
                }
            }
            int j = 0;
            while (j < this.potentialResults.size()) {
                DetectionResult d = this.potentialResults.get(j);
                d.evaluate();
                if (this.qualifies(d)) {
                    ++j;
                    continue;
                }
                this.potentialResults.remove(j);
            }
            if (this.potentialResults.isEmpty()) {
                if (this.log != null) {
                    this.log.logError("All possible configurations dismissed. Inconsistent fields?");
                }
                return null;
            }
            return this.potentialResults.get(0);
        }
        catch (ArrayIndexOutOfBoundsException ex1) {
            if (this.log != null) {
                this.log.logError("Inconsistent separators on line " + lineNr + ". Line breaks in fields?");
                if (s != null) {
                    this.log.logError("offending line: " + s);
                }
            }
            ex1.printStackTrace();
            return null;
        }
        catch (IOException ex2) {
            if (this.log != null) {
                this.log.logError("Error reading around line " + lineNr + ". Invalid charset?");
                if (s != null) {
                    this.log.logError("offending line: " + s);
                }
            }
            ex2.printStackTrace();
            return null;
        }
    }

    private boolean qualifies(DetectionResult d) {
        return d.getDataLineFrequency() > 0L && d.getBadFooters() <= this.maxBadFooterLines && d.getBadHeaders() <= this.maxBadHeaderLines && (!d.hasEnclosure() || d.isConsistentEnclosure() && d.isEnclosureSeen());
    }

    private boolean isPlausible(DetectionResult d) {
        return (long)d.getStreaks() < this.maxBadFooterLines + this.maxBadHeaderLines;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public class DetectionResult {
        private ArrayDeque<LineResult> lineResults = new ArrayDeque(8);
        private Character delimiter = null;
        private Character enclosure = null;
        private long badHeaders = 0L;
        private long badFooters = 0L;
        private long dataLines = 0L;
        private long dataLineFrequency = 0L;
        private boolean consistentEnclosure = true;
        private boolean enclosureSeen = false;

        void addLineResult(LineResult lineResult) {
            if (this.lineResults.isEmpty()) {
                this.lineResults.add(lineResult);
                return;
            }
            LineResult prev = this.lineResults.peekLast();
            if (prev.frequency == lineResult.frequency && (this.enclosure == null || prev.consistentEnclosure && lineResult.consistentEnclosure)) {
                ++prev.streak;
                if (!prev.enclosureSeen) {
                    prev.enclosureSeen = lineResult.enclosureSeen;
                }
            } else {
                this.lineResults.add(lineResult);
            }
        }

        public void setDelimiter(Character delimiter) {
            this.delimiter = delimiter;
        }

        public void setEnclosure(Character enclosure) {
            this.enclosure = enclosure;
        }

        int getStreaks() {
            return this.lineResults.size();
        }

        void evaluate() {
            if (this.lineResults.isEmpty()) {
                return;
            }
            LineResult[] streaks = new LineResult[this.lineResults.size()];
            this.lineResults.toArray(streaks);
            long currentMaxStreak = streaks[0].streak;
            this.badHeaders = 0L;
            this.dataLines = streaks[0].streak;
            this.dataLineFrequency = streaks[0].frequency;
            this.badFooters = 0L;
            this.consistentEnclosure = streaks[0].consistentEnclosure;
            this.enclosureSeen = streaks[0].enclosureSeen;
            int size = streaks.length;
            for (int i = 1; i < size; ++i) {
                LineResult streak = streaks[i];
                if (!this.enclosureSeen) {
                    this.enclosureSeen = streak.enclosureSeen;
                }
                if (streak.streak >= currentMaxStreak && streak.consistentEnclosure) {
                    this.badHeaders += this.dataLines + this.badFooters;
                    this.badFooters = 0L;
                    this.dataLines = streak.streak;
                    this.dataLineFrequency = streak.frequency;
                    currentMaxStreak = streak.streak;
                    continue;
                }
                this.badFooters += streak.streak;
            }
        }

        public Character getDelimiter() {
            return this.delimiter;
        }

        public Character getEnclosure() {
            return this.enclosure;
        }

        public long getBadHeaders() {
            return this.badHeaders;
        }

        public long getBadFooters() {
            return this.badFooters;
        }

        public long getDataLines() {
            return this.dataLines;
        }

        public long getDataLineFrequency() {
            return this.dataLineFrequency;
        }

        public boolean isConsistentEnclosure() {
            return this.consistentEnclosure;
        }

        public boolean isEnclosureSeen() {
            return this.enclosureSeen;
        }

        public boolean hasEnclosure() {
            return this.getEnclosure() != null;
        }
    }

    class LineResult {
        long streak;
        long frequency;
        boolean consistentEnclosure;
        boolean enclosureSeen;

        LineResult() {
        }
    }
}

