/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.naming.SizeLimitExceededException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.metrics.Lineage;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.errorhandling.BadRecordRouter;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparePubsubWriteDoFn<@UnknownKeyFor InputT>
extends DoFn<InputT, PubsubMessage> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PreparePubsubWriteDoFn.class);
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_DATA_MAX_BYTES = 0xA00000;
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_MAX_ATTRIBUTES = 100;
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_ATTRIBUTE_MAX_KEY_BYTES = 256;
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_ATTRIBUTE_MAX_VALUE_BYTES = 1024;
    private static final @UnknownKeyFor @NonNull @Initialized int ORDERING_KEY_MAX_BYTE_SIZE = 1024;
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_ATTRIBUTE_ENCODE_ADDITIONAL_BYTES = 6;
    private final @UnknownKeyFor @NonNull @Initialized boolean usesOrderingKey;
    private @UnknownKeyFor @NonNull @Initialized int maxPublishBatchSize;
    private @UnknownKeyFor @NonNull @Initialized boolean logOrderingKeyUnconfigured = false;
    private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<InputT>, @UnknownKeyFor @NonNull @Initialized PubsubMessage> formatFunction;
    @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<InputT>,  @UnknownKeyFor @NonNull @Initialized PubsubIO.PubsubTopic> topicFunction;
    private transient @Nullable @UnknownKeyFor @Initialized String reportedLineage;
    private final @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter;
    private final @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PubsubMessage> outputTag;

    static @UnknownKeyFor @NonNull @Initialized int validatePubsubMessage(@UnknownKeyFor @NonNull @Initialized PubsubMessage message, @UnknownKeyFor @NonNull @Initialized int maxPublishBatchSize) throws @UnknownKeyFor @NonNull @Initialized SizeLimitExceededException {
        int payloadSize = message.getPayload().length;
        if (payloadSize > 0xA00000) {
            throw new SizeLimitExceededException("Pubsub message data field of length " + payloadSize + " exceeds maximum of " + 0xA00000 + " bytes. See https://cloud.google.com/pubsub/quotas#resource_limits");
        }
        int totalSize = payloadSize;
        @Nullable String orderingKey = message.getOrderingKey();
        if (orderingKey != null) {
            int orderingKeySize = orderingKey.getBytes(StandardCharsets.UTF_8).length;
            if (orderingKeySize > 1024) {
                throw new SizeLimitExceededException("Pubsub message ordering key of length " + orderingKeySize + " exceeds maximum of " + 1024 + " bytes. See https://cloud.google.com/pubsub/quotas#resource_limits");
            }
            totalSize += orderingKeySize;
        }
        @Nullable Map<String, String> attributes = message.getAttributeMap();
        if (payloadSize == 0 && (attributes == null || attributes.isEmpty())) {
            throw new IllegalArgumentException("Pubsub message must contain a non-empty payload or at least one attribute.");
        }
        if (attributes != null) {
            if (attributes.size() > 100) {
                throw new SizeLimitExceededException("Pubsub message contains " + attributes.size() + " attributes which exceeds the maximum of " + 100 + ". See https://cloud.google.com/pubsub/quotas#resource_limits");
            }
            totalSize += attributes.size() * 6;
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                String key = attribute.getKey();
                int keySize = key.getBytes(StandardCharsets.UTF_8).length;
                if (keySize > 256) {
                    throw new SizeLimitExceededException("Pubsub message attribute key '" + key + "' exceeds the maximum of " + 256 + " bytes. See https://cloud.google.com/pubsub/quotas#resource_limits");
                }
                totalSize += keySize;
                String value = attribute.getValue();
                int valueSize = value.getBytes(StandardCharsets.UTF_8).length;
                if (valueSize > 1024) {
                    throw new SizeLimitExceededException("Pubsub message attribute value for key '" + key + "' starting with '" + value.substring(0, Math.min(256, value.length())) + "' exceeds the maximum of " + 1024 + " bytes. See https://cloud.google.com/pubsub/quotas#resource_limits");
                }
                totalSize += valueSize;
            }
        }
        if (totalSize > maxPublishBatchSize) {
            throw new SizeLimitExceededException("Pubsub message of length " + totalSize + " exceeds maximum of " + maxPublishBatchSize + " bytes, when considering the payload and attributes. See https://cloud.google.com/pubsub/quotas#resource_limits");
        }
        return totalSize;
    }

    PreparePubsubWriteDoFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<InputT>, @UnknownKeyFor @NonNull @Initialized PubsubMessage> formatFunction, @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<InputT>,  @UnknownKeyFor @NonNull @Initialized PubsubIO.PubsubTopic> topicFunction, @UnknownKeyFor @NonNull @Initialized boolean usesOrderingKey, @UnknownKeyFor @NonNull @Initialized int maxPublishBatchSize, @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PubsubMessage> outputTag) {
        this.formatFunction = formatFunction;
        this.topicFunction = topicFunction;
        this.usesOrderingKey = usesOrderingKey;
        this.maxPublishBatchSize = maxPublishBatchSize;
        this.badRecordRouter = badRecordRouter;
        this.inputCoder = inputCoder;
        this.outputTag = outputTag;
    }

    @DoFn.ProcessElement
    public void process(@DoFn.Element InputT element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant ts, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver o) throws @UnknownKeyFor @NonNull @Initialized Exception {
        String topic;
        PubsubMessage message;
        ValueInSingleWindow valueInSingleWindow = ValueInSingleWindow.of(element, (Instant)ts, (BoundedWindow)window, (PaneInfo)paneInfo);
        try {
            message = (PubsubMessage)this.formatFunction.apply((Object)valueInSingleWindow);
        }
        catch (Exception e) {
            this.badRecordRouter.route(o, element, this.inputCoder, e, "Failed to serialize PubSub message with provided format function");
            return;
        }
        if (this.topicFunction != null) {
            try {
                message = message.withTopic(((PubsubIO.PubsubTopic)this.topicFunction.apply((Object)valueInSingleWindow)).asPath());
            }
            catch (Exception e) {
                this.badRecordRouter.route(o, element, this.inputCoder, e, "Failed to determine PubSub topic using topic function");
                return;
            }
        }
        if ((topic = message.getTopic()) != null && !topic.equals(this.reportedLineage)) {
            Lineage.getSinks().add("pubsub", "topic", PubsubClient.topicPathFromPath(topic).getDataCatalogSegments(), null);
            this.reportedLineage = topic;
        }
        if (!this.usesOrderingKey && !Strings.isNullOrEmpty((String)message.getOrderingKey())) {
            if (!this.logOrderingKeyUnconfigured) {
                LOG.warn("Encountered Pubsub message with ordering key but this sink was not configured to retain ordering keys, so they will be dropped. Please set #withOrderingKeys().");
                this.logOrderingKeyUnconfigured = true;
            }
            message = message.withOrderingKey(null);
        }
        try {
            PreparePubsubWriteDoFn.validatePubsubMessage(message, this.maxPublishBatchSize);
        }
        catch (SizeLimitExceededException e) {
            this.badRecordRouter.route(o, element, this.inputCoder, (Exception)new IllegalArgumentException(e), "PubSub message limit exceeded, see exception for details");
            return;
        }
        o.get(this.outputTag).output((Object)message);
    }
}

