/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_RowMutation;
import org.apache.beam.sdk.io.gcp.bigquery.RowMutationInformation;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class RowMutation {
    public abstract @UnknownKeyFor @NonNull @Initialized TableRow getTableRow();

    public abstract @UnknownKeyFor @NonNull @Initialized RowMutationInformation getMutationInformation();

    public static @UnknownKeyFor @NonNull @Initialized RowMutation of(@UnknownKeyFor @NonNull @Initialized TableRow tableRow, @UnknownKeyFor @NonNull @Initialized RowMutationInformation rowMutationInformation) {
        return new AutoValue_RowMutation(tableRow, rowMutationInformation);
    }

    public static class RowMutationCoder
    extends AtomicCoder<RowMutation> {
        private static final @UnknownKeyFor @NonNull @Initialized TableRowJsonCoder ROW_JSON_CODER = TableRowJsonCoder.of();
        private static final @UnknownKeyFor @NonNull @Initialized RowMutationCoder INSTANCE = new RowMutationCoder();
        private static final @UnknownKeyFor @NonNull @Initialized VarIntCoder INT_CODER = VarIntCoder.of();
        private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final @UnknownKeyFor @NonNull @Initialized RowMutationInformation.MutationType @UnknownKeyFor @NonNull @Initialized [] MUTATION_TYPES = RowMutationInformation.MutationType.values();

        public static @UnknownKeyFor @NonNull @Initialized RowMutationCoder of() {
            return INSTANCE;
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized RowMutation value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ROW_JSON_CODER.encode(value.getTableRow(), outStream);
            RowMutationInformation mutationInformation = value.getMutationInformation();
            INT_CODER.encode(Integer.valueOf(mutationInformation.getMutationType().ordinal()), outStream);
            STRING_CODER.encode(mutationInformation.getChangeSequenceNumber(), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized RowMutation decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            TableRow tableRow = ROW_JSON_CODER.decode(inStream);
            int mutationTypeOrdinal = INT_CODER.decode(inStream);
            Preconditions.checkState((mutationTypeOrdinal >= 0 && mutationTypeOrdinal < MUTATION_TYPES.length ? 1 : 0) != 0);
            RowMutationInformation.MutationType mutationType = MUTATION_TYPES[mutationTypeOrdinal];
            String changeSequenceNumber = STRING_CODER.decode(inStream);
            return RowMutation.of(tableRow, RowMutationInformation.of(mutationType, changeSequenceNumber));
        }
    }
}

