/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.types;

import com.clickhouse.client.api.data_formats.internal.ValueConverters;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.jdbc.internal.JdbcUtils;
import com.clickhouse.jdbc.metadata.ResultSetMetaDataImpl;
import com.clickhouse.jdbc.types.Array;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ArrayResultSet
implements ResultSet {
    private final Object array;
    private final int length;
    private int pos;
    private boolean closed;
    private ResultSetMetaDataImpl metadata;
    private static final ClickHouseColumn INDEX_COLUMN = ClickHouseColumn.of("INDEX", ClickHouseDataType.UInt32, false, 0, 0);
    private static final String VALUE_COLUMN = "VALUE";
    private static final ValueConverters defaultValueConverters = new ValueConverters();
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private boolean wasNull = false;
    private Map<Class<?>, Function<Object, Object>> converterMap;
    private final Map<Class<?>, Function<Object, Object>> indexConverterMap;
    private final ClickHouseDataType componentDataType;
    private final Class<?> defaultClass;
    private final ClickHouseColumn column;
    private final int columnCount;

    public ArrayResultSet(Object array, ClickHouseColumn column) {
        this.array = array;
        this.length = java.lang.reflect.Array.getLength(array);
        this.pos = -1;
        this.column = column;
        this.columnCount = 2;
        List<ClickHouseColumn> nestedColumns = column.getNestedColumns();
        ClickHouseColumn valueColumn = column.getArrayNestedLevel() == 1 ? column.getArrayBaseColumn() : nestedColumns.get(0);
        this.metadata = new ResultSetMetaDataImpl(Arrays.asList(INDEX_COLUMN, ClickHouseColumn.parse("VALUE " + valueColumn.getOriginalTypeName()).get(0)), "", "", "", JdbcUtils.DATA_TYPE_CLASS_MAP);
        this.componentDataType = valueColumn.getDataType();
        this.defaultClass = JdbcUtils.DATA_TYPE_CLASS_MAP.get(this.componentDataType);
        this.indexConverterMap = defaultValueConverters.getConvertersForType(Integer.class);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.pos == this.length || this.length == 0) {
            return false;
        }
        ++this.pos;
        return true;
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw new SQLException("Invalid column index: " + columnIndex);
        }
    }

    private void checkRowPosition() throws SQLException {
        if (this.pos < 0 || this.pos >= this.length) {
            throw new SQLException("No current row");
        }
    }

    private Map<Class<?>, Function<Object, Object>> initValueConverterMapIfNeeded(Object nonNullValue) {
        if (this.converterMap == null) {
            this.converterMap = this.array.getClass().getComponentType() == Object.class ? defaultValueConverters.getConvertersForType(nonNullValue.getClass()) : defaultValueConverters.getConvertersForType(this.array.getClass().getComponentType());
        }
        return this.converterMap;
    }

    private Object convertValue(Object value, Class<?> targetType, Map<Class<?>, Function<Object, Object>> valueConverterMap) throws SQLException {
        if (value == null || targetType == value.getClass() || targetType == Object.class) {
            return value;
        }
        Function<Object, Object> converter = valueConverterMap.get(targetType);
        if (converter != null) {
            try {
                return converter.apply(value);
            }
            catch (Exception e) {
                throw new SQLException("Failed to convert value of " + value.getClass() + " to " + targetType, "22000", e);
            }
        }
        throw new SQLException("Value of " + value.getClass() + " cannot be converted to " + targetType);
    }

    private Object getValueAsObject(int columnIndex, Class<?> type, Object defaultValue) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        if (columnIndex == 1) {
            Integer value = this.pos + 1;
            return this.convertValue(value, type, this.indexConverterMap);
        }
        Object value = java.lang.reflect.Array.get(this.array, this.pos);
        boolean bl = this.wasNull = value == null;
        if (value == null) {
            return defaultValue;
        }
        if (type == java.sql.Array.class) {
            ClickHouseColumn nestedColumn = this.column.getArrayNestedLevel() == 1 ? this.column.getArrayBaseColumn() : this.column.getNestedColumns().get(0);
            return new Array(nestedColumn, JdbcUtils.arrayToObjectArray(value));
        }
        Map<Class<?>, Function<Object, Object>> valueConverterMap = this.initValueConverterMapIfNeeded(value);
        return this.convertValue(value, type, valueConverterMap);
    }

    private void throwReadOnlyException() throws SQLException {
        throw new SQLException("ResultSet is read-only");
    }

    private void throwUnsupportedIndexOperation(int columnIndex, String operation) throws SQLException {
        if (columnIndex == 1) {
            throw new SQLFeatureNotSupportedException("operation " + operation + " is not supported on INDEX column");
        }
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        return (String)this.getValueAsObject(columnIndex, String.class, null);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.throwUnsupportedIndexOperation(columnIndex, "getBoolean");
        return (Boolean)this.getValueAsObject(columnIndex, Boolean.class, false);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            if (this.pos + 1 < 127) {
                return (byte)this.getRow();
            }
            throw new SQLException("INDEX column value too big and cannot be retrieved as byte");
        }
        return ((Number)this.getValueAsObject(columnIndex, Byte.class, 0)).byteValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            if (this.pos + 1 < Short.MAX_VALUE) {
                return (short)this.getRow();
            }
            throw new SQLException("INDEX column value too big and cannot be retrieved as short");
        }
        return ((Number)this.getValueAsObject(columnIndex, Short.class, 0)).shortValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.getRow();
        }
        return ((Number)this.getValueAsObject(columnIndex, Integer.class, 0)).intValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.getRow();
        }
        return ((Number)this.getValueAsObject(columnIndex, Long.class, 0L)).longValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.getRow();
        }
        return ((Number)this.getValueAsObject(columnIndex, Float.class, Float.valueOf(0.0f))).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (columnIndex == 1) {
            return this.getRow();
        }
        return ((Number)this.getValueAsObject(columnIndex, Double.class, 0.0)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (columnIndex == 1) {
            return BigDecimal.valueOf(this.getRow());
        }
        return (BigDecimal)this.getValueAsObject(columnIndex, BigDecimal.class, null);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.throwUnsupportedIndexOperation(columnIndex, "getBytes");
        return (byte[])this.getValueAsObject(columnIndex, byte[].class, null);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.throwUnsupportedIndexOperation(columnIndex, "getDate");
        return (Date)this.getValueAsObject(columnIndex, Date.class, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.throwUnsupportedIndexOperation(columnIndex, "getTime");
        return (Time)this.getValueAsObject(columnIndex, Time.class, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.throwUnsupportedIndexOperation(columnIndex, "getTimestamp");
        return (Timestamp)this.getValueAsObject(columnIndex, Timestamp.class, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getAsciiStream");
        throw new SQLFeatureNotSupportedException("getAsciiStream is not implemented");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getUnicodeStream");
        throw new SQLFeatureNotSupportedException("getUnicodeStream is not implemented");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getBinaryStream");
        throw new SQLFeatureNotSupportedException("getBinaryStream is not implemented");
    }

    private int getColumnIndex(String columnLabel) throws SQLException {
        if (columnLabel.equalsIgnoreCase(INDEX_COLUMN.getColumnName())) {
            return 1;
        }
        if (columnLabel.equalsIgnoreCase(VALUE_COLUMN)) {
            return 2;
        }
        throw new SQLException("Unknown column label `" + columnLabel + "`");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.getColumnIndex(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.getColumnIndex(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.getColumnIndex(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.getColumnIndex(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.getColumnIndex(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.getColumnIndex(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.getColumnIndex(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.getColumnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.getColumnIndex(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.getColumnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.getColumnIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return "";
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Class targetType = columnIndex == 1 ? Integer.class : this.defaultClass;
        return this.getObject(columnIndex, targetType);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.getColumnIndex(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.getColumnIndex(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getCharacterStream");
        throw new SQLFeatureNotSupportedException("getCharacterStream is not implemented");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getBigDecimal");
        return (BigDecimal)this.getValueAsObject(columnIndex, BigDecimal.class, null);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.pos == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.pos >= this.length;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.pos == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.length > 0 && this.pos == this.length - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.pos = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.pos = this.length;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.length > 0) {
            this.pos = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.length > 0) {
            this.pos = this.length - 1;
            return true;
        }
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return 0;
        }
        return this.pos + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.pos = row - 1;
        return !this.isAfterLast() && !this.isBeforeFirst();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.pos + 1 + rows);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.absolute(this.pos);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("Invalid fetch direction: " + direction + ". Should be one of [ResultSet.FETCH_FORWARD, ResultSet.FETCH_REVERSE, ResultSet.FETCH_UNKNOWN]");
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return 1004;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void insertRow() throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateRow() throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("refreshRow is not supported on ResultSet produced from Array object");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("cancelRowUpdates is not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        Class<?> type = map.get(this.componentDataType.getName());
        if (type == null) {
            SQLType sqlType = JdbcUtils.CLICKHOUSE_TO_SQL_TYPE_MAP.get(this.componentDataType);
            if (sqlType != null) {
                type = map.get(sqlType.getName());
            }
            if (type == null) {
                String alias;
                Iterator<String> iterator = this.componentDataType.getAliases().iterator();
                while (iterator.hasNext() && (type = map.get(alias = iterator.next())) == null) {
                }
            }
            if (type == null) {
                type = this.defaultClass;
            }
        }
        return this.getObject(columnIndex, type);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.checkRowPosition();
        this.checkColumnIndex(columnIndex);
        this.throwUnsupportedIndexOperation(columnIndex, "getRef");
        throw new SQLFeatureNotSupportedException("getRef is not implemented");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getBlob");
        throw new SQLFeatureNotSupportedException("getBlob is not implemented");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getClob");
        throw new SQLFeatureNotSupportedException("getClob is not implemented");
    }

    @Override
    public java.sql.Array getArray(int columnIndex) throws SQLException {
        this.throwUnsupportedIndexOperation(columnIndex, "getArray");
        return (java.sql.Array)this.getValueAsObject(columnIndex, java.sql.Array.class, null);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.getColumnIndex(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.getColumnIndex(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.getColumnIndex(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.getColumnIndex(columnLabel));
    }

    @Override
    public java.sql.Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.getColumnIndex(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getDate");
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.getColumnIndex(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getTime");
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.getColumnIndex(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.throwUnsupportedIndexOperation(columnIndex, "getTimestamp");
        return (Timestamp)this.getValueAsObject(columnIndex, Timestamp.class, null);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getURL");
        String value = this.getString(columnIndex);
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new SQLException("Invalid URL value", "22000", e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.getColumnIndex(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateArray(int columnIndex, java.sql.Array x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateArray(String columnLabel, java.sql.Array x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getRowId");
        throw new SQLFeatureNotSupportedException("getRowId is not implemented");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.getColumnIndex(columnLabel));
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getNClob");
        throw new SQLFeatureNotSupportedException("getNClob is not implemented");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.getColumnIndex(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getSQLXML");
        throw new SQLFeatureNotSupportedException("getSQLXML is not implemented");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.getColumnIndex(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.getColumnIndex(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        this.throwUnsupportedIndexOperation(columnIndex, "getNCharacterStream");
        throw new SQLFeatureNotSupportedException("getNCharacterStream is not implemented");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.throwReadOnlyException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkRowPosition();
        return (T)this.getValueAsObject(columnIndex, type, null);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.getColumnIndex(columnLabel), type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

