/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class Reify {
    private Reify() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>>> timestamps() {
        return new Timestamp();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized TimestampedValue<V>>>> timestampsInValue() {
        return new TimestampInValue();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>>> windows() {
        return new Window();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>>>> windowsInValue() {
        return new WindowInValue();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized TimestampedValue<V>>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> extractTimestampsFromValues() {
        return new ExtractTimestampsFromValues();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<K>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> viewAsValues(@UnknownKeyFor @NonNull @Initialized PCollectionView<V> view, @UnknownKeyFor @NonNull @Initialized Coder<V> coder) {
        return new ReifyView(view, coder);
    }

    public static <V> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<V>> viewInGlobalWindow(@UnknownKeyFor @NonNull @Initialized PCollectionView<V> view, @UnknownKeyFor @NonNull @Initialized Coder<V> coder) {
        return new ReifyViewInGlobalWindow(view, coder);
    }

    private static class ExtractTimestampsFromValues<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, TimestampedValue<V>>>, PCollection<KV<K, V>>> {
        private ExtractTimestampsFromValues() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized TimestampedValue<V>>> input) {
            KvCoder kvCoder = (KvCoder)input.getCoder();
            TimestampedValue.TimestampedValueCoder tvCoder = (TimestampedValue.TimestampedValueCoder)kvCoder.getValueCoder();
            return ((PCollection)input.apply(ParDo.of(new DoFn<KV<K, TimestampedValue<V>>, KV<K, V>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
                    return Duration.millis((long)Long.MAX_VALUE);
                }

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized TimestampedValue<V>> kv, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, V>> r) {
                    r.outputWithTimestamp(KV.of(kv.getKey(), kv.getValue().getValue()), kv.getValue().getTimestamp());
                }
            }))).setCoder(KvCoder.of(kvCoder.getKeyCoder(), tvCoder.getValueCoder()));
        }
    }

    private static class TimestampInValue<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, TimestampedValue<V>>>> {
        private TimestampInValue() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized TimestampedValue<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            KvCoder coder = (KvCoder)input.getCoder();
            return ((PCollection)input.apply(ParDo.of(new DoFn<KV<K, V>, KV<K, TimestampedValue<V>>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, V> element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized TimestampedValue<V>>> r) {
                    r.output(KV.of(element.getKey(), TimestampedValue.of(element.getValue(), timestamp)));
                }
            }))).setCoder(KvCoder.of(coder.getKeyCoder(), TimestampedValue.TimestampedValueCoder.of(coder.getValueCoder())));
        }
    }

    private static class WindowInValue<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, ValueInSingleWindow<V>>>> {
        private WindowInValue() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            KvCoder coder = (KvCoder)input.getCoder();
            return ((PCollection)input.apply(ParDo.of(new DoFn<KV<K, V>, KV<K, ValueInSingleWindow<V>>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<K, V> element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<V>>> r) {
                    r.output(KV.of(element.getKey(), ValueInSingleWindow.of(element.getValue(), timestamp, window, paneInfo)));
                }
            }))).setCoder(KvCoder.of(coder.getKeyCoder(), ValueInSingleWindow.Coder.of(coder.getValueCoder(), input.getWindowingStrategy().getWindowFn().windowCoder())));
        }
    }

    private static class Timestamp<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<TimestampedValue<T>>> {
        private Timestamp() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return ((PCollection)input.apply(ParDo.of(new DoFn<T, TimestampedValue<T>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element T element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized TimestampedValue<T>> r) {
                    r.output(TimestampedValue.of(element, timestamp));
                }
            }))).setCoder(TimestampedValue.TimestampedValueCoder.of(input.getCoder()));
        }
    }

    private static class Window<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<ValueInSingleWindow<T>>> {
        private Window() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return ((PCollection)input.apply(ParDo.of(new DoFn<T, ValueInSingleWindow<T>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element T element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>> r) {
                    r.outputWithTimestamp(ValueInSingleWindow.of(element, timestamp, window, paneInfo), timestamp);
                }
            }))).setCoder(ValueInSingleWindow.Coder.of(input.getCoder(), input.getWindowingStrategy().getWindowFn().windowCoder()));
        }
    }

    private static class ReifyViewInGlobalWindow<@UnknownKeyFor V>
    extends PTransform<PBegin, PCollection<V>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<V> view;
        private final @UnknownKeyFor @NonNull @Initialized Coder<V> coder;

        private ReifyViewInGlobalWindow(@UnknownKeyFor @NonNull @Initialized PCollectionView<V> view, @UnknownKeyFor @NonNull @Initialized Coder<V> coder) {
            this.view = view;
            this.coder = coder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<V> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return (PCollection)((PCollection)input.apply(Create.of(null, new Void[0]).withCoder(VoidCoder.of()))).apply(Reify.viewAsValues(this.view, this.coder)).apply(Values.create());
        }
    }

    private static class ReifyView<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<K>, PCollection<KV<K, V>>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<V> view;
        private final @UnknownKeyFor @NonNull @Initialized Coder<V> coder;

        private ReifyView(@UnknownKeyFor @NonNull @Initialized PCollectionView<V> view, @UnknownKeyFor @NonNull @Initialized Coder<V> coder) {
            this.view = view;
            this.coder = coder;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<K> input) {
            return ((PCollection)input.apply(ParDo.of(new DoFn<K, KV<K, V>>(){

                @DoFn.ProcessElement
                public void process(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    c.output(KV.of(c.element(), c.sideInput(view)));
                }
            }).withSideInputs(this.view))).setCoder(KvCoder.of(input.getCoder(), this.coder));
        }
    }
}

