/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.implementation.ImplUtils;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public final class UrlSanitizer {
    static final Set<String> DEFAULT_QUERY_PARAMS_ALLOWLIST = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("api-version")));
    private final Set<String> allowedQueryParamNames;

    public UrlSanitizer(Collection<String> allowedQueryParamNames) {
        if (allowedQueryParamNames == null) {
            this.allowedQueryParamNames = DEFAULT_QUERY_PARAMS_ALLOWLIST;
        } else {
            this.allowedQueryParamNames = allowedQueryParamNames.stream().map(queryParamName -> queryParamName.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            this.allowedQueryParamNames.addAll(DEFAULT_QUERY_PARAMS_ALLOWLIST);
        }
    }

    public String getRedactedUrl(URL url) {
        String query = url.getQuery();
        if (CoreUtils.isNullOrEmpty(query)) {
            return url.toString();
        }
        UrlBuilder urlBuilder = ImplUtils.parseUrl(url, false);
        CoreUtils.parseQueryParameters(query).forEachRemaining(queryParam -> {
            if (this.allowedQueryParamNames.contains(((String)queryParam.getKey()).toLowerCase(Locale.ROOT))) {
                urlBuilder.addQueryParameter((String)queryParam.getKey(), (String)queryParam.getValue());
            } else {
                urlBuilder.addQueryParameter((String)queryParam.getKey(), "REDACTED");
            }
        });
        return urlBuilder.toString();
    }
}

