/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;

public class HCatFileUtil {
    private static final Pattern customPathPattern = Pattern.compile("(\\$\\{)([^\\s/\\{\\}\\\\]+)(\\})");

    public static String resolveCustomPath(OutputJobInfo jobInfo, Map<String, String> dynPartKVs, boolean createRegexPath) {
        String customPath = jobInfo.getCustomDynamicPath();
        Matcher matcher = customPathPattern.matcher(customPath);
        HashSet<String> partColumns = new HashSet<String>();
        Map<String, String> partKVs = dynPartKVs != null ? dynPartKVs : jobInfo.getPartitionValues();
        StringBuilder sb = new StringBuilder();
        int previousEndIndex = 0;
        while (matcher.find()) {
            sb.append(customPath.substring(previousEndIndex, matcher.start()));
            if (createRegexPath) {
                sb.append(matcher.group(1));
            }
            String columnName = matcher.group(2).toLowerCase();
            partColumns.add(columnName);
            String columnValue = partKVs.get(columnName);
            if (columnValue != null) {
                sb.append(columnValue);
            } else {
                sb.append("__HIVE_DEFAULT_PARTITION__");
            }
            if (createRegexPath) {
                sb.append(matcher.group(3));
            }
            previousEndIndex = matcher.end();
        }
        if (previousEndIndex < customPath.length()) {
            sb.append(customPath.substring(previousEndIndex, customPath.length()));
        }
        if (partColumns.size() != jobInfo.getDynamicPartitioningKeys().size()) {
            throw new IllegalArgumentException("Unable to configure custom dynamic location,  mismatch between number of dynamic partition columns obtained[" + partColumns.size() + "] and number of dynamic partition columns required[" + jobInfo.getDynamicPartitioningKeys().size() + "]");
        }
        return sb.toString();
    }

    public static void getPartKeyValuesForCustomLocation(Map<String, String> partSpec, OutputJobInfo jobInfo, String partitionPath) {
        Matcher customPathMatcher = customPathPattern.matcher(jobInfo.getCustomDynamicPath());
        Matcher dynamicPathMatcher = customPathPattern.matcher(partitionPath);
        while (customPathMatcher.find() && dynamicPathMatcher.find()) {
            partSpec.put(customPathMatcher.group(2), dynamicPathMatcher.group(2));
        }
        partSpec.putAll(jobInfo.getPartitionValues());
    }

    public static void setCustomPath(String customPathFormat, OutputJobInfo jobInfo) {
        Matcher m;
        Path customPath;
        URI customURI = customPath.toUri();
        for (customPath = new Path(customPathFormat); customPath != null && !customPath.toString().isEmpty() && (m = customPathPattern.matcher(customPath.toString())).find(); customPath = customPath.getParent()) {
        }
        URI rootURI = customPath.toUri();
        URI childURI = rootURI.relativize(customURI);
        jobInfo.setCustomDynamicLocation(rootURI.getPath(), childURI.getPath());
    }
}

