/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.drools.core.base.ClassObjectType;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.QueryImpl;
import org.drools.core.spi.AcceptsClassObjectType;
import org.drools.core.spi.ObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbductiveQuery
extends QueryImpl
implements Externalizable,
AcceptsClassObjectType {
    private static final Logger LOG = LoggerFactory.getLogger(AbductiveQuery.class);
    private ObjectType returnType;
    private transient Constructor cachedConstructor;
    private String[] params;
    private String[] abducibleArgs;
    private int[] arg2param;
    private Object value;
    private boolean returnBound;

    public AbductiveQuery() {
    }

    public AbductiveQuery(String name) {
        super(name);
    }

    @Override
    public boolean isAbductive() {
        return true;
    }

    public void setReturnType(ObjectType objectType, String[] params, String[] args, Declaration[] declarations) throws NoSuchMethodException {
        this.returnType = objectType;
        this.params = params;
        if (args != null) {
            this.abducibleArgs = Arrays.copyOf(args, args.length);
            this.arg2param = new int[this.abducibleArgs.length];
            for (int j = 0; j < this.abducibleArgs.length; ++j) {
                boolean matched = false;
                for (int k = 0; k < params.length; ++k) {
                    if (!this.abducibleArgs[j].equals(params[k])) continue;
                    this.arg2param[j] = k;
                    matched = true;
                    break;
                }
                if (matched) continue;
                throw new IllegalArgumentException("Constructor argument " + this.abducibleArgs[j] + " cannot be resolved ");
            }
        } else {
            this.abducibleArgs = Arrays.copyOf(params, params.length - 1);
            this.arg2param = new int[this.abducibleArgs.length];
            for (int j = 0; j < this.abducibleArgs.length; ++j) {
                this.arg2param[j] = j;
            }
        }
        this.findConstructor(declarations);
    }

    protected void findConstructor(Declaration[] declarations) throws NoSuchMethodException {
        int argsLength = this.abducibleArgs.length;
        this.cachedConstructor = null;
        ArrayList availableArgs = argsLength > 0 ? new ArrayList(argsLength) : Collections.emptyList();
        for (int j = 0; j < argsLength; ++j) {
            Declaration decl;
            Declaration declaration = decl = declarations != null ? declarations[this.mapArgToParam(j)] : this.getDeclaration(this.abducibleArgs[j]);
            if (decl == null) continue;
            availableArgs.add(decl.getDeclarationClass());
        }
        Class<?> klass = this.returnType.getClassType();
        while (this.cachedConstructor == null) {
            try {
                this.cachedConstructor = klass.getConstructor(availableArgs.toArray(new Class[availableArgs.size()]));
            }
            catch (NoSuchMethodException nsme) {
                if (klass == Object.class) {
                    throw nsme;
                }
                klass = klass.getSuperclass();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.returnType);
        out.writeObject(this.params);
        out.writeObject(this.value);
        out.writeBoolean(this.returnBound);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.returnType = (ClassObjectType)in.readObject();
        this.params = (String[])in.readObject();
        this.value = in.readObject();
        this.returnBound = in.readBoolean();
    }

    public Object abduce(Object ... args) {
        Constructor constructor = this.getConstructor();
        if (constructor == null) {
            return null;
        }
        try {
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null || !constructor.getParameterTypes()[j].isPrimitive()) continue;
                args[j] = Boolean.TYPE == constructor.getParameterTypes()[j] ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
            }
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            LOG.error("Exception", (Throwable)e);
            return null;
        }
    }

    public ObjectType getReturnType() {
        return this.returnType;
    }

    public Object getValue() {
        return this.value;
    }

    public String[] getAbducibleArgs() {
        return this.abducibleArgs;
    }

    @Override
    public void setClassObjectType(ClassObjectType classObjectType) {
        this.returnType = classObjectType;
        if (this.params != null) {
            this.getConstructor();
        }
    }

    private Constructor getConstructor() {
        if (this.cachedConstructor == null || this.cachedConstructor.getDeclaringClass() != this.returnType.getClassType()) {
            try {
                this.findConstructor(null);
            }
            catch (NoSuchMethodException e) {
                LOG.error("Exception", (Throwable)e);
                this.cachedConstructor = null;
                this.returnType = null;
            }
        }
        return this.cachedConstructor;
    }

    public void setReturnBound(boolean returnBound) {
        this.returnBound = returnBound;
    }

    public boolean isReturnBound() {
        return this.returnBound;
    }

    public int mapArgToParam(int j) {
        return this.arg2param[j];
    }
}

