/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2;

import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.oauth.DbxCredential;
import com.dropbox.core.oauth.DbxRefreshResult;
import com.dropbox.core.v2.DbxClientV2Base;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.common.PathRoot;
import java.util.List;

public class DbxClientV2
extends DbxClientV2Base {
    public DbxClientV2(DbxRequestConfig requestConfig, String accessToken) {
        this(requestConfig, accessToken, DbxHost.DEFAULT, null);
    }

    public DbxClientV2(DbxRequestConfig requestConfig, String accessToken, String userId) {
        this(requestConfig, accessToken, DbxHost.DEFAULT, userId);
    }

    public DbxClientV2(DbxRequestConfig requestConfig, DbxCredential credential) {
        this(requestConfig, credential, DbxHost.DEFAULT, null, null);
    }

    public DbxClientV2(DbxRequestConfig requestConfig, String accessToken, DbxHost host) {
        this(requestConfig, accessToken, host, null);
    }

    public DbxClientV2(DbxRequestConfig requestConfig, String accessToken, DbxHost host, String userId) {
        this(requestConfig, new DbxCredential(accessToken), host, userId, null);
    }

    private DbxClientV2(DbxRequestConfig requestConfig, DbxCredential credential, DbxHost host, String userId, PathRoot pathRoot) {
        super(new DbxUserRawClientV2(requestConfig, credential, host, userId, pathRoot));
    }

    DbxClientV2(DbxRawClientV2 client) {
        super(client);
    }

    public DbxClientV2 withPathRoot(PathRoot pathRoot) {
        if (pathRoot == null) {
            throw new IllegalArgumentException("'pathRoot' should not be null");
        }
        return new DbxClientV2(this._client.withPathRoot(pathRoot));
    }

    public DbxRefreshResult refreshAccessToken() throws DbxException {
        return this._client.refreshAccessToken();
    }

    private static final class DbxUserRawClientV2
    extends DbxRawClientV2 {
        private final DbxCredential credential;

        DbxUserRawClientV2(DbxRequestConfig requestConfig, DbxCredential credential, DbxHost host, String userId, PathRoot pathRoot) {
            super(requestConfig, host, userId, pathRoot);
            if (credential == null) {
                throw new NullPointerException("credential");
            }
            this.credential = credential;
        }

        @Override
        public DbxRefreshResult refreshAccessToken() throws DbxException {
            this.credential.refresh(this.getRequestConfig());
            return new DbxRefreshResult(this.credential.getAccessToken(), (this.credential.getExpiresAt() - System.currentTimeMillis()) / 1000L);
        }

        @Override
        public boolean canRefreshAccessToken() {
            return this.credential.getRefreshToken() != null;
        }

        @Override
        public boolean needsRefreshAccessToken() {
            return this.canRefreshAccessToken() && this.credential.aboutToExpire();
        }

        @Override
        protected void addAuthHeaders(List<HttpRequestor.Header> headers) {
            DbxRequestUtil.removeAuthHeader(headers);
            DbxRequestUtil.addAuthHeader(headers, this.credential.getAccessToken());
        }

        @Override
        protected DbxRawClientV2 withPathRoot(PathRoot pathRoot) {
            return new DbxUserRawClientV2(this.getRequestConfig(), this.credential, this.getHost(), this.getUserId(), pathRoot);
        }
    }
}

