/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.datastax;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBigNumber;
import org.apache.hop.core.row.value.ValueMetaBinary;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.databases.cassandra.datastax.DriverKeyspace;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.Selector;

public class TableMetaData
implements ITableMetaData {
    private TableMetadata meta;
    private String name;
    private boolean expandCollection = true;

    public TableMetaData(DriverKeyspace keyspace, TableMetadata metadata) {
        this.meta = metadata;
        this.name = this.meta.getName().asCql(false);
        this.setKeyspace(keyspace);
    }

    @Override
    public void setKeyspace(Keyspace keyspace) {
        DriverKeyspace keyspace1 = (DriverKeyspace)keyspace;
        this.expandCollection = keyspace1.getConnection().isExpandCollection();
    }

    @Override
    public void setTableName(String tableName) {
        this.name = tableName;
    }

    @Override
    public String getTableName() {
        return this.name;
    }

    @Override
    public String describe() throws Exception {
        return this.meta.toString();
    }

    @Override
    public boolean columnExistsInSchema(String colName) {
        return this.meta.getColumn(colName).isPresent();
    }

    @Override
    public IValueMeta getValueMetaForKey() {
        List partKeys = this.meta.getPartitionKey();
        if (partKeys.size() > 1) {
            return new ValueMetaString("KEY");
        }
        ColumnMetadata key = (ColumnMetadata)partKeys.get(0);
        return TableMetaData.toValueMeta(key.getName().asCql(false), key.getType());
    }

    @Override
    public List<String> getKeyColumnNames() {
        ArrayList<String> names = new ArrayList<String>();
        this.meta.getPartitionKey().forEach(cm -> names.add(cm.getName().asCql(false)));
        return names;
    }

    @Override
    public IValueMeta getValueMetaForColumn(String colName) throws HopException {
        Optional optionalColumn = this.meta.getColumn(colName);
        if (optionalColumn.isEmpty()) {
            throw new HopException("Column " + colName + " is not present");
        }
        return this.getValueMetaForColumn((ColumnMetadata)optionalColumn.get());
    }

    protected IValueMeta getValueMetaForColumn(ColumnMetadata column) {
        if (column != null) {
            String name = column.getName().asCql(false);
            if (name.startsWith("\"")) {
                name = name.substring(1);
            }
            if (name.endsWith("\"")) {
                name = name.substring(0, name.length() - 1);
            }
            return TableMetaData.toValueMeta(name, column.getType());
        }
        return new ValueMetaString(this.name);
    }

    @Override
    public List<IValueMeta> getValueMetasForSchema() {
        ArrayList<IValueMeta> values = new ArrayList<IValueMeta>();
        Collection columns = this.meta.getColumns().values();
        for (ColumnMetadata column : columns) {
            values.add(this.getValueMetaForColumn(column));
        }
        return values;
    }

    @Override
    public IValueMeta getValueMeta(Selector selector) throws HopException {
        String name = selector.getColumnName();
        return this.getValueMetaForColumn(name);
    }

    @Override
    public List<String> getColumnNames() {
        Collection colMeta = this.meta.getColumns().values();
        ArrayList<String> colNames = new ArrayList<String>();
        for (ColumnMetadata c : colMeta) {
            colNames.add(c.getName().asCql(false));
        }
        return colNames;
    }

    @Override
    public DataType getColumnCQLType(String colName) {
        ColumnMetadata columnMetadata = (ColumnMetadata)this.meta.getColumn(colName).get();
        return columnMetadata.getType();
    }

    public static IValueMeta toValueMeta(String name, DataType dataType) {
        String typeCql;
        return switch (typeCql = dataType.asCql(false, false).toUpperCase()) {
            case "BIGINT", "COUNTER", "INT", "SMALLINT", "TINYINT" -> new ValueMetaInteger(name);
            case "DOUBLE", "FLOAT" -> new ValueMetaNumber(name);
            case "DATE", "TIMESTAMP" -> new ValueMetaDate(name);
            case "DECIMAL", "VARINT" -> new ValueMetaBigNumber(name);
            case "BLOB" -> new ValueMetaBinary(name);
            case "BOOLEAN" -> new ValueMetaBoolean(name);
            default -> new ValueMetaString(name);
        };
    }
}

