/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.shared;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.neo4j.core.data.GraphData;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.json.simple.JSONValue;
import org.neo4j.driver.Value;

public class NeoHopData {
    public static Object convertNeoToHopValue(String recordValueName, Value recordValue, GraphPropertyDataType neoType, IValueMeta targetValueMeta) throws HopException {
        if (recordValue == null || recordValue.isNull()) {
            return null;
        }
        try {
            switch (targetValueMeta.getType()) {
                case 2: {
                    return NeoHopData.convertToString(recordValue, neoType);
                }
                case 303: {
                    return NeoHopData.convertToGraphData(recordValue, neoType);
                }
                case 5: {
                    return recordValue.asLong();
                }
                case 1: {
                    return recordValue.asDouble();
                }
                case 4: {
                    return recordValue.asBoolean();
                }
                case 6: {
                    return new BigDecimal(recordValue.asString());
                }
                case 3: {
                    if (neoType != null) {
                        return switch (neoType) {
                            case GraphPropertyDataType.LocalDateTime -> {
                                LocalDateTime localDateTime = recordValue.asLocalDateTime();
                                yield java.sql.Date.valueOf(localDateTime.toLocalDate());
                            }
                            case GraphPropertyDataType.Date -> {
                                LocalDate localDate = recordValue.asLocalDate();
                                yield java.sql.Date.valueOf(localDate);
                            }
                            case GraphPropertyDataType.DateTime -> {
                                ZonedDateTime zonedDateTime = recordValue.asZonedDateTime();
                                yield Date.from(zonedDateTime.toInstant());
                            }
                            default -> throw new HopException("Conversion from Neo4j daa type " + neoType.name() + " to a Hop Date isn't supported yet");
                        };
                    }
                    LocalDate localDate = recordValue.asLocalDate();
                    return java.sql.Date.valueOf(localDate);
                }
                case 9: {
                    LocalDateTime localDateTime = recordValue.asLocalDateTime();
                    return Timestamp.valueOf(localDateTime);
                }
            }
            throw new HopException("Unable to convert Neo4j data to type " + targetValueMeta.toStringMeta());
        }
        catch (Exception e) {
            throw new HopException("Unable to convert Neo4j record value '" + recordValueName + "' to type : " + targetValueMeta.getTypeDesc(), (Throwable)e);
        }
    }

    public static String convertToString(Value recordValue, GraphPropertyDataType sourceType) {
        if (recordValue == null) {
            return null;
        }
        if (sourceType == null) {
            return JSONValue.toJSONString((Object)recordValue.asObject());
        }
        switch (sourceType) {
            case String: {
                return recordValue.asString();
            }
            case List: {
                return JSONValue.toJSONString((Object)recordValue.asList());
            }
            case Map: {
                return JSONValue.toJSONString((Object)recordValue.asMap());
            }
            case Node: {
                GraphData graphData = new GraphData();
                graphData.update(recordValue.asNode());
                return graphData.toJson().toJSONString();
            }
            case Path: {
                GraphData graphData = new GraphData();
                graphData.update(recordValue.asPath());
                return graphData.toJson().toJSONString();
            }
        }
        return JSONValue.toJSONString((Object)recordValue.asObject());
    }

    public static GraphData convertToGraphData(Value recordValue, GraphPropertyDataType sourceType) throws HopException {
        GraphData graphData;
        if (recordValue == null) {
            return null;
        }
        if (sourceType == null) {
            throw new HopException("Please specify a Neo4j source data type to convert to Graph.  NODE, RELATIONSHIP and PATH are supported.");
        }
        switch (sourceType) {
            case Node: {
                graphData = new GraphData();
                graphData.update(recordValue.asNode());
                break;
            }
            case Path: {
                graphData = new GraphData();
                graphData.update(recordValue.asPath());
                break;
            }
            default: {
                throw new HopException("We can only convert NODE, PATH and RELATIONSHIP source values to a Graph data type, not " + sourceType.name());
            }
        }
        return graphData;
    }
}

