/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodbinput;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.mongo.wrapper.field.MongoField;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mongodb.MongoDbMeta;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInput;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputData;

@Transform(id="MongoDbInput", image="mongodb-input.svg", name="i18n::MongoDbInput.Name", description="i18n::MongoDbInput.Description", documentationUrl="/pipeline/transforms/mongodbinput.html", keywords={"i18n::MongoDbInputMeta.keyword"}, categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input")
public class MongoDbInputMeta
extends MongoDbMeta<MongoDbInput, MongoDbInputData> {
    protected static final Class<?> PKG = MongoDbInputMeta.class;
    @HopMetadataProperty(key="json_field_name", injectionKey="JSON_OUTPUT_FIELD")
    private String jsonFieldName;
    @HopMetadataProperty(key="fields_name", injectionKey="JSON_FIELD")
    private String jsonField;
    @HopMetadataProperty(key="json_query", injectionKey="JSON_QUERY")
    private String jsonQuery;
    @HopMetadataProperty(key="query_is_pipeline", injectionKey="AGG_PIPELINE")
    private boolean aggPipeline = false;
    @HopMetadataProperty(key="output_json", injectionKey="OUTPUT_JSON")
    private boolean outputJson = true;
    @HopMetadataProperty(groupKey="mongo_fields", key="mongo_field", injectionKey="MONGODB_FIELDS", injectionGroupKey="MONGODB_FIELDS")
    private List<MongoField> fields;
    @HopMetadataProperty(key="execute_for_each_row", injectionKey="EXECUTE_FOR_EACH_ROW")
    private boolean executeForEachIncomingRow = false;

    public Object clone() {
        MongoDbInputMeta meta = (MongoDbInputMeta)((Object)super.clone());
        return meta;
    }

    public void setDefault() {
        this.jsonFieldName = "json";
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            if (this.outputJson || Utils.isEmpty(this.fields)) {
                IValueMeta jsonValueMeta = ValueMetaFactory.createValueMeta((String)this.jsonFieldName, (int)2);
                jsonValueMeta.setOrigin(origin);
                rowMeta.addValueMeta(jsonValueMeta);
            } else {
                for (MongoField f : this.fields) {
                    int type = ValueMetaFactory.getIdForValueMeta((String)f.hopType);
                    IValueMeta vm = ValueMetaFactory.createValueMeta((String)f.fieldName, (int)type);
                    vm.setOrigin(origin);
                    if (f.indexedValues != null) {
                        vm.setIndex(f.indexedValues.toArray());
                    }
                    rowMeta.addValueMeta(vm);
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error processing output fields of transform", (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        super.check(remarks, pipelineMeta, transformMeta, prev, input, output, info, variables, metadataProvider);
    }

    @Generated
    public String getJsonFieldName() {
        return this.jsonFieldName;
    }

    @Generated
    public String getJsonField() {
        return this.jsonField;
    }

    @Generated
    public String getJsonQuery() {
        return this.jsonQuery;
    }

    @Generated
    public boolean isAggPipeline() {
        return this.aggPipeline;
    }

    @Generated
    public boolean isOutputJson() {
        return this.outputJson;
    }

    @Generated
    public List<MongoField> getFields() {
        return this.fields;
    }

    @Generated
    public boolean isExecuteForEachIncomingRow() {
        return this.executeForEachIncomingRow;
    }

    @Generated
    public void setJsonFieldName(String jsonFieldName) {
        this.jsonFieldName = jsonFieldName;
    }

    @Generated
    public void setJsonField(String jsonField) {
        this.jsonField = jsonField;
    }

    @Generated
    public void setJsonQuery(String jsonQuery) {
        this.jsonQuery = jsonQuery;
    }

    @Generated
    public void setAggPipeline(boolean aggPipeline) {
        this.aggPipeline = aggPipeline;
    }

    @Generated
    public void setOutputJson(boolean outputJson) {
        this.outputJson = outputJson;
    }

    @Generated
    public void setFields(List<MongoField> fields) {
        this.fields = fields;
    }

    @Generated
    public void setExecuteForEachIncomingRow(boolean executeForEachIncomingRow) {
        this.executeForEachIncomingRow = executeForEachIncomingRow;
    }
}

