/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.database.DatabasePluginType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.HopFileTypeRegistry;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.config.ExplorerPerspectiveConfigSingleton;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class HelpUtils {
    private static final Class<?> PKG = HelpUtils.class;

    public static Button createHelpButton(Composite parent, IPlugin plugin) {
        Button button = HelpUtils.newButton(parent);
        button.addListener(13, e -> HelpUtils.openHelp(parent.getShell(), plugin));
        return button;
    }

    public static Button createHelpButton(Composite parent, String url) {
        Button button = HelpUtils.newButton(parent);
        button.addListener(13, e -> {
            try {
                EnvironmentUtils.getInstance().openUrl(url);
            }
            catch (Exception ex) {
                new ErrorDialog(parent.getShell(), "Error", "Error opening URL", ex);
            }
        });
        return button;
    }

    private static Button newButton(Composite parent) {
        Button button = new Button(parent, 8);
        PropsUi.setLook((Widget)button);
        button.setImage(GuiResource.getInstance().getImageHelp());
        button.setText(BaseMessages.getString(PKG, (String)"System.Button.Help", (String[])new String[0]));
        button.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Help", (String[])new String[0]));
        FormData fdButton = new FormData();
        fdButton.left = new FormAttachment(0, 0);
        fdButton.bottom = new FormAttachment(100, 0);
        button.setLayoutData((Object)fdButton);
        return button;
    }

    public static boolean isPluginDocumented(IPlugin plugin) {
        if (plugin == null) {
            return false;
        }
        return !StringUtil.isEmpty((String)plugin.getDocumentationUrl());
    }

    public static void openHelp(Shell shell, IPlugin plugin) {
        block6: {
            if (shell == null || plugin == null) {
                return;
            }
            if (HelpUtils.isPluginDocumented(plugin)) {
                try {
                    String originalUrl = Const.getDocUrl((String)plugin.getDocumentationUrl());
                    String trackedUrl = HelpUtils.appendUtmParameters(originalUrl);
                    if (ExplorerPerspectiveConfigSingleton.getConfig().isOpeningHelpFiles().booleanValue()) {
                        HelpUtils.openHelpInTab(trackedUrl);
                        break block6;
                    }
                    EnvironmentUtils.getInstance().openUrl(trackedUrl);
                }
                catch (Exception ex) {
                    new ErrorDialog(shell, "Error", "Error opening URL", ex);
                }
            } else {
                MessageBox mb = new MessageBox(shell, 33);
                String msg = "";
                msg = plugin.getPluginType().equals(TransformPluginType.class) ? BaseMessages.getString(PKG, (String)"System.Help.Transform.IsNotAvailable", (String[])new String[]{plugin.getName()}) : (plugin.getPluginType().equals(ActionPluginType.class) ? BaseMessages.getString(PKG, (String)"System.Help.Action.IsNotAvailable", (String[])new String[]{plugin.getName()}) : (plugin.getPluginType().equals(DatabasePluginType.class) ? BaseMessages.getString(PKG, (String)"System.Help.Database.IsNotAvailable", (String[])new String[]{plugin.getName()}) : BaseMessages.getString(PKG, (String)"System.Help.Metadata.IsNotAvailable", (String[])new String[]{plugin.getName()})));
                mb.setMessage(msg);
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    private static String appendUtmParameters(String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        String utmCampaign = EnvironmentUtils.getInstance().isWeb() ? "HopWeb" : "hopGui";
        String utmSource = HopEnvironment.class.getPackage().getImplementationVersion();
        String utmParams = "mtm_campaign=" + HelpUtils.encode(utmCampaign) + "&mtm_source=" + HelpUtils.encode(utmSource);
        String separator = url.contains("?") ? "&" : "?";
        return url + separator + utmParams;
    }

    private static String encode(String field) {
        if (Utils.isEmpty((CharSequence)field)) {
            return field;
        }
        return URLEncoder.encode(field, StandardCharsets.UTF_8);
    }

    private static void openHelpInTab(String url) throws HopException {
        IHopFileType htmlFileType;
        HopGui hopGui = HopGui.getInstance();
        if (hopGui != null && (htmlFileType = HopFileTypeRegistry.getInstance().findHopFileType("help.html")) != null) {
            htmlFileType.openFile(hopGui, url, hopGui.getVariables());
            return;
        }
        EnvironmentUtils.getInstance().openUrl(url);
    }
}

