/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.partition;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.partition.PartitionSchema;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PartitionSchemaEditor
extends MetadataEditor<PartitionSchema> {
    private static final Class<?> PKG = PartitionSchemaEditor.class;
    private Text wName;
    private Button wDynamic;
    private TextVar wNumber;
    private Label wlPartitions;
    private TableView wPartitions;

    public PartitionSchemaEditor(HopGui hopGui, MetadataManager<PartitionSchema> manager, PartitionSchema metadata) {
        super(hopGui, manager, metadata);
    }

    @Override
    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int margin = PropsUi.getMargin();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlicon);
        PropsUi.setLook((Widget)wIcon);
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.PartitionName.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, margin);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment((Control)wIcon, -margin);
        this.wName.setLayoutData((Object)fdName);
        Label spacer = new Label(parent, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wDynamic = new Button(parent, 32);
        PropsUi.setLook((Widget)this.wDynamic);
        this.wDynamic.setText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Dynamic.Label", (String[])new String[0]));
        this.wDynamic.setToolTipText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Dynamic.Tooltip", (String[])new String[0]));
        FormData fdDynamic = new FormData();
        fdDynamic.top = new FormAttachment((Control)spacer, margin);
        fdDynamic.left = new FormAttachment(0, 0);
        fdDynamic.right = new FormAttachment(100, 0);
        this.wDynamic.setLayoutData((Object)fdDynamic);
        this.wDynamic.addListener(13, e -> this.enableFields());
        Label wlNumber = new Label(parent, 16384);
        PropsUi.setLook((Widget)wlNumber);
        wlNumber.setText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Number.Label", (String[])new String[0]));
        FormData fdlNumber = new FormData();
        fdlNumber.top = new FormAttachment((Control)this.wDynamic, 15);
        fdlNumber.left = new FormAttachment(0, 0);
        fdlNumber.right = new FormAttachment(100, 0);
        wlNumber.setLayoutData((Object)fdlNumber);
        this.wNumber = new TextVar(this.getHopGui().getVariables(), parent, 18436, BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Number.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wNumber);
        FormData fdNumber = new FormData();
        fdNumber.top = new FormAttachment((Control)wlNumber, margin);
        fdNumber.left = new FormAttachment(0, 0);
        fdNumber.right = new FormAttachment(100, 0);
        this.wNumber.setLayoutData(fdNumber);
        this.wlPartitions = new Label(parent, 16384);
        this.wlPartitions.setText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Partitions.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPartitions);
        FormData fdlPartitions = new FormData();
        fdlPartitions.left = new FormAttachment(0, 0);
        fdlPartitions.right = new FormAttachment(100, 0);
        fdlPartitions.top = new FormAttachment((Control)this.wNumber, margin);
        this.wlPartitions.setLayoutData((Object)fdlPartitions);
        ColumnInfo[] partitionColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.PartitionID.Label", (String[])new String[0]), 1, false, false)};
        this.wPartitions = new TableView(this.manager.getVariables(), parent, 67586, partitionColumns, 1, null, props);
        PropsUi.setLook((Widget)this.wPartitions);
        FormData fdPartitions = new FormData();
        fdPartitions.left = new FormAttachment(0, 0);
        fdPartitions.right = new FormAttachment(100, 0);
        fdPartitions.top = new FormAttachment((Control)this.wlPartitions, margin);
        fdPartitions.bottom = new FormAttachment(100, -margin * 2);
        this.wPartitions.setLayoutData(fdPartitions);
        this.setWidgetsContent();
        ModifyListener lsMod = e -> this.setChanged();
        this.wName.addModifyListener(lsMod);
        this.wNumber.addModifyListener(lsMod);
        this.wDynamic.addListener(13, e -> this.setChanged());
        this.wPartitions.addModifyListener(lsMod);
    }

    private void enableFields() {
        boolean tableEnabled = !this.wDynamic.getSelection();
        this.wlPartitions.setEnabled(tableEnabled);
        this.wPartitions.setEnabled(tableEnabled);
    }

    @Override
    public void setWidgetsContent() {
        PartitionSchema partitionSchema = (PartitionSchema)this.getMetadata();
        this.wName.setText(Const.NVL((String)partitionSchema.getName(), (String)""));
        this.refreshPartitions();
        this.wDynamic.setSelection(partitionSchema.isDynamicallyDefined());
        this.wNumber.setText(Const.NVL((String)partitionSchema.getNumberOfPartitions(), (String)""));
        this.enableFields();
    }

    private void refreshPartitions() {
        this.wPartitions.clearAll(false);
        PartitionSchema partitionSchema = (PartitionSchema)this.getMetadata();
        List partitionIDs = partitionSchema.getPartitionIDs();
        for (String partitionID : partitionIDs) {
            TableItem item = new TableItem(this.wPartitions.table, 0);
            item.setText(1, partitionID);
        }
        this.wPartitions.removeEmptyRows();
        this.wPartitions.setRowNums();
        this.wPartitions.optWidth(true);
    }

    @Override
    public void getWidgetsContent(PartitionSchema partitionSchema) {
        partitionSchema.setName(this.wName.getText());
        partitionSchema.setNumberOfPartitions(this.wNumber.getText());
        partitionSchema.setDynamicallyDefined(this.wDynamic.getSelection());
        ArrayList<String> parts = new ArrayList<String>();
        int nrNonEmptyPartitions = this.wPartitions.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyPartitions; ++i) {
            parts.add(this.wPartitions.getNonEmpty(i).getText(1));
        }
        partitionSchema.setPartitionIDs(parts);
    }

    @Override
    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }
}

