/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.delegates;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.StyledTextVar;
import org.apache.hop.ui.core.widget.TextComposite;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiLogBrowser;
import org.apache.hop.ui.hopgui.file.shared.TextZoom;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="Workflow Graph Log Delegate")
public class HopGuiWorkflowLogDelegate {
    private static final Class<?> PKG = HopGuiWorkflowGraph.class;
    private static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "HopGuiWorkflowLogDelegate-ToolBar";
    public static final String TOOLBAR_ICON_CLEAR_LOG_VIEW = "ToolbarIcon-10000-ClearLog";
    public static final String TOOLBAR_ICON_SHOW_ERROR_LINES = "ToolbarIcon-10010-ShowErrorLines";
    public static final String TOOLBAR_ICON_LOG_COPY_TO_CLIPBOARD = "ToolbarIcon-10020-LogCopyToClipboard";
    public static final String TOOLBAR_ICON_LOG_PAUSE_RESUME = "ToolbarIcon-10030-LogPauseResume";
    public static final String TOOLBAR_ICON_LOG_INCREASE_FONT = "ToolbarIcon-10040-LogIncreaseFont";
    public static final String TOOLBAR_ICON_LOG_DECREASE_FONT = "ToolbarIcon-10050-LogDecreaseFont";
    public static final String TOOLBAR_ICON_LOG_RESET_FONT = "ToolbarIcon-10060-LogResetFont";
    private HopGui hopGui;
    private HopGuiWorkflowGraph workflowGraph;
    private CTabItem workflowLogTab;
    private TextComposite workflowLogText;
    private TextZoom textZoom;
    private Composite workflowLogComposite;
    private ToolBar toolbar;
    private GuiToolbarWidgets toolBarWidgets;
    private HopGuiLogBrowser logBrowser;

    public HopGuiWorkflowLogDelegate(HopGui hopGui, HopGuiWorkflowGraph workflowGraph) {
        this.hopGui = hopGui;
        this.workflowGraph = workflowGraph;
    }

    public void addWorkflowLog() {
        if (this.workflowGraph.extraViewTabFolder == null || this.workflowGraph.extraViewTabFolder.isDisposed()) {
            this.workflowGraph.addExtraView();
        } else if (this.workflowLogTab != null && !this.workflowLogTab.isDisposed()) {
            return;
        }
        this.workflowLogTab = new CTabItem(this.workflowGraph.extraViewTabFolder, 0);
        this.workflowLogTab.setFont(GuiResource.getInstance().getFontDefault());
        this.workflowLogTab.setImage(GuiResource.getInstance().getImageShowLog());
        this.workflowLogTab.setText(BaseMessages.getString(PKG, (String)"WorkflowGraph.LogTab.Name", (String[])new String[0]));
        this.workflowLogComposite = new Composite((Composite)this.workflowGraph.extraViewTabFolder, 0);
        this.workflowLogComposite.setLayout((Layout)new FormLayout());
        this.addToolBar();
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.toolbar.setLayoutData((Object)fd);
        this.workflowLogText = EnvironmentUtils.getInstance().isWeb() ? new StyledTextComp(this.workflowGraph.getVariables(), this.workflowLogComposite, 2826) : new StyledTextVar(this.workflowGraph.getVariables(), this.workflowLogComposite, 2826, false, false);
        PropsUi.setLook((Widget)this.workflowLogText);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment((Control)this.toolbar, 0);
        fdText.bottom = new FormAttachment(100, 0);
        this.workflowLogText.setLayoutData(fdText);
        this.textZoom = new TextZoom(this.workflowLogText, GuiResource.getInstance().getFontFixed());
        this.textZoom.resetFont();
        if (OsHelper.isMac()) {
            this.workflowLogText.setText(Const.CR);
        }
        this.logBrowser = new HopGuiLogBrowser(this.workflowLogText, this.workflowGraph);
        this.logBrowser.installLogSniffer();
        this.workflowGraph.addDisposeListener(event -> {
            if (this.workflowGraph.getWorkflow() != null) {
                HopLogStore.discardLines((String)this.workflowGraph.getWorkflow().getLogChannelId(), (boolean)true);
            }
        });
        this.workflowLogTab.setControl((Control)this.workflowLogComposite);
    }

    public static HopGuiWorkflowLogDelegate getInstance() {
        IHopFileTypeHandler fileTypeHandler = HopGui.getInstance().getActiveFileTypeHandler();
        if (fileTypeHandler instanceof HopGuiWorkflowGraph) {
            HopGuiWorkflowGraph hopGuiWorkflowGraph;
            HopGuiWorkflowGraph graph = hopGuiWorkflowGraph = (HopGuiWorkflowGraph)fileTypeHandler;
            return graph.workflowLogDelegate;
        }
        return null;
    }

    private void addToolBar() {
        this.toolbar = new ToolBar(this.workflowLogComposite, 16704);
        FormData fdToolBar = new FormData();
        fdToolBar.left = new FormAttachment(0, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        fdToolBar.right = new FormAttachment(100, 0);
        this.toolbar.setLayoutData((Object)fdToolBar);
        PropsUi.setLook((Widget)this.toolbar, 5);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)this.toolbar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        this.toolbar.pack();
    }

    @GuiToolbarElement(root="HopGuiWorkflowLogDelegate-ToolBar", id="ToolbarIcon-10000-ClearLog", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.ClearLog", image="ui/images/delete.svg")
    public void clearLog() {
        if (this.workflowLogText != null && !this.workflowLogText.isDisposed()) {
            String textToSet = OsHelper.isMac() ? Const.CR : "";
            this.workflowLogText.setText(textToSet);
        }
    }

    @GuiToolbarElement(root="HopGuiWorkflowLogDelegate-ToolBar", id="ToolbarIcon-10020-LogCopyToClipboard", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.LogCopyToClipboard", image="ui/images/copy.svg")
    public void copyToClipboard() {
        String text = this.workflowLogText.getText();
        GuiResource.getInstance().toClipboard(text);
    }

    @GuiToolbarElement(root="HopGuiWorkflowLogDelegate-ToolBar", id="ToolbarIcon-10010-ShowErrorLines", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.ShowErrorLines", image="ui/images/filter.svg")
    public void showErrors() {
        int i;
        String all = this.workflowLogText.getText();
        ArrayList<String> err = new ArrayList<String>();
        int startpos = 0;
        int crlen = Const.CR.length();
        String line = null;
        String lineUpper = null;
        for (i = 0; i < all.length() - crlen; ++i) {
            if (!all.substring(i, i + crlen).equalsIgnoreCase(Const.CR)) continue;
            line = all.substring(startpos, i);
            lineUpper = line.toUpperCase();
            if (lineUpper.indexOf(BaseMessages.getString(PKG, (String)"WorkflowLog.System.ERROR", (String[])new String[0])) >= 0 || lineUpper.indexOf(BaseMessages.getString(PKG, (String)"WorkflowLog.System.EXCEPTION", (String[])new String[0])) >= 0) {
                err.add(line);
            }
            startpos = i + crlen;
        }
        line = all.substring(startpos);
        lineUpper = line.toUpperCase();
        if (lineUpper.indexOf(BaseMessages.getString(PKG, (String)"WorkflowLog.System.ERROR", (String[])new String[0])) >= 0 || lineUpper.indexOf(BaseMessages.getString(PKG, (String)"WorkflowLog.System.EXCEPTION", (String[])new String[0])) >= 0) {
            err.add(line);
        }
        if (!err.isEmpty()) {
            String[] errLines = new String[err.size()];
            for (i = 0; i < errLines.length; ++i) {
                errLines[i] = (String)err.get(i);
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.workflowGraph.getShell(), errLines, BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.ErrorLines.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WorkflowLog.Dialog.ErrorLines.Message", (String[])new String[0]));
            line = esd.open();
            if (line != null) {
                WorkflowMeta workflowMeta = this.workflowGraph.getManagedObject();
                for (i = 0; i < workflowMeta.nrActions(); ++i) {
                    ActionMeta entryCopy = workflowMeta.getAction(i);
                    if (line.indexOf(entryCopy.getName()) < 0) continue;
                    this.workflowGraph.editAction(workflowMeta, entryCopy);
                }
            }
        }
    }

    public CTabItem getWorkflowLogTab() {
        return this.workflowLogTab;
    }

    @GuiToolbarElement(root="HopGuiWorkflowLogDelegate-ToolBar", id="ToolbarIcon-10030-LogPauseResume", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.Pause", image="ui/images/pause.svg", separator=true)
    public void pauseLog() {
        ToolItem item = this.toolBarWidgets.findToolItem(TOOLBAR_ICON_LOG_PAUSE_RESUME);
        if (this.logBrowser.isPaused()) {
            this.logBrowser.setPaused(false);
            item.setImage(GuiResource.getInstance().getImageRun());
        } else {
            this.logBrowser.setPaused(true);
            item.setImage(GuiResource.getInstance().getImagePause());
        }
    }

    @GuiToolbarElement(root="HopGuiWorkflowLogDelegate-ToolBar", id="ToolbarIcon-10040-LogIncreaseFont", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.IncreaseFont", image="ui/images/zoom-in.svg", separator=true)
    public void increaseFont() {
        this.textZoom.increaseFont();
    }

    @GuiToolbarElement(root="HopGuiWorkflowLogDelegate-ToolBar", id="ToolbarIcon-10050-LogDecreaseFont", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.DecreaseFont", image="ui/images/zoom-out.svg", separator=false)
    public void decreaseFont() {
        this.textZoom.decreaseFont();
    }

    @GuiToolbarElement(root="HopGuiWorkflowLogDelegate-ToolBar", id="ToolbarIcon-10060-LogResetFont", toolTip="i18n:org.apache.hop.ui.hopgui:WorkflowLog.Button.ResetFont", image="ui/images/zoom-100.svg", separator=false)
    public void resetFont() {
        this.textZoom.resetFont();
    }

    public boolean hasSelectedText() {
        if (this.workflowLogText == null || this.workflowLogText.isDisposed()) {
            return false;
        }
        return StringUtils.isNotEmpty((String)this.workflowLogText.getSelectionText());
    }

    public void copySelected() {
        if (this.hasSelectedText()) {
            this.workflowGraph.workflowClipboardDelegate.toClipboard(this.workflowLogText.getSelectionText());
        }
    }
}

