/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avroencode;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.avro.transforms.avroencode.AvroEncode;
import org.apache.hop.avro.transforms.avroencode.AvroEncodeData;
import org.apache.hop.avro.transforms.avroencode.SourceField;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaAvroRecord;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="AvroEncode", name="Avro Encode", description="Encodes Hop fields into an Avro Record typed field", image="avro_encode.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/avro-encode.html", keywords={"i18n::AvroEncodeMeta.keyword"})
public class AvroEncodeMeta
extends BaseTransformMeta<AvroEncode, AvroEncodeData> {
    private static final Class<?> PKG = AvroEncodeMeta.class;
    @HopMetadataProperty(key="output_field")
    private String outputFieldName = "avro";
    @HopMetadataProperty(key="schema_name")
    private String schemaName = "hop-schema";
    @HopMetadataProperty
    private String namespace;
    @HopMetadataProperty
    private String documentation;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<SourceField> sourceFields = new ArrayList<SourceField>();

    public void getFields(IRowMeta rowMeta, String transformName, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            Schema schema = AvroEncodeMeta.createAvroSchema(variables.resolve(this.getSchemaName()), variables.resolve(this.getNamespace()), variables.resolve(this.getDocumentation()), rowMeta, this.sourceFields);
            ValueMetaAvroRecord valueMeta = new ValueMetaAvroRecord(variables.resolve(this.outputFieldName), schema);
            rowMeta.addValueMeta((IValueMeta)valueMeta);
        }
        catch (Exception e) {
            throw new HopTransformException("Error creating Avro schema and/or determining output field layout", (Throwable)e);
        }
    }

    public static Schema createAvroSchema(String name, String namespace, String doc, IRowMeta inputRowMeta, List<SourceField> sourceFields) throws HopException {
        SchemaBuilder.RecordBuilder recordBuilder = SchemaBuilder.record((String)name);
        if (StringUtils.isNotEmpty((String)namespace)) {
            recordBuilder = (SchemaBuilder.RecordBuilder)recordBuilder.namespace(namespace);
        }
        if (StringUtils.isNotEmpty((String)doc)) {
            recordBuilder.doc(doc);
        }
        SchemaBuilder.FieldAssembler fieldAssembler = recordBuilder.fields();
        block8: for (SourceField field : sourceFields) {
            int index = inputRowMeta.indexOfValue(field.getSourceFieldName());
            if (index < 0) {
                throw new HopException("Unable to find input field " + field.getSourceFieldName());
            }
            IValueMeta valueMeta = inputRowMeta.getValueMeta(index);
            SchemaBuilder.BaseFieldTypeBuilder fieldBuilder = fieldAssembler.name(field.calculateTargetFieldName()).type().nullable();
            switch (valueMeta.getType()) {
                case 3: {
                    fieldAssembler = fieldBuilder.longType().noDefault();
                    Schema timestampMilliType = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
                    fieldAssembler = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)fieldAssembler.name(field.getTargetFieldName()).type().unionOf().nullType().and().type(timestampMilliType)).endUnion()).noDefault();
                    continue block8;
                }
                case 5: {
                    fieldAssembler = fieldBuilder.longType().noDefault();
                    continue block8;
                }
                case 1: {
                    fieldAssembler = fieldBuilder.doubleType().noDefault();
                    continue block8;
                }
                case 4: {
                    fieldAssembler = fieldBuilder.booleanType().noDefault();
                    continue block8;
                }
                case 2: 
                case 6: {
                    fieldAssembler = fieldBuilder.stringType().noDefault();
                    continue block8;
                }
                case 8: {
                    fieldAssembler = fieldBuilder.bytesType().noDefault();
                    continue block8;
                }
            }
            throw new HopException("Writing Hop data type '" + valueMeta.getTypeDesc() + "' to Parquet is not supported");
        }
        return (Schema)fieldAssembler.endRecord();
    }

    public String getOutputFieldName() {
        return this.outputFieldName;
    }

    public void setOutputFieldName(String outputFieldName) {
        this.outputFieldName = outputFieldName;
    }

    public List<SourceField> getSourceFields() {
        return this.sourceFields;
    }

    public void setSourceFields(List<SourceField> sourceFields) {
        this.sourceFields = sourceFields;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}

