/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dorisbulkloader;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hop.pipeline.transforms.dorisbulkloader.RecordBuffer;

public class RecordStream
extends InputStream {
    private final RecordBuffer recordBuffer;

    public RecordStream(int bufferSize, int bufferCount) {
        if (bufferSize == 0) {
            bufferSize = 50000;
        }
        if (bufferCount == 0) {
            bufferCount = 256;
        }
        this.recordBuffer = new RecordBuffer(bufferSize, bufferCount);
    }

    public void startInput() {
        this.recordBuffer.startBufferData();
    }

    public void write(byte[] buff) throws IOException {
        try {
            this.recordBuffer.write(buff);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public boolean canWrite(long writeLength) {
        return this.recordBuffer.canWrite(writeLength);
    }

    @Override
    public int read(byte[] buff, int start, int length) throws IOException {
        try {
            return this.recordBuffer.read(buff, start, length);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        return -1;
    }

    @Override
    public int read(byte[] buff) throws IOException {
        try {
            return this.recordBuffer.read(buff, 0, buff.length);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void endInput() throws InterruptedException {
        this.recordBuffer.stopBufferData();
    }

    public long getWriteLength() {
        return this.recordBuffer.getWriteLength();
    }

    public void clearRecordStream() throws InterruptedException {
        this.recordBuffer.clearRecordBuffer();
    }
}

