/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBOverlay;
import com.ibm.as400.access.DBStorage;
import com.ibm.as400.access.DataStreamCompression;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.Trace;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;

abstract class DBBaseRequestDS
extends ClientAccessDataStream {
    public static int SEND_HISTORY_SIZE = 10;
    private int currentOffset_;
    private int lockedLength_;
    private int operationResultBitmap_;
    private int parameterCount_;
    private boolean rleCompressed_ = false;
    private final DBStorage storage_ = DBDSPool.storagePool_.getUnusedStorage();
    private int[] sendHistory = new int[SEND_HISTORY_SIZE];
    private int sendHistoryOffset = 0;
    public static final int ORS_BITMAP_RETURN_DATA = Integer.MIN_VALUE;
    public static final int ORS_BITMAP_MESSAGE_ID = 0x40000000;
    public static final int ORS_BITMAP_FIRST_LEVEL_TEXT = 0x20000000;
    public static final int ORS_BITMAP_SECOND_LEVEL_TEXT = 0x10000000;
    public static final int ORS_BITMAP_DATA_FORMAT = 0x8000000;
    public static final int ORS_BITMAP_RESULT_DATA = 0x4000000;
    public static final int ORS_BITMAP_SQLCA = 0x2000000;
    public static final int ORS_BITMAP_SERVER_ATTRIBUTES = 0x1000000;
    public static final int ORS_BITMAP_PARAMETER_MARKER_FORMAT = 0x800000;
    public static final int ORS_BITMAP_PACKAGE_INFO = 0x100000;
    public static final int ORS_BITMAP_REQUEST_RLE_COMPRESSION = 524288;
    public static final int ORS_BITMAP_REPLY_RLE_COMPRESSION = 262144;
    public static final int ORS_BITMAP_EXTENDED_COLUMN_DESCRIPTORS = 131072;
    public static final int ORS_BITMAP_VARIABLE_LENGTH_FIELD_COMPRESSION = 65536;
    public static final int ORS_BITMAP_CURSOR_ATTRIBUTES = 32768;
    protected static final int SERVER_SQL = 57348;
    protected static final int SERVER_NDB = 57349;
    protected static final int SERVER_ROI = 57350;
    private static final int RLE_THRESHOLD_ = 1064;

    protected DBBaseRequestDS(int requestId, int rpbId, int operationResultBitmap, int parameterMarkerDescriptorHandle) {
        this.initialize(requestId, rpbId, operationResultBitmap, parameterMarkerDescriptorHandle);
    }

    void initialize(int requestId, int rpbId, int operationResultBitmap, int parameterMarkerDescriptorHandle) {
        this.data_ = this.storage_.getData();
        this.currentOffset_ = 40;
        this.parameterCount_ = 0;
        this.operationResultBitmap_ = operationResultBitmap;
        this.rleCompressed_ = false;
        this.lockedLength_ = 0;
        this.setHeaderID(0);
        this.setCSInstance(0);
        this.setTemplateLen(20);
        this.setReqRepID(requestId);
        this.set32bit(operationResultBitmap, 20);
        this.set16bit(rpbId, 28);
        this.set16bit(rpbId, 30);
        this.setBasedOnORSHandle(0);
        this.set16bit(rpbId, 34);
        this.setParameterMarkerDescriptorHandle(parameterMarkerDescriptorHandle);
    }

    public void addOperationResultBitmap(int value) {
        this.operationResultBitmap_ |= value;
        this.set32bit(this.operationResultBitmap_, 20);
    }

    protected void addParameter(int codePoint, byte value) throws DBDataStreamException {
        this.lock(1, codePoint);
        this.data_[this.currentOffset_] = value;
        this.unlock();
    }

    protected void addParameter(int codePoint, short value) throws DBDataStreamException {
        this.lock(2, codePoint);
        this.set16bit(value, this.currentOffset_);
        this.unlock();
    }

    protected void addParameter(int codePoint, short value, int extra) throws DBDataStreamException {
        this.lock(6, codePoint);
        this.set16bit(value, this.currentOffset_);
        this.set32bit(extra, this.currentOffset_ + 2);
        this.unlock();
    }

    protected void addParameter(int codePoint, int value) throws DBDataStreamException {
        this.lock(4, codePoint);
        this.set32bit(value, this.currentOffset_);
        this.unlock();
    }

    protected void addParameter(int codePoint, byte[] value) throws DBDataStreamException {
        if (value == null) {
            this.lock(0, codePoint);
            this.unlock();
            if (Trace.traceOn_) {
                Trace.log(1, "Value is null, sending only length and codepoint.");
            }
        } else {
            this.addParameter(codePoint, value, 0, value.length);
        }
    }

    protected void addParameter(int codePoint, byte[] value, int offset, int length) throws DBDataStreamException {
        this.lock(length, codePoint);
        System.arraycopy(value, offset, this.data_, this.currentOffset_, length);
        this.unlock();
    }

    protected void addParameter(int codePoint, byte[] value, boolean overloadThisMethod) throws DBDataStreamException {
        this.addParameter(codePoint, value, 0, value.length, overloadThisMethod);
    }

    protected void addParameter(int codePoint, byte[] value, int offset, int length, boolean overloadThisMethod) throws DBDataStreamException {
        this.lock(value.length + 6, codePoint);
        this.set16bit(-1, this.currentOffset_);
        this.set32bit(length, this.currentOffset_ + 2);
        System.arraycopy(value, offset, this.data_, this.currentOffset_ + 6, length);
        this.unlock();
    }

    protected void addParameter(int codePoint, String value) throws DBDataStreamException {
        char[] asChars = value.toCharArray();
        this.lock(asChars.length + 2, codePoint);
        this.set16bit(37, this.currentOffset_);
        int offset = this.currentOffset_ + 2;
        int i = 0;
        while (i < asChars.length) {
            this.data_[offset] = asChars[i] == ' ' ? 64 : (byte)(asChars[i] | 0xF0);
            ++i;
            ++offset;
        }
        this.unlock();
    }

    protected void addParameter(int codePoint, ConvTable converter, String value, int valueLength) throws DBDataStreamException {
        this.lock(valueLength + 2, codePoint);
        this.set16bit(converter.ccsid_, this.currentOffset_);
        try {
            converter.stringToByteArray(value.substring(0, valueLength), this.data_, this.currentOffset_ + 2);
        }
        catch (CharConversionException e) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int codePoint, ConvTable converter, String value) throws DBDataStreamException, SQLException {
        byte[] rawBytes = converter.stringToByteArray(value);
        if (rawBytes.length > 65535) {
            JDError.throwSQLException("54001");
        }
        this.lock(rawBytes.length + 4, codePoint);
        this.set16bit(converter.ccsid_, this.currentOffset_);
        this.set16bit(rawBytes.length, this.currentOffset_ + 2);
        try {
            System.arraycopy(rawBytes, 0, this.data_, this.currentOffset_ + 4, rawBytes.length);
        }
        catch (Exception e) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int codePoint, boolean v5r4, ConvTable converter, String value) throws DBDataStreamException, SQLException {
        byte[] rawBytes = converter.stringToByteArray(value);
        if (rawBytes.length > 0x200000) {
            JDError.throwSQLException("54001");
        }
        this.lock(rawBytes.length + 6, codePoint);
        this.set16bit(converter.ccsid_, this.currentOffset_);
        this.set32bit(rawBytes.length, this.currentOffset_ + 2);
        try {
            System.arraycopy(rawBytes, 0, this.data_, this.currentOffset_ + 6, rawBytes.length);
        }
        catch (Exception e) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int codePoint, ConvTable converter, String value, boolean fixed) throws DBDataStreamException, SQLException {
        if (fixed) {
            byte[] rawBytes = converter.stringToByteArray(value);
            if (rawBytes.length > 65535) {
                JDError.throwSQLException("54001");
            }
            this.lock(rawBytes.length + 4, codePoint);
            this.set16bit(converter.ccsid_, this.currentOffset_);
            try {
                System.arraycopy(rawBytes, 0, this.data_, this.currentOffset_ + 2, rawBytes.length);
            }
            catch (Exception e) {
                throw new DBDataStreamException();
            }
            this.unlock();
        } else {
            this.addParameter(codePoint, converter, value);
        }
    }

    protected void addParameter(int codePoint) throws DBDataStreamException {
        this.lock(0, codePoint);
        this.unlock();
    }

    protected void addParameter(int codePoint, ConvTable converter, char[] indicators, String[] libraries) throws DBDataStreamException {
        int parameterLength = 4;
        for (int i = 0; i < libraries.length; ++i) {
            parameterLength += 3 + libraries[i].length();
        }
        this.lock(parameterLength, codePoint);
        this.set16bit(converter.ccsid_, this.currentOffset_);
        this.set16bit(libraries.length, this.currentOffset_ + 2);
        int offset = 4;
        try {
            for (int i = 0; i < libraries.length; ++i) {
                Character ch = Character.valueOf(indicators[i]);
                converter.stringToByteArray(ch.toString(), this.data_, this.currentOffset_ + offset);
                this.set16bit(libraries[i].length(), this.currentOffset_ + offset + 1);
                converter.stringToByteArray(libraries[i], this.data_, this.currentOffset_ + offset + 3);
                offset += 3 + libraries[i].length();
            }
        }
        catch (CharConversionException e) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int codePoint, ConvTable converter, int type, String tableFile, String tableLibrary, String languageId) throws DBDataStreamException {
        int parameterLength;
        switch (type) {
            default: {
                parameterLength = 2;
                break;
            }
            case 1: 
            case 2: {
                parameterLength = 7;
                break;
            }
            case 3: {
                parameterLength = 8 + tableFile.length() + tableLibrary.length();
            }
        }
        this.lock(parameterLength, codePoint);
        this.set16bit(type, this.currentOffset_);
        try {
            switch (type) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    this.set16bit(converter.ccsid_, this.currentOffset_ + 2);
                    converter.stringToByteArray(languageId, this.data_, this.currentOffset_ + 4);
                    break;
                }
                case 3: {
                    this.set16bit(converter.ccsid_, this.currentOffset_ + 2);
                    this.set16bit(tableFile.length(), this.currentOffset_ + 4);
                    converter.stringToByteArray(tableFile, this.data_, this.currentOffset_ + 6);
                    this.set16bit(tableLibrary.length(), this.currentOffset_ + 6 + tableFile.length());
                    converter.stringToByteArray(tableLibrary, this.data_, this.currentOffset_ + 8 + tableFile.length());
                    break;
                }
            }
        }
        catch (CharConversionException e) {
            throw new DBDataStreamException();
        }
        this.unlock();
    }

    protected void addParameter(int codePoint, DBOverlay value) throws DBDataStreamException {
        this.lock(value.getLength(), codePoint);
        value.overlay(this.data_, this.currentOffset_);
        this.unlock();
    }

    protected int addParameterReserve(int codePoint, DBOverlay value) throws DBDataStreamException {
        int offset = this.lockReserve(value.getLength(), codePoint);
        value.overlay(this.data_, this.currentOffset_);
        this.unlock();
        return offset;
    }

    public void clearOperationResultBitmap(int value) {
        if ((this.operationResultBitmap_ & value) != 0) {
            this.operationResultBitmap_ ^= value;
            this.set32bit(this.operationResultBitmap_, 20);
        }
    }

    public void compress() {
        this.rleCompressed_ = true;
    }

    void dump(PrintStream ps) {
        DBBaseRequestDS.dump(ps, this.data_, this.currentOffset_);
        if (this.rleCompressed_) {
            ps.println("Request was sent RLE compressed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dump(PrintStream ps, byte[] data, int length) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            int i;
            StringBuffer hexBuffer = new StringBuffer();
            StringBuffer charBuffer = new StringBuffer();
            for (i = 0; i < length; ++i) {
                short ascii;
                String temp = "00" + Integer.toHexString(data[i]);
                String hex = temp.substring(temp.length() - 2);
                hexBuffer.append(hex.toUpperCase());
                if (i % 4 == 3) {
                    hexBuffer.append(" ");
                }
                int ch = (ascii = (short)(data[i] >= 0 ? data[i] : 256 + data[i])) >= 129 && ascii <= 137 ? (int)(97 + ascii - 129) : (ascii >= 145 && ascii <= 153 ? (int)(106 + ascii - 145) : (ascii >= 162 && ascii <= 169 ? (int)(115 + ascii - 162) : (ascii >= 193 && ascii <= 201 ? (int)(65 + ascii - 193) : (ascii >= 209 && ascii <= 217 ? (int)(74 + ascii - 209) : (ascii >= 226 && ascii <= 233 ? (int)(83 + ascii - 226) : (ascii >= 240 && ascii <= 249 ? (int)((char)(48 + ascii - 240)) : (data[i] == 64 ? 32 : (data[i] >= 32 && data[i] <= 126 ? (int)((char)data[i]) : 46))))))));
                charBuffer.append((char)ch);
                if (i % 16 != 15) continue;
                ps.println(hexBuffer + "  [" + charBuffer + "]");
                hexBuffer = new StringBuffer();
                charBuffer = new StringBuffer();
            }
            if (i % 16 != 0) {
                int hexBufferLength;
                for (int j = hexBufferLength = hexBuffer.length(); j <= 35; ++j) {
                    hexBuffer.append(" ");
                }
                ps.println(hexBuffer + "  [" + charBuffer + "]");
            }
        }
    }

    public int getOperationResultBitmap() {
        return this.operationResultBitmap_;
    }

    protected void finalize() throws Throwable {
        if (this.storage_ != null) {
            this.storage_.returnToPool();
        }
        this.data_ = null;
        super.finalize();
    }

    private void lock(int length, int codePoint) throws DBDataStreamException {
        if (this.storage_.checkSize(this.currentOffset_ + length + 6)) {
            this.data_ = this.storage_.getData();
        }
        this.lockedLength_ = length;
        this.set32bit(length + 6, this.currentOffset_);
        this.set16bit(codePoint, this.currentOffset_ + 4);
        this.currentOffset_ += 6;
    }

    private int lockReserve(int length, int codePoint) throws DBDataStreamException {
        if (this.storage_.checkSize(this.currentOffset_ + length + 6)) {
            this.data_ = this.storage_.getData();
        }
        this.lockedLength_ = length;
        int lengthOffset = this.currentOffset_;
        this.set32bit(length + 6, this.currentOffset_);
        this.set16bit(codePoint, this.currentOffset_ + 4);
        this.currentOffset_ += 6;
        return lengthOffset;
    }

    public void updateLength(int offset, int length) {
        this.set32bit(length + 6, offset);
        this.currentOffset_ = this.currentOffset_ - this.lockedLength_ + length;
    }

    public void setBasedOnORSHandle(int value) {
        this.set16bit(value, 32);
    }

    private void unlock() {
        this.currentOffset_ += this.lockedLength_;
        ++this.parameterCount_;
    }

    public void setParameterMarkerDescriptorHandle(int value) {
        this.set16bit(value, 36);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    void write(OutputStream out) throws IOException {
        this.sendHistory[this.sendHistoryOffset] = this.currentOffset_;
        this.sendHistoryOffset = (this.sendHistoryOffset + 1) % DBBaseRequestDS.SEND_HISTORY_SIZE;
        this.setLength(this.currentOffset_);
        this.set16bit(this.parameterCount_, 38);
        if (this.rleCompressed_) {
            if (this.currentOffset_ > 1064) {
                secondaryStorage = DBDSPool.storagePool_.getUnusedStorage();
                try {
                    secondaryStorage.checkSize(this.currentOffset_);
                    compressedBytes = secondaryStorage.getData();
                    dataLength = this.currentOffset_ - 40;
                    compressedSize = DataStreamCompression.compressRLE(this.data_, 40, dataLength, compressedBytes, 50, (byte)27);
                    if (compressedSize > 0) {
                        useCompression = true;
                        savingsLength = dataLength - compressedSize;
                        savingsPercentage = 100L * (long)savingsLength / (long)dataLength;
                        if (savingsPercentage < 10L || savingsLength < 512) {
                            useCompression = false;
                        }
                    } else {
                        useCompression = false;
                    }
                    if (useCompression) {
                        compressedSizeWithHeader = compressedSize + 50;
                        BinaryConverter.intToByteArray(compressedSizeWithHeader, compressedBytes, 0);
                        System.arraycopy(this.data_, 4, compressedBytes, 4, 36);
                        BinaryConverter.intToByteArray(compressedSize + 10, compressedBytes, 40);
                        BinaryConverter.shortToByteArray((short)14386, compressedBytes, 44);
                        BinaryConverter.intToByteArray(dataLength, compressedBytes, 46);
                        var8_9 = out;
                        synchronized (var8_9) {
                            out.write(compressedBytes, 0, compressedSizeWithHeader);
                            out.flush();
                        }
                        if (!Trace.traceOn_) ** GOTO lbl47
                        Trace.log(0, "Data stream sent (connID=" + this.connectionID_ + ") ...", compressedBytes, 0, compressedSizeWithHeader);
                    }
                    this.rleCompressed_ = false;
                }
                finally {
                    secondaryStorage.returnToPool();
                    secondaryStorage = null;
                }
            } else {
                this.rleCompressed_ = false;
            }
        }
lbl47:
        // 6 sources

        if (!this.rleCompressed_) {
            this.clearOperationResultBitmap(524288);
            var2_2 = out;
            synchronized (var2_2) {
                out.write(this.data_, 0, this.currentOffset_);
                out.flush();
            }
            if (Trace.traceOn_ && !(out instanceof ByteArrayOutputStream)) {
                Trace.log(0, "Data stream sent (connID=" + this.connectionID_ + ") ...", this.data_, 0, this.currentOffset_);
            }
        }
    }

    @Override
    synchronized void returnToPool() {
        int length = 1024;
        for (int i = 0; i < SEND_HISTORY_SIZE; ++i) {
            if (this.sendHistory[i] <= length) continue;
            length = this.sendHistory[i];
        }
        this.storage_.reclaim(length);
        this.data_ = null;
        super.returnToPool();
    }

    void reclaim() {
        int defaultSize = 1024;
        for (int i = 0; i < SEND_HISTORY_SIZE; ++i) {
            this.sendHistory[i] = defaultSize;
        }
        this.storage_.reclaim(defaultSize);
        this.data_ = null;
    }
}

