/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.RowMutationInformation;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.io.gcp.bigquery.providers.BigQueryWriteConfiguration;
import org.apache.beam.sdk.io.gcp.bigquery.providers.PortableBigQueryDestinations;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoService(value={SchemaTransformProvider.class})
public class BigQueryStorageWriteApiSchemaTransformProvider
extends TypedSchemaTransformProvider<BigQueryWriteConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized Integer DEFAULT_TRIGGER_FREQUENCY_SECS = 5;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_TRIGGERING_FREQUENCY = Duration.standardSeconds((long)DEFAULT_TRIGGER_FREQUENCY_SECS.intValue());
    private static final @UnknownKeyFor @NonNull @Initialized String INPUT_ROWS_TAG = "input";
    private static final @UnknownKeyFor @NonNull @Initialized String FAILED_ROWS_TAG = "FailedRows";
    private static final @UnknownKeyFor @NonNull @Initialized String FAILED_ROWS_WITH_ERRORS_TAG = "FailedRowsWithErrors";
    protected static final @UnknownKeyFor @NonNull @Initialized String DYNAMIC_DESTINATIONS = "DYNAMIC_DESTINATIONS";
    protected static final @UnknownKeyFor @NonNull @Initialized String ROW_PROPERTY_MUTATION_INFO = "row_mutation_info";
    protected static final @UnknownKeyFor @NonNull @Initialized String ROW_PROPERTY_MUTATION_TYPE = "mutation_type";
    protected static final @UnknownKeyFor @NonNull @Initialized String ROW_PROPERTY_MUTATION_SQN = "change_sequence_number";
    protected static final @UnknownKeyFor @NonNull @Initialized Schema ROW_SCHEMA_MUTATION_INFO = Schema.builder().addStringField("mutation_type").addStringField("change_sequence_number").build();

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration) {
        return new BigQueryStorageWriteApiSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:bigquery_storage_write:v2";
    }

    public @UnknownKeyFor @NonNull @Initialized String description() {
        return String.format("Writes data to BigQuery using the Storage Write API (https://cloud.google.com/bigquery/docs/write-api).\n\nThis expects a single PCollection of Beam Rows and outputs two dead-letter queues (DLQ) that contain failed rows. The first DLQ has tag [%s] and contains the failed rows. The second DLQ has tag [%s] and contains failed rows and along with their respective errors.", FAILED_ROWS_TAG, FAILED_ROWS_WITH_ERRORS_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_ROWS_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Arrays.asList(FAILED_ROWS_TAG, FAILED_ROWS_WITH_ERRORS_TAG, "errors");
    }

    public static class BigQueryStorageWriteApiSchemaTransform
    extends SchemaTransform {
        private @UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices = null;
        private final @UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration;

        BigQueryStorageWriteApiSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        @VisibleForTesting
        public void setBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices) {
            this.testBigQueryServices = testBigQueryServices;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            PCollection inputRows = input.getSinglePCollection();
            BigQueryIO.Write<Row> write = this.createStorageWriteApiTransform(inputRows.getSchema());
            if (inputRows.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                boolean useAtLeastOnceSemantics;
                Long triggeringFrequency = this.configuration.getTriggeringFrequencySeconds();
                Boolean autoSharding = this.configuration.getAutoSharding();
                int numStreams = this.configuration.getNumStreams() == null ? 0 : this.configuration.getNumStreams();
                boolean bl = useAtLeastOnceSemantics = this.configuration.getUseAtLeastOnceSemantics() != null && this.configuration.getUseAtLeastOnceSemantics() != false;
                if (!useAtLeastOnceSemantics) {
                    write = write.withTriggeringFrequency(triggeringFrequency == null || triggeringFrequency <= 0L ? DEFAULT_TRIGGERING_FREQUENCY : Duration.standardSeconds((long)triggeringFrequency));
                }
                if (numStreams > 0) {
                    write = write.withNumStorageWriteApiStreams(numStreams);
                } else if (autoSharding == null || autoSharding.booleanValue()) {
                    write = write.withAutoSharding();
                }
            }
            Schema inputSchema = inputRows.getSchema();
            WriteResult result = (WriteResult)((PCollection)inputRows.apply("element-count", (PTransform)ParDo.of(new ElementCounterFn("BigQuery-write-element-counter")))).setRowSchema(inputSchema).apply(write);
            PCollection postWrite = ((PCollection)result.getFailedStorageApiInserts().apply("post-write", (PTransform)ParDo.of(new NoOutputDoFn()))).setRowSchema(Schema.of((Schema.Field[])new Schema.Field[0]));
            if (this.configuration.getErrorHandling() == null) {
                result.getFailedStorageApiInserts().apply("Error on failed inserts", (PTransform)ParDo.of((DoFn)new FailOnError()));
                return PCollectionRowTuple.of((String)"post_write", (PCollection)postWrite);
            }
            result.getFailedStorageApiInserts().apply("error-count", (PTransform)ParDo.of(new ElementCounterFn("BigQuery-write-error-counter")));
            Schema errorSchema = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"failed_row", (Schema.FieldType)Schema.FieldType.row((Schema)inputSchema)), Schema.Field.of((String)"error_message", (Schema.FieldType)Schema.FieldType.STRING)});
            PCollection failedRowsWithErrors = ((PCollection)result.getFailedStorageApiInserts().apply("Construct failed rows and errors", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)storageError -> Row.withSchema((Schema)errorSchema).withFieldValue("error_message", (Object)storageError.getErrorMessage()).withFieldValue("failed_row", (Object)BigQueryUtils.toBeamRow(inputSchema, storageError.getRow())).build()))).setRowSchema(errorSchema);
            return PCollectionRowTuple.of((String)"post_write", (PCollection)postWrite).and(this.configuration.getErrorHandling().getOutput(), failedRowsWithErrors);
        }

        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write<@UnknownKeyFor @NonNull @Initialized Row> createStorageWriteApiTransform(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            BigQueryIO.Write.Method writeMethod = this.configuration.getUseAtLeastOnceSemantics() != null && this.configuration.getUseAtLeastOnceSemantics() != false ? BigQueryIO.Write.Method.STORAGE_API_AT_LEAST_ONCE : BigQueryIO.Write.Method.STORAGE_WRITE_API;
            BigQueryIO.Write<Object> write = BigQueryIO.write().withMethod(writeMethod).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND);
            Schema rowSchema = schema;
            boolean fetchNestedRecord = false;
            if (this.configuration.getTable().equals(BigQueryStorageWriteApiSchemaTransformProvider.DYNAMIC_DESTINATIONS)) {
                this.validateDynamicDestinationsSchema(schema);
                rowSchema = schema.getField("record").getType().getRowSchema();
                fetchNestedRecord = true;
            }
            if (Boolean.TRUE.equals(this.configuration.getUseCdcWrites())) {
                this.validateCdcSchema(schema);
                rowSchema = schema.getField("record").getType().getRowSchema();
                fetchNestedRecord = true;
                write = write.withPrimaryKey(this.configuration.getPrimaryKey()).withRowMutationInformationFn((SerializableFunction & Serializable)row -> RowMutationInformation.of(RowMutationInformation.MutationType.valueOf(row.getRow(BigQueryStorageWriteApiSchemaTransformProvider.ROW_PROPERTY_MUTATION_INFO).getString(BigQueryStorageWriteApiSchemaTransformProvider.ROW_PROPERTY_MUTATION_TYPE)), row.getRow(BigQueryStorageWriteApiSchemaTransformProvider.ROW_PROPERTY_MUTATION_INFO).getString(BigQueryStorageWriteApiSchemaTransformProvider.ROW_PROPERTY_MUTATION_SQN)));
            }
            PortableBigQueryDestinations dynamicDestinations = new PortableBigQueryDestinations(rowSchema, this.configuration);
            write = write.to(dynamicDestinations).withFormatFunction(dynamicDestinations.getFilterFormatFunction(fetchNestedRecord));
            if (!Strings.isNullOrEmpty((String)this.configuration.getCreateDisposition())) {
                BigQueryIO.Write.CreateDisposition createDisposition = BigQueryIO.Write.CreateDisposition.valueOf(this.configuration.getCreateDisposition().toUpperCase());
                write = write.withCreateDisposition(createDisposition);
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getWriteDisposition())) {
                BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryIO.Write.WriteDisposition.valueOf(this.configuration.getWriteDisposition().toUpperCase());
                write = write.withWriteDisposition(writeDisposition);
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getKmsKey())) {
                write = write.withKmsKey(this.configuration.getKmsKey());
            }
            if (this.testBigQueryServices != null) {
                write = write.withTestServices(this.testBigQueryServices);
            }
            return write;
        }

        void validateDynamicDestinationsSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            Preconditions.checkArgument((boolean)schema.getFieldNames().containsAll(Arrays.asList("destination", "record")), (Object)String.format("When writing to dynamic destinations, we expect Row Schema with a \"%s\" string field and a \"%s\" Row field.", "destination", "record"));
        }

        private void validateCdcSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            Preconditions.checkArgument((boolean)schema.getFieldNames().containsAll(Arrays.asList(BigQueryStorageWriteApiSchemaTransformProvider.ROW_PROPERTY_MUTATION_INFO, "record")), (Object)"When writing using CDC functionality, we expect Row Schema with a \"row_mutation_info\" Row field and a \"record\" Row field.");
            Schema mutationSchema = schema.getField(BigQueryStorageWriteApiSchemaTransformProvider.ROW_PROPERTY_MUTATION_INFO).getType().getRowSchema();
            Preconditions.checkArgument((mutationSchema != null && mutationSchema.equals((Object)ROW_SCHEMA_MUTATION_INFO) ? 1 : 0) != 0, (Object)("When writing using CDC functionality, we expect a \"row_mutation_info\" field of Row type with schema:\n" + ROW_SCHEMA_MUTATION_INFO.toString() + "\nReceived \"" + BigQueryStorageWriteApiSchemaTransformProvider.ROW_PROPERTY_MUTATION_INFO + "\" field with schema:\n" + mutationSchema));
        }

        private static class NoOutputDoFn<@UnknownKeyFor T>
        extends DoFn<T, Row> {
            private NoOutputDoFn() {
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            }
        }

        private static class FailOnError
        extends DoFn<BigQueryStorageApiInsertError, Void> {
            private FailOnError() {
            }

            @DoFn.ProcessElement
            public void process(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                throw new RuntimeException(((BigQueryStorageApiInsertError)c.element()).getErrorMessage());
            }
        }

        private static class ElementCounterFn<@UnknownKeyFor T>
        extends DoFn<T, T> {
            private @UnknownKeyFor @NonNull @Initialized Counter bqGenericElementCounter;
            private @UnknownKeyFor @NonNull @Initialized Long elementsInBundle = 0L;

            ElementCounterFn(@UnknownKeyFor @NonNull @Initialized String name) {
                this.bqGenericElementCounter = Metrics.counter(BigQueryStorageWriteApiSchemaTransform.class, (String)name);
            }

            @DoFn.ProcessElement
            public void process(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                this.elementsInBundle = this.elementsInBundle + 1L;
                c.output(c.element());
            }

            @DoFn.FinishBundle
            public void finish(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
                this.bqGenericElementCounter.inc(this.elementsInBundle.longValue());
                this.elementsInBundle = 0L;
            }
        }
    }
}

