/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.zip.ZipFileSystem;

public class ZipFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String PREFIX = ZipFileSystemConfigBuilder.class.getName();
    private static final ZipFileSystemConfigBuilder INSTANCE = new ZipFileSystemConfigBuilder();
    private static final String KEY_CHARSET = PREFIX + ".charset";

    public static final ZipFileSystemConfigBuilder getInstance() {
        return INSTANCE;
    }

    private ZipFileSystemConfigBuilder() {
        super("zip.");
    }

    public Charset getCharset(FileSystemOptions fileSystemOptions) {
        return this.getParamOrDefault(fileSystemOptions, KEY_CHARSET, StandardCharsets.UTF_8);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return ZipFileSystem.class;
    }

    public void setCharset(FileSystemOptions fileSystemOptions, Charset charset) {
        this.setParam(fileSystemOptions, KEY_CHARSET, charset);
    }
}

