/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.util.function.LongPredicate;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;

public abstract class PurgeFunction
extends Transformation<UnfilteredRowIterator> {
    private final DeletionPurger purger;
    private final int nowInSec;
    private final boolean enforceStrictLiveness;
    private boolean isReverseOrder;

    public PurgeFunction(int nowInSec, int gcBefore, int oldestUnrepairedTombstone, boolean onlyPurgeRepairedTombstones, boolean enforceStrictLiveness) {
        this.nowInSec = nowInSec;
        this.purger = (timestamp, localDeletionTime) -> (!onlyPurgeRepairedTombstones || localDeletionTime < oldestUnrepairedTombstone) && localDeletionTime < gcBefore && this.getPurgeEvaluator().test(timestamp);
        this.enforceStrictLiveness = enforceStrictLiveness;
    }

    protected abstract LongPredicate getPurgeEvaluator();

    protected void onNewPartition(DecoratedKey partitionKey) {
    }

    protected void onEmptyPartitionPostPurge(DecoratedKey partitionKey) {
    }

    protected void updateProgress() {
    }

    protected void setReverseOrder(boolean isReverseOrder) {
        this.isReverseOrder = isReverseOrder;
    }

    @Override
    protected UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
        this.onNewPartition(partition.partitionKey());
        this.setReverseOrder(partition.isReverseOrder());
        UnfilteredRowIterator purged = Transformation.apply(partition, this);
        if (purged.isEmpty()) {
            this.onEmptyPartitionPostPurge(purged.partitionKey());
            purged.close();
            return null;
        }
        return purged;
    }

    @Override
    protected DeletionTime applyToDeletion(DeletionTime deletionTime) {
        return this.purger.shouldPurge(deletionTime) ? DeletionTime.LIVE : deletionTime;
    }

    @Override
    protected Row applyToStatic(Row row) {
        this.updateProgress();
        return row.purge(this.purger, this.nowInSec, this.enforceStrictLiveness);
    }

    @Override
    protected Row applyToRow(Row row) {
        this.updateProgress();
        return row.purge(this.purger, this.nowInSec, this.enforceStrictLiveness);
    }

    @Override
    protected RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
        this.updateProgress();
        boolean reversed = this.isReverseOrder;
        if (marker.isBoundary()) {
            RangeTombstoneBoundaryMarker boundary = (RangeTombstoneBoundaryMarker)marker;
            boolean shouldPurgeClose = this.purger.shouldPurge(boundary.closeDeletionTime(reversed));
            boolean shouldPurgeOpen = this.purger.shouldPurge(boundary.openDeletionTime(reversed));
            if (shouldPurgeClose) {
                if (shouldPurgeOpen) {
                    return null;
                }
                return boundary.createCorrespondingOpenMarker(reversed);
            }
            return shouldPurgeOpen ? boundary.createCorrespondingCloseMarker(reversed) : marker;
        }
        return this.purger.shouldPurge(((RangeTombstoneBoundMarker)marker).deletionTime()) ? null : marker;
    }
}

