/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.blockuntiltransformsfinish;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.blockuntiltransformsfinish.BlockUntilTransformsFinishMeta;
import org.apache.hop.pipeline.transforms.blockuntiltransformsfinish.BlockingTransform;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BlockUntilTransformsFinishDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = BlockUntilTransformsFinishMeta.class;
    private String[] previousTransforms;
    private final BlockUntilTransformsFinishMeta input;
    private TableView wFields;

    public BlockUntilTransformsFinishDialog(Shell parent, IVariables variables, BlockUntilTransformsFinishMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BlockUntilTransformsFinishDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"BlockUntilTransformsFinishDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.setTransformNames();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"BlockUntilTransformsFinishDialog.getTransforms.Label", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"BlockUntilTransformsFinishDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsCols = 2;
        int FieldsRows = this.input.getBlockingTransforms().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"BlockUntilTransformsFinishDialog.Fieldname.transform", (String[])new String[0]), 2, this.previousTransforms, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BlockUntilTransformsFinishDialog.Fieldname.CopyNr", (String[])new String[0]), 1, false)};
        colinf[1].setUsingVariables(true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.wGet.addListener(13, e -> this.get());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setTransformNames() {
        this.previousTransforms = this.pipelineMeta.getTransformNames();
        List<String> nextTransforms = this.getNextTransforms(new ArrayList<String>(), this.transformMeta);
        ArrayList<String> entries = new ArrayList<String>();
        for (String previousTransform : this.previousTransforms) {
            if (previousTransform.equals(this.transformName) || nextTransforms == null || nextTransforms.isEmpty()) continue;
            boolean found = false;
            for (String nextTransform : nextTransforms) {
                if (!nextTransform.equals(previousTransform)) continue;
                found = true;
            }
            if (found) continue;
            entries.add(previousTransform);
        }
        this.previousTransforms = entries.toArray(new String[0]);
    }

    private List<String> getNextTransforms(List<String> transformNames, TransformMeta transformMeta) {
        List nextTransformMeta = this.pipelineMeta.findNextTransforms(transformMeta);
        for (TransformMeta nextTransform : nextTransformMeta) {
            transformNames.add(nextTransform.getName());
            this.getNextTransforms(transformNames, nextTransform);
        }
        return transformNames.stream().distinct().toList();
    }

    private void get() {
        this.wFields.removeAll();
        Table table = this.wFields.table;
        for (int i = 0; i < this.previousTransforms.length; ++i) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, this.previousTransforms[i]);
            ti.setText(2, "0");
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    public void getData() {
        Table table = this.wFields.table;
        if (!this.input.getBlockingTransforms().isEmpty()) {
            table.removeAll();
        }
        for (int i = 0; i < this.input.getBlockingTransforms().size(); ++i) {
            BlockingTransform blockingTransform = this.input.getBlockingTransforms().get(i);
            TableItem ti = new TableItem(table, 0);
            ti.setText(1, Const.NVL((String)blockingTransform.getName(), (String)""));
            ti.setText(2, Const.NVL((String)blockingTransform.getCopyNr(), (String)""));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.getBlockingTransforms().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            String name = item.getText(1);
            String copyNr = item.getText(2);
            this.input.getBlockingTransforms().add(new BlockingTransform(name, copyNr));
        }
        this.dispose();
    }
}

