/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.IndicativeSentencesGeneration;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.STABLE, since="5.7")
public interface DisplayNameGenerator {
    @API(status=API.Status.STABLE, since="5.9")
    public static final String DEFAULT_GENERATOR_PROPERTY_NAME = "junit.jupiter.displayname.generator.default";

    public String generateDisplayNameForClass(Class<?> var1);

    @API(status=API.Status.DEPRECATED, since="5.12")
    @Deprecated
    default public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
        throw new UnsupportedOperationException("Implement generateDisplayNameForNestedClass(List<Class<?>>, Class<?>) instead");
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.12")
    default public String generateDisplayNameForNestedClass(List<Class<?>> enclosingInstanceTypes, Class<?> nestedClass) {
        return this.generateDisplayNameForNestedClass(nestedClass);
    }

    @API(status=API.Status.DEPRECATED, since="5.12")
    @Deprecated
    default public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
        throw new UnsupportedOperationException("Implement generateDisplayNameForMethod(List<Class<?>>, Class<?>, Method) instead");
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.12")
    default public String generateDisplayNameForMethod(List<Class<?>> enclosingInstanceTypes, Class<?> testClass, Method testMethod) {
        return this.generateDisplayNameForMethod(testClass, testMethod);
    }

    public static String parameterTypesAsString(Method method) {
        Preconditions.notNull((Object)method, (String)"Method must not be null");
        return '(' + ClassUtils.nullSafeToString(Class::getSimpleName, (Class[])method.getParameterTypes()) + ')';
    }

    public static DisplayNameGenerator getDisplayNameGenerator(Class<?> generatorClass) {
        Preconditions.notNull(generatorClass, (String)"Class must not be null");
        Preconditions.condition((boolean)DisplayNameGenerator.class.isAssignableFrom(generatorClass), (String)"Class must be a DisplayNameGenerator implementation");
        if (generatorClass == Standard.class) {
            return Standard.INSTANCE;
        }
        if (generatorClass == Simple.class) {
            return Simple.INSTANCE;
        }
        if (generatorClass == ReplaceUnderscores.class) {
            return ReplaceUnderscores.INSTANCE;
        }
        if (generatorClass == IndicativeSentences.class) {
            return IndicativeSentences.INSTANCE;
        }
        return (DisplayNameGenerator)ReflectionSupport.newInstance(generatorClass, (Object[])new Object[0]);
    }

    public static class Standard
    implements DisplayNameGenerator {
        static final DisplayNameGenerator INSTANCE = new Standard();

        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            String name = testClass.getName();
            int lastDot = name.lastIndexOf(46);
            return name.substring(lastDot + 1);
        }

        @Override
        public String generateDisplayNameForNestedClass(List<Class<?>> enclosingInstanceTypes, Class<?> nestedClass) {
            return nestedClass.getSimpleName();
        }

        @Override
        public String generateDisplayNameForMethod(List<Class<?>> enclosingInstanceTypes, Class<?> testClass, Method testMethod) {
            return testMethod.getName() + DisplayNameGenerator.parameterTypesAsString(testMethod);
        }
    }

    public static class Simple
    extends Standard {
        static final DisplayNameGenerator INSTANCE = new Simple();

        @Override
        public String generateDisplayNameForMethod(List<Class<?>> enclosingInstanceTypes, Class<?> testClass, Method testMethod) {
            String displayName = testMethod.getName();
            if (Simple.hasParameters(testMethod)) {
                displayName = displayName + ' ' + DisplayNameGenerator.parameterTypesAsString(testMethod);
            }
            return displayName;
        }

        private static boolean hasParameters(Method method) {
            return method.getParameterCount() > 0;
        }
    }

    public static class ReplaceUnderscores
    extends Simple {
        static final DisplayNameGenerator INSTANCE = new ReplaceUnderscores();

        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForClass(testClass));
        }

        @Override
        public String generateDisplayNameForNestedClass(List<Class<?>> enclosingInstanceTypes, Class<?> nestedClass) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForNestedClass(enclosingInstanceTypes, nestedClass));
        }

        @Override
        public String generateDisplayNameForMethod(List<Class<?>> enclosingInstanceTypes, Class<?> testClass, Method testMethod) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForMethod(enclosingInstanceTypes, testClass, testMethod));
        }

        private static String replaceUnderscores(String name) {
            return name.replace('_', ' ');
        }
    }

    @API(status=API.Status.STABLE, since="5.10")
    public static class IndicativeSentences
    implements DisplayNameGenerator {
        static final DisplayNameGenerator INSTANCE = new IndicativeSentences();

        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            return IndicativeSentences.getGeneratorFor(testClass, Collections.emptyList()).generateDisplayNameForClass(testClass);
        }

        @Override
        public String generateDisplayNameForNestedClass(List<Class<?>> enclosingInstanceTypes, Class<?> nestedClass) {
            return this.getSentenceBeginning(nestedClass, enclosingInstanceTypes);
        }

        @Override
        public String generateDisplayNameForMethod(List<Class<?>> enclosingInstanceTypes, Class<?> testClass, Method testMethod) {
            return this.getSentenceBeginning(testClass, enclosingInstanceTypes) + IndicativeSentences.getFragmentSeparator(testClass, enclosingInstanceTypes) + IndicativeSentences.getGeneratorFor(testClass, enclosingInstanceTypes).generateDisplayNameForMethod(enclosingInstanceTypes, testClass, testMethod);
        }

        private String getSentenceBeginning(Class<?> testClass, List<Class<?>> enclosingInstanceTypes) {
            Class<?> enclosingClass = enclosingInstanceTypes.isEmpty() ? null : enclosingInstanceTypes.get(enclosingInstanceTypes.size() - 1);
            boolean topLevelTestClass = enclosingClass == null || ModifierSupport.isStatic(testClass);
            Optional<String> displayName = AnnotationSupport.findAnnotation(testClass, DisplayName.class).map(DisplayName::value).map(String::trim);
            if (topLevelTestClass) {
                if (displayName.isPresent()) {
                    return displayName.get();
                }
                Class generatorClass = IndicativeSentences.findDisplayNameGeneration(testClass, enclosingInstanceTypes).map(DisplayNameGeneration::value).filter(IndicativeSentences.not(IndicativeSentences.class)).orElse(null);
                if (generatorClass != null) {
                    return DisplayNameGenerator.getDisplayNameGenerator(generatorClass).generateDisplayNameForClass(testClass);
                }
                return this.generateDisplayNameForClass(testClass);
            }
            List<Class<?>> remainingEnclosingInstanceTypes = enclosingInstanceTypes.isEmpty() ? Collections.emptyList() : enclosingInstanceTypes.subList(0, enclosingInstanceTypes.size() - 1);
            boolean buildPrefix = IndicativeSentences.findDisplayNameGeneration(enclosingClass, remainingEnclosingInstanceTypes).map(DisplayNameGeneration::value).filter(IndicativeSentences.class::equals).isPresent();
            String prefix = buildPrefix ? this.getSentenceBeginning(enclosingClass, remainingEnclosingInstanceTypes) + IndicativeSentences.getFragmentSeparator(testClass, enclosingInstanceTypes) : "";
            return prefix + displayName.orElseGet(() -> IndicativeSentences.getGeneratorFor(testClass, enclosingInstanceTypes).generateDisplayNameForNestedClass(remainingEnclosingInstanceTypes, testClass));
        }

        private static String getFragmentSeparator(Class<?> testClass, List<Class<?>> enclosingInstanceTypes) {
            return IndicativeSentences.findIndicativeSentencesGeneration(testClass, enclosingInstanceTypes).map(IndicativeSentencesGeneration::separator).orElse(", ");
        }

        private static DisplayNameGenerator getGeneratorFor(Class<?> testClass, List<Class<?>> enclosingInstanceTypes) {
            return IndicativeSentences.findIndicativeSentencesGeneration(testClass, enclosingInstanceTypes).map(IndicativeSentencesGeneration::generator).filter(IndicativeSentences.not(IndicativeSentences.class)).map(DisplayNameGenerator::getDisplayNameGenerator).orElseGet(() -> DisplayNameGenerator.getDisplayNameGenerator(IndicativeSentencesGeneration.DEFAULT_GENERATOR));
        }

        @API(status=API.Status.INTERNAL, since="5.12")
        private static Optional<DisplayNameGeneration> findDisplayNameGeneration(Class<?> testClass, List<Class<?>> enclosingInstanceTypes) {
            return AnnotationSupport.findAnnotation(testClass, DisplayNameGeneration.class, enclosingInstanceTypes);
        }

        private static Optional<IndicativeSentencesGeneration> findIndicativeSentencesGeneration(Class<?> testClass, List<Class<?>> enclosingInstanceTypes) {
            return AnnotationSupport.findAnnotation(testClass, IndicativeSentencesGeneration.class, enclosingInstanceTypes);
        }

        private static Predicate<Class<?>> not(Class<?> clazz) {
            return ((Predicate<Class>)clazz::equals).negate();
        }
    }
}

