/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.validation;

import jakarta.validation.ValidationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.validation.MessageInterpolatorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

public class ValidatorAdapter
implements SmartValidator,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    private final SmartValidator target;
    private final boolean existingBean;

    ValidatorAdapter(SmartValidator target, boolean existingBean) {
        this.target = target;
        this.existingBean = existingBean;
    }

    public final Validator getTarget() {
        return this.target;
    }

    @Override
    public boolean supports(Class<?> type) {
        return this.target.supports(type);
    }

    @Override
    public void validate(Object target, Errors errors) {
        this.target.validate(target, errors);
    }

    @Override
    public void validate(Object target, Errors errors, Object ... validationHints) {
        this.target.validate(target, errors, validationHints);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SmartValidator smartValidator;
        if (!this.existingBean && (smartValidator = this.target) instanceof ApplicationContextAware) {
            ApplicationContextAware contextAwareTarget = (ApplicationContextAware)((Object)smartValidator);
            contextAwareTarget.setApplicationContext(applicationContext);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SmartValidator smartValidator;
        if (!this.existingBean && (smartValidator = this.target) instanceof InitializingBean) {
            InitializingBean initializingBean = (InitializingBean)((Object)smartValidator);
            initializingBean.afterPropertiesSet();
        }
    }

    @Override
    public void destroy() throws Exception {
        SmartValidator smartValidator;
        if (!this.existingBean && (smartValidator = this.target) instanceof DisposableBean) {
            DisposableBean disposableBean = (DisposableBean)((Object)smartValidator);
            disposableBean.destroy();
        }
    }

    public static Validator get(ApplicationContext applicationContext, Validator validator) {
        if (validator != null) {
            return ValidatorAdapter.wrap(validator, false);
        }
        return ValidatorAdapter.getExistingOrCreate(applicationContext);
    }

    private static Validator getExistingOrCreate(ApplicationContext applicationContext) {
        Validator existing = ValidatorAdapter.getExisting(applicationContext);
        if (existing != null) {
            return ValidatorAdapter.wrap(existing, true);
        }
        return ValidatorAdapter.create(applicationContext);
    }

    private static Validator getExisting(ApplicationContext applicationContext) {
        try {
            jakarta.validation.Validator validatorBean = applicationContext.getBean(jakarta.validation.Validator.class);
            if (validatorBean instanceof Validator) {
                Validator validator = (Validator)validatorBean;
                return validator;
            }
            return new SpringValidatorAdapter(validatorBean);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private static Validator create(MessageSource messageSource) {
        OptionalValidatorFactoryBean validator = new OptionalValidatorFactoryBean();
        try {
            MessageInterpolatorFactory factory = new MessageInterpolatorFactory(messageSource);
            validator.setMessageInterpolator(factory.getObject());
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return ValidatorAdapter.wrap(validator, false);
    }

    private static Validator wrap(Validator validator, boolean existingBean) {
        if (validator instanceof jakarta.validation.Validator) {
            jakarta.validation.Validator jakartaValidator = (jakarta.validation.Validator)validator;
            if (jakartaValidator instanceof SpringValidatorAdapter) {
                SpringValidatorAdapter adapter = (SpringValidatorAdapter)jakartaValidator;
                return new ValidatorAdapter(adapter, existingBean);
            }
            return new ValidatorAdapter(new SpringValidatorAdapter(jakartaValidator), existingBean);
        }
        return validator;
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this.target)) {
            return (T)this.target;
        }
        return this.target.unwrap(type);
    }
}

