/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.buffer.netty;

import io.micronaut.buffer.netty.NettyByteBuffer;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.nio.ByteBuffer;

@Internal
@Singleton
@BootstrapContextCompatible
public class NettyByteBufferFactory
implements ByteBufferFactory<ByteBufAllocator, ByteBuf> {
    public static final NettyByteBufferFactory DEFAULT = new NettyByteBufferFactory();
    private final ByteBufAllocator allocator;

    public NettyByteBufferFactory() {
        this.allocator = ByteBufAllocator.DEFAULT;
    }

    public NettyByteBufferFactory(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @PostConstruct
    final void register(ConversionService<?> conversionService) {
        conversionService.addConverter(ByteBuf.class, io.micronaut.core.io.buffer.ByteBuffer.class, DEFAULT::wrap);
        conversionService.addConverter(io.micronaut.core.io.buffer.ByteBuffer.class, ByteBuf.class, byteBuffer -> {
            if (byteBuffer instanceof NettyByteBuffer) {
                return (ByteBuf)byteBuffer.asNativeBuffer();
            }
            throw new IllegalArgumentException("Unconvertible buffer type " + byteBuffer);
        });
    }

    @Override
    public ByteBufAllocator getNativeAllocator() {
        return this.allocator;
    }

    @Override
    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> buffer() {
        return new NettyByteBuffer(this.allocator.buffer());
    }

    @Override
    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> buffer(int initialCapacity) {
        return new NettyByteBuffer(this.allocator.buffer(initialCapacity));
    }

    @Override
    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> buffer(int initialCapacity, int maxCapacity) {
        return new NettyByteBuffer(this.allocator.buffer(initialCapacity, maxCapacity));
    }

    @Override
    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> copiedBuffer(byte[] bytes) {
        if (bytes.length == 0) {
            return new NettyByteBuffer(Unpooled.EMPTY_BUFFER);
        }
        return new NettyByteBuffer(Unpooled.copiedBuffer(bytes));
    }

    @Override
    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> copiedBuffer(ByteBuffer nioBuffer) {
        return new NettyByteBuffer(Unpooled.copiedBuffer(nioBuffer));
    }

    @Override
    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> wrap(ByteBuf existing) {
        return new NettyByteBuffer(existing);
    }

    @Override
    public io.micronaut.core.io.buffer.ByteBuffer<ByteBuf> wrap(byte[] existing) {
        return new NettyByteBuffer(Unpooled.wrappedBuffer(existing));
    }
}

