/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.connector.file.table.stream.PartitionCommitPredicate;

@Internal
public class ProcTimeCommitPredicate
implements PartitionCommitPredicate {
    private final long commitDelay;

    public ProcTimeCommitPredicate(Configuration conf) {
        this.commitDelay = conf.get(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_DELAY).toMillis();
    }

    @Override
    public boolean isPartitionCommittable(PartitionCommitPredicate.PredicateContext predicateContext) {
        long currentProcTime = predicateContext.currentProcTime();
        return this.commitDelay == 0L || currentProcTime > predicateContext.createProcTime() + this.commitDelay;
    }
}

