/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.schema;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.table.types.logical.LogicalType;

public interface SchemaChange {
    public static SchemaChange setOption(String key, String value) {
        return new SetOption(key, value);
    }

    public static SchemaChange removeOption(String key) {
        return new RemoveOption(key);
    }

    public static SchemaChange addColumn(String fieldName, LogicalType logicalType) {
        return SchemaChange.addColumn(fieldName, logicalType, true, null);
    }

    public static SchemaChange addColumn(String fieldName, LogicalType logicalType, boolean isNullable, String comment) {
        return new AddColumn(fieldName, logicalType, isNullable, comment);
    }

    public static SchemaChange updateColumnType(String fieldName, LogicalType newLogicalType) {
        return new UpdateColumnType(fieldName, newLogicalType);
    }

    public static SchemaChange updateColumnNullability(String[] fieldNames, boolean newNullability) {
        return new UpdateColumnNullability(fieldNames, newNullability);
    }

    public static SchemaChange updateColumnComment(String[] fieldNames, String comment) {
        return new UpdateColumnComment(fieldNames, comment);
    }

    public static final class UpdateColumnComment
    implements SchemaChange {
        private final String[] fieldNames;
        private final String newDescription;

        public UpdateColumnComment(String[] fieldNames, String newDescription) {
            this.fieldNames = fieldNames;
            this.newDescription = newDescription;
        }

        public String[] fieldNames() {
            return this.fieldNames;
        }

        public String newDescription() {
            return this.newDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UpdateColumnComment)) {
                return false;
            }
            UpdateColumnComment that = (UpdateColumnComment)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newDescription.equals(that.newDescription);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDescription);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class UpdateColumnNullability
    implements SchemaChange {
        private final String[] fieldNames;
        private final boolean newNullability;

        public UpdateColumnNullability(String[] fieldNames, boolean newNullability) {
            this.fieldNames = fieldNames;
            this.newNullability = newNullability;
        }

        public String[] fieldNames() {
            return this.fieldNames;
        }

        public boolean newNullability() {
            return this.newNullability;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UpdateColumnNullability)) {
                return false;
            }
            UpdateColumnNullability that = (UpdateColumnNullability)o;
            return this.newNullability == that.newNullability && Arrays.equals(this.fieldNames, that.fieldNames);
        }

        public int hashCode() {
            int result = Objects.hash(this.newNullability);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class UpdateColumnType
    implements SchemaChange {
        private final String fieldName;
        private final LogicalType newLogicalType;

        private UpdateColumnType(String fieldName, LogicalType newLogicalType) {
            this.fieldName = fieldName;
            this.newLogicalType = newLogicalType;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public LogicalType newLogicalType() {
            return this.newLogicalType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnType that = (UpdateColumnType)o;
            return Objects.equals(this.fieldName, that.fieldName) && this.newLogicalType.equals(that.newLogicalType);
        }

        public int hashCode() {
            int result = Objects.hash(this.newLogicalType);
            result = 31 * result + Objects.hashCode(this.fieldName);
            return result;
        }
    }

    public static final class AddColumn
    implements SchemaChange {
        private final String fieldName;
        private final LogicalType logicalType;
        private final boolean isNullable;
        private final String description;

        private AddColumn(String fieldName, LogicalType logicalType, boolean isNullable, String description) {
            this.fieldName = fieldName;
            this.logicalType = logicalType;
            this.isNullable = isNullable;
            this.description = description;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public LogicalType logicalType() {
            return this.logicalType;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        @Nullable
        public String description() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddColumn addColumn = (AddColumn)o;
            return this.isNullable == addColumn.isNullable && Objects.equals(this.fieldName, addColumn.fieldName) && this.logicalType.equals(addColumn.logicalType) && Objects.equals(this.description, addColumn.description);
        }

        public int hashCode() {
            int result = Objects.hash(this.logicalType, this.isNullable, this.description);
            result = 31 * result + Objects.hashCode(this.fieldName);
            return result;
        }
    }

    public static final class RemoveOption
    implements SchemaChange {
        private final String key;

        private RemoveOption(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveOption that = (RemoveOption)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    public static final class SetOption
    implements SchemaChange {
        private final String key;
        private final String value;

        private SetOption(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetOption that = (SetOption)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

