/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import java.io.Serializable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;

public class OffsetOverFrame
implements OverWindowFrame {
    private GeneratedAggsHandleFunction aggsHandleFunction;
    private final Long offset;
    private final CalcOffsetFunc calcOffsetFunc;
    private AggsHandleFunction processor;
    private ResettableExternalBuffer.BufferIterator inputIterator;
    private long inputIndex = 0L;
    private ResettableExternalBuffer externalBuffer;
    private long currentBufferLength = 0L;

    public OffsetOverFrame(GeneratedAggsHandleFunction aggsHandleFunction, Long offset, CalcOffsetFunc calcOffsetFunc) {
        this.aggsHandleFunction = aggsHandleFunction;
        this.offset = offset;
        this.calcOffsetFunc = calcOffsetFunc;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        this.processor = (AggsHandleFunction)this.aggsHandleFunction.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader());
        this.processor.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.aggsHandleFunction = null;
    }

    @Override
    public void prepare(ResettableExternalBuffer rows) throws Exception {
        this.processor.setAccumulators(this.processor.createAccumulators());
        this.currentBufferLength = rows.size();
        if (this.calcOffsetFunc == null) {
            this.inputIndex = this.offset;
            if (this.inputIterator != null) {
                this.inputIterator.close();
            }
            this.inputIterator = this.offset >= 0L ? rows.newIterator((int)this.inputIndex) : rows.newIterator();
        } else {
            this.externalBuffer = rows;
        }
    }

    @Override
    public RowData process(int index, RowData current) throws Exception {
        if (this.calcOffsetFunc != null) {
            long realIndex = this.calcOffsetFunc.calc(current) + (long)index;
            if (realIndex >= 0L && realIndex < this.currentBufferLength) {
                ResettableExternalBuffer.BufferIterator tempIterator = this.externalBuffer.newIterator((int)realIndex);
                this.processor.accumulate(OverWindowFrame.getNextOrNull(tempIterator));
                tempIterator.close();
            } else {
                this.processor.retract(current);
            }
        } else {
            if (this.inputIndex >= 0L && this.inputIndex < this.currentBufferLength) {
                this.processor.accumulate(OverWindowFrame.getNextOrNull(this.inputIterator));
            } else {
                this.processor.retract(current);
            }
            ++this.inputIndex;
        }
        return this.processor.getValue();
    }

    public static interface CalcOffsetFunc
    extends Serializable {
        public long calc(RowData var1);
    }
}

