/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.util.MutableObjectIterator;

public class InputViewIterator<E>
implements MutableObjectIterator<E> {
    private DataInputView inputView;
    private final TypeSerializer<E> serializer;

    public InputViewIterator(DataInputView inputView, TypeSerializer<E> serializer) {
        this.inputView = inputView;
        this.serializer = serializer;
    }

    @Override
    public E next(E reuse) throws IOException {
        try {
            return this.serializer.deserialize(reuse, this.inputView);
        }
        catch (EOFException e) {
            return null;
        }
    }

    @Override
    public E next() throws IOException {
        try {
            return this.serializer.deserialize(this.inputView);
        }
        catch (EOFException e) {
            return null;
        }
    }
}

