/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ToolParameters {
    private final Map<String, Object> parameters;

    public ToolParameters() {
        this.parameters = new HashMap<String, Object>();
    }

    public ToolParameters(Map<String, Object> parameters) {
        this.parameters = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap();
    }

    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public <T> T getParameter(String name, Class<T> type) {
        Object value = this.parameters.get(name);
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        return this.convertValue(value, type);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public List<Object> getParameters() {
        return List.copyOf(this.parameters.values());
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    private <T> T convertValue(Object value, Class<T> type) {
        String stringValue = value.toString();
        if (type == String.class) {
            return (T)stringValue;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(stringValue);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(stringValue);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(stringValue);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(stringValue);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(stringValue);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(stringValue);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(stringValue);
        }
        throw new IllegalArgumentException("Cannot convert parameter value to type " + type.getSimpleName());
    }

    public String toString() {
        return "ToolParameters{" + String.valueOf(this.parameters) + "}";
    }
}

